/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.transactionmonitor.DiscoveryResolution;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.CustomMatchPointDefinition;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.DiscoveryNamingConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ExcludeRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.MatchPointDiscoveryConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatchType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.TransactionMatchPointConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.binary.remoting.BinaryRemotingNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.asp.ASPDotNetMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.asp.ASPDotNetNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.jms.DotNetJMSNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.poco.POCONamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.remoting.DotNetRemotingNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.wcf.WCFNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.webservices.ASPDotNetWebServiceNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ejb.EJBNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.HTTPMethod;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ServletMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ServletNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.JMSNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.nodeJS.web.NodeJSWebMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.cli.PHPCLINamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.drupal.PHPDrupalNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.mvc.PHPMVCNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.webservices.PHPWebServiceNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.wordpress.PHPWordpressNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJOMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJOMatchType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJONamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.SplitConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.python.web.PythonWebMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ruby.rails.RubyRailsNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.spring.beans.SpringBeanNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.struts.StrutsActionNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.webservices.WebServiceNamingSchemeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultTransactionMatchPointConfig {
    public static final AtomicLong idGenerator = new AtomicLong(0L);
    private static final Map<String, List<? extends Enum>> entryTypeVsNamingTypes;
    private static final Map<String, DiscoveryNamingConfig> entryTypeVsDefaultNamingScheme;

    public static Map<String, List<? extends Enum>> getEntryTypeVsNamingTypes() {
        return entryTypeVsNamingTypes;
    }

    public static Map<String, DiscoveryNamingConfig> getEntryTypeVsDefaultNamingScheme() {
        return entryTypeVsDefaultNamingScheme;
    }

    public static List<TransactionMatchPointConfig> getDefaultTransactionMatchPointConfigs(AgentType agentType, EntityDefinition attachedEntity) {
        return DefaultTransactionMatchPointConfig.getDefaultTransactionMatchPointConfigs(agentType, attachedEntity, null);
    }

    public static List<TransactionMatchPointConfig> getDefaultTransactionMatchPointConfigs(AgentType agentType, EntityDefinition attachedEntity, AtomicLong cpmdIdGenerator) {
        ArrayList<TransactionMatchPointConfig> subConfigs = new ArrayList<TransactionMatchPointConfig>();
        for (String type : TransactionEntryPointTypeHelper.getTransactionEntryPointTypes()) {
            boolean virtualTier;
            Set agentRuntimes = TransactionEntryPointTypeHelper.getRelevantAgentRuntimes((String)type);
            if (!agentRuntimes.contains(agentType)) continue;
            TransactionMatchPointConfig subConfig = new TransactionMatchPointConfig();
            boolean bl = virtualTier = attachedEntity.getEntityId() < 0L;
            if (virtualTier) {
                Set<CustomMatchPointDefinition> pojoRules;
                subConfig.setId(idGenerator.decrementAndGet());
                if (type.equals("POJO") && (pojoRules = DefaultTransactionMatchPointConfig.getDefaultPOJORules()) != null && pojoRules.size() > 0) {
                    ArrayList<CustomMatchPointDefinition> customMatchPointDefinitions = new ArrayList<CustomMatchPointDefinition>(pojoRules.size());
                    for (CustomMatchPointDefinition pojoRule : pojoRules) {
                        pojoRule.setId(cpmdIdGenerator.decrementAndGet());
                        pojoRule.setAttachedEntity(attachedEntity);
                        customMatchPointDefinitions.add(pojoRule);
                    }
                    subConfig.setCustomDefinitions(customMatchPointDefinitions);
                }
            }
            MatchPointDiscoveryConfig discoveryConfig = new MatchPointDiscoveryConfig();
            discoveryConfig.setEnabled(TransactionEntryPointTypeHelper.isAutoDiscoveryEnabled((String)type));
            ExcludeRule[] excludeRules = DefaultTransactionMatchPointConfig.getDefaultExcludes(type);
            if (null != excludeRules && virtualTier) {
                for (ExcludeRule excludeRule : excludeRules) {
                    excludeRule.setId(idGenerator.decrementAndGet());
                }
            }
            discoveryConfig.setExcludes(excludeRules);
            discoveryConfig.setNamingConfig(DefaultTransactionMatchPointConfig.getEntryTypeVsDefaultNamingScheme().get(type));
            discoveryConfig.setDiscoveryResolution(DiscoveryResolution.FIRST_ENTRY_POINT);
            subConfig.setAttachedEntity(attachedEntity);
            subConfig.setAgentType(agentType);
            subConfig.setEnabled(true);
            subConfig.setEntryPointTypeString(type);
            subConfig.setName(type);
            subConfig.setDiscoveryConfig(discoveryConfig);
            subConfigs.add(subConfig);
        }
        return subConfigs;
    }

    private static ExcludeRule[] getDefaultExcludes(String entryPointType) {
        ArrayList<ExcludeRule> rules = new ArrayList<ExcludeRule>();
        if (entryPointType.equals("SERVLET")) {
            ExcludeRule rule = new ExcludeRule();
            rule.setName("Apache Axis Servlet");
            ServletMatchRule matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.apache.axis.transport.http.AxisServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Apache Axis2 Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.apache.axis2.transport.http.AxisServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Apache Axis2 Admin Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.apache.axis2.transport.http.AxisAdminServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Struts Action Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.apache.struts.action.ActionServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Websphere web-services Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Websphere web-services axis Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("JBoss web-services servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.jboss.wsf.stack.jbws.EndpointServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("XFire web-services servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.codehaus.xfire.transport.http.XFireConfigurableServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Weblogic JAX RPC Servlets");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.STARTSWITH, "weblogic.wsee.server.servlet."));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Weblogic JAX WS Webservice Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "weblogic.wsee.jaxws.JAXWSServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Weblogic JAX WS Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "weblogic.wsee.jaxws.JAXWSWebAppServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("JAX WS RI Dispatcher Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "com.sun.xml.ws.transport.http.servlet.WSServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Spring WS - dispatching of Web service messages");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.springframework.ws.transport.http.MessageDispatcherServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Spring WS - Base servlet for Spring's web framework");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.springframework.web.servlet.FrameworkServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("CometD Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.cometd.server.CometdServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("CometD Annotation Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.cometd.annotation.AnnotationCometdServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Jersey Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "com.sun.jersey.spi.container.servlet.ServletContainer"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("Jersey 2.x Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.glassfish.jersey.servlet.ServletContainer"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("JBoss 6.x web-services Servlet");
            matchRule = new ServletMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "org.jboss.wsf.spi.deployment.WSFServlet"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            return rules.toArray(new ExcludeRule[rules.size()]);
        }
        if (entryPointType.equals("ASP_DOTNET")) {
            ExcludeRule rule = new ExcludeRule();
            rule.setName("ASP.NET WebService Session Handler");
            ASPDotNetMatchRule matchRule = new ASPDotNetMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "System.Web.Services.Protocols.SyncSessionlessHandler"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("ASP.NET WebService Script Handler");
            matchRule = new ASPDotNetMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.INLIST, "System.Web.Script.Services.ScriptHandlerFactory+HandlerWrapper,System.Web.Script.Services.ScriptHandlerFactory+HandlerWrapperWithSession,System.Web.Script.Services.ScriptHandlerFactory+AsyncHandlerWrapper,System.Web.Script.Services.ScriptHandlerFactory+AsyncHandlerWrapperWithSession"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("ASP.NET WCF Activation Handler");
            matchRule = new ASPDotNetMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "System.ServiceModel.Activation.HttpHandler"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            rule = new ExcludeRule();
            rule.setName("ASP.NET MVC5 Resource Handler");
            matchRule = new ASPDotNetMatchRule();
            matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "System.Web.Optimization.BundleHandler"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            return rules.toArray(new ExcludeRule[rules.size()]);
        }
        if (entryPointType.equals("NODEJS_WEB")) {
            ExcludeRule rule = new ExcludeRule();
            rule.setName("NodeJS Static Content Filter");
            NodeJSWebMatchRule matchRule = new NodeJSWebMatchRule();
            matchRule.setHttpMethod(HTTPMethod.GET);
            matchRule.setUri(new StringMatch(StringMatchType.REGEX, "robots.txt|.*\\.(js|css|png|gif|jpg|jpeg|ico)$"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            return rules.toArray(new ExcludeRule[rules.size()]);
        }
        if (entryPointType.equals("PYTHON_WEB")) {
            ExcludeRule rule = new ExcludeRule();
            rule.setName("Python Static Content Filter");
            PythonWebMatchRule matchRule = new PythonWebMatchRule();
            matchRule.setHttpMethod(HTTPMethod.GET);
            matchRule.setUri(new StringMatch(StringMatchType.REGEX, "robots.txt|.*\\.(js|css|png|gif|jpg|jpeg|ico)$"));
            rule.setMatchPointRule((IMatchPointRule)matchRule);
            rules.add(rule);
            return rules.toArray(new ExcludeRule[rules.size()]);
        }
        return new ExcludeRule[0];
    }

    public static Set<CustomMatchPointDefinition> getDefaultPOJORules() {
        HashSet<CustomMatchPointDefinition> mpdSet = new HashSet<CustomMatchPointDefinition>();
        for (POJOMatchRule rule : DefaultTransactionMatchPointConfig.getSchedulerRules()) {
            CustomMatchPointDefinition def = new CustomMatchPointDefinition();
            def.setName(rule.getDisplayName());
            def.setMatchPointRule((IMatchPointRule)rule);
            def.setEntryPointTypeString("POJO");
            def.setAgentType(AgentType.APP_AGENT);
            mpdSet.add(def);
        }
        return mpdSet;
    }

    private static List<POJOMatchRule> getSchedulerRules() {
        ArrayList<POJOMatchRule> rules = new ArrayList<POJOMatchRule>();
        boolean enabled = false;
        POJOMatchRule pojoRule = new POJOMatchRule();
        pojoRule.setBackgroundTask(true);
        pojoRule.setEnabled(enabled);
        pojoRule.setMatchClassType(POJOMatchType.IMPLEMENTS_INTERFACE);
        pojoRule.setClassMatch(new StringMatch(StringMatchType.EQUALS, "org.quartz.Job"));
        pojoRule.setDisplayName("Quartz");
        pojoRule.setMethodMatch(new StringMatch[]{new StringMatch(StringMatchType.EQUALS, "execute")});
        SplitConfig splitConfig = new SplitConfig();
        splitConfig.setSplitOperationType(4);
        pojoRule.setSplitConfig(new SplitConfig[]{splitConfig});
        rules.add(pojoRule);
        pojoRule = new POJOMatchRule();
        pojoRule.setBackgroundTask(true);
        pojoRule.setEnabled(enabled);
        pojoRule.setMatchClassType(POJOMatchType.INHERITS_FROM_CLASS);
        pojoRule.setClassMatch(new StringMatch(StringMatchType.EQUALS, "java.util.TimerTask"));
        pojoRule.setDisplayName("JavaTimer");
        pojoRule.setMethodMatch(new StringMatch[]{new StringMatch(StringMatchType.EQUALS, "run")});
        splitConfig = new SplitConfig();
        splitConfig.setSplitOperationType(4);
        pojoRule.setSplitConfig(new SplitConfig[]{splitConfig});
        rules.add(pojoRule);
        pojoRule = new POJOMatchRule();
        pojoRule.setBackgroundTask(true);
        pojoRule.setEnabled(enabled);
        pojoRule.setMatchClassType(POJOMatchType.INHERITS_FROM_CLASS);
        pojoRule.setClassMatch(new StringMatch(StringMatchType.EQUALS, "it.sauronsoftware.cron4j.Task"));
        pojoRule.setDisplayName("Cron4J");
        pojoRule.setMethodMatch(new StringMatch[]{new StringMatch(StringMatchType.EQUALS, "execute")});
        splitConfig = new SplitConfig();
        splitConfig.setSplitOperationType(4);
        pojoRule.setSplitConfig(new SplitConfig[]{splitConfig});
        rules.add(pojoRule);
        pojoRule = new POJOMatchRule();
        pojoRule.setBackgroundTask(true);
        pojoRule.setEnabled(enabled);
        pojoRule.setMatchClassType(POJOMatchType.MATCHES_CLASS);
        pojoRule.setClassMatch(new StringMatch(StringMatchType.EQUALS, "org.jcrontab.CronTask"));
        pojoRule.setDisplayName("JCronTab");
        pojoRule.setMethodMatch(new StringMatch[]{new StringMatch(StringMatchType.EQUALS, "runTask")});
        splitConfig = new SplitConfig();
        splitConfig.setSplitOperationType(2);
        splitConfig.setSplitOperation("strClassName");
        pojoRule.setSplitConfig(new SplitConfig[]{splitConfig});
        rules.add(pojoRule);
        return rules;
    }

    static {
        HashMap<String, DiscoveryNamingConfig> tmpEntryTypeVsDefaultNamingScheme = new HashMap<String, DiscoveryNamingConfig>();
        HashMap<String, List<Object>> tmpEntryTypeVsNamingTypes = new HashMap<String, List<Object>>();
        tmpEntryTypeVsNamingTypes.put("EJB", Arrays.asList(EJBNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("EJB", new DiscoveryNamingConfig(EJBNamingSchemeType.EJB_NAME_AND_METHOD_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("JMS", Arrays.asList(JMSNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("JMS", new DiscoveryNamingConfig(JMSNamingSchemeType.DESTINATION_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("POJO", Arrays.asList(POJONamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("POJO", new DiscoveryNamingConfig(POJONamingSchemeType.FULLY_QUALIFIED_CLASS_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("SERVLET", Arrays.asList(ServletNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("SERVLET", new DiscoveryNamingConfig(ServletNamingSchemeType.URI.name(), new NameValuePair[]{new NameValuePair("uri-length", "first-n-segments"), new NameValuePair("segment-length", "2")}));
        tmpEntryTypeVsNamingTypes.put("SPRING_BEAN", Arrays.asList(SpringBeanNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("SPRING_BEAN", new DiscoveryNamingConfig(SpringBeanNamingSchemeType.BEAN_ID_AND_METHOD_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("STRUTS_ACTION", Arrays.asList(StrutsActionNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("STRUTS_ACTION", new DiscoveryNamingConfig(StrutsActionNamingSchemeType.ACTION_NAME_AND_METHOD_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("WEB_SERVICE", Arrays.asList(WebServiceNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("WEB_SERVICE", new DiscoveryNamingConfig(WebServiceNamingSchemeType.SERVICE_NAME_AND_OPERATION_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("ASP_DOTNET", Arrays.asList(ASPDotNetNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("ASP_DOTNET", new DiscoveryNamingConfig(ASPDotNetNamingSchemeType.URI.name(), new NameValuePair[]{new NameValuePair("uri-length", "first-n-segments"), new NameValuePair("segment-length", "2")}));
        tmpEntryTypeVsNamingTypes.put("DOTNET_REMOTING", Arrays.asList(DotNetRemotingNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("DOTNET_REMOTING", new DiscoveryNamingConfig(DotNetRemotingNamingSchemeType.SIMPLE_CLASS_NAME_AND_METHOD_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("ASP_DOTNET_WEB_SERVICE", Arrays.asList(ASPDotNetWebServiceNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("ASP_DOTNET_WEB_SERVICE", new DiscoveryNamingConfig(ASPDotNetWebServiceNamingSchemeType.SERVICE_NAME_AND_OPERATION_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("WCF", Arrays.asList(WCFNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("WCF", new DiscoveryNamingConfig(WCFNamingSchemeType.SERVICE_NAME_AND_OPERATION_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("DOTNET_JMS", Arrays.asList(DotNetJMSNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("DOTNET_JMS", new DiscoveryNamingConfig(DotNetJMSNamingSchemeType.DESTINATION_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("POCO", Arrays.asList(POCONamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("POCO", new DiscoveryNamingConfig(POCONamingSchemeType.SIMPLE_CLASS_NAME_AND_METHOD_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("PHP_DRUPAL", Arrays.asList(PHPDrupalNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("PHP_DRUPAL", new DiscoveryNamingConfig(PHPDrupalNamingSchemeType.DEFAULT.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("PHP_CLI", Arrays.asList(PHPCLINamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("PHP_CLI", new DiscoveryNamingConfig(PHPCLINamingSchemeType.DEFAULT.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("PHP_MVC", Arrays.asList(PHPMVCNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("PHP_MVC", new DiscoveryNamingConfig(PHPMVCNamingSchemeType.ACTION_CLASS_NAME_AND_METHOD_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("PHP_WEB", Arrays.asList(ServletNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("PHP_WEB", new DiscoveryNamingConfig(ServletNamingSchemeType.URI.name(), new NameValuePair[]{new NameValuePair("uri-length", "first-n-segments"), new NameValuePair("segment-length", "2")}));
        tmpEntryTypeVsNamingTypes.put("PHP_WORDPRESS", Arrays.asList(PHPWordpressNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("PHP_WORDPRESS", new DiscoveryNamingConfig(PHPWordpressNamingSchemeType.DEFAULT.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("PHP_WEB_SERVICE", Arrays.asList(PHPWebServiceNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("PHP_WEB_SERVICE", new DiscoveryNamingConfig(PHPWebServiceNamingSchemeType.SERVICE_NAME_AND_OPERATION_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("NODEJS_WEB", Arrays.asList(ServletNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("NODEJS_WEB", new DiscoveryNamingConfig(ServletNamingSchemeType.URI.name(), new NameValuePair[]{new NameValuePair("uri-length", "first-n-segments"), new NameValuePair("segment-length", "2")}));
        tmpEntryTypeVsNamingTypes.put("NATIVE", Arrays.asList(ServletNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("NATIVE", new DiscoveryNamingConfig(ServletNamingSchemeType.URI.name(), new NameValuePair[]{new NameValuePair("uri-length", "first-n-segments"), new NameValuePair("segment-length", "2")}));
        tmpEntryTypeVsNamingTypes.put("WEB", Arrays.asList(ServletNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("WEB", new DiscoveryNamingConfig(ServletNamingSchemeType.URI.name(), new NameValuePair[]{new NameValuePair("uri-length", "first-n-segments"), new NameValuePair("segment-length", "2")}));
        tmpEntryTypeVsNamingTypes.put("PYTHON_WEB", Arrays.asList(ServletNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("PYTHON_WEB", new DiscoveryNamingConfig(ServletNamingSchemeType.URI.name(), new NameValuePair[]{new NameValuePair("uri-length", "first-n-segments"), new NameValuePair("segment-length", "2")}));
        tmpEntryTypeVsNamingTypes.put("RUBY_WEB", Arrays.asList(ServletNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("RUBY_WEB", new DiscoveryNamingConfig(ServletNamingSchemeType.URI.name(), new NameValuePair[]{new NameValuePair("uri-length", "first-n-segments"), new NameValuePair("segment-length", "2")}));
        tmpEntryTypeVsNamingTypes.put("RUBY_RAILS", Arrays.asList(RubyRailsNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("RUBY_RAILS", new DiscoveryNamingConfig(RubyRailsNamingSchemeType.CONTROLLER_NAME_AND_ACTION_NAME.name(), new NameValuePair[0]));
        tmpEntryTypeVsNamingTypes.put("BINARY_REMOTING", Arrays.asList(BinaryRemotingNamingSchemeType.values()));
        tmpEntryTypeVsDefaultNamingScheme.put("BINARY_REMOTING", new DiscoveryNamingConfig(BinaryRemotingNamingSchemeType.SIMPLE_CLASS_NAME_AND_METHOD_NAME.name(), new NameValuePair[0]));
        entryTypeVsNamingTypes = Collections.unmodifiableMap(tmpEntryTypeVsNamingTypes);
        entryTypeVsDefaultNamingScheme = Collections.unmodifiableMap(tmpEntryTypeVsDefaultNamingScheme);
    }
}

