/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class ActionPlanHelper {
    private static final List<EventType> supportedEventTypes;
    private static Map<EventType, NotificationSeverity> eventTypeNotificationSeverityMap;

    public static List<EventType> getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public static Map<EventType, NotificationSeverity> getEventTypeNotificationSeverityMap() {
        if (eventTypeNotificationSeverityMap == null) {
            EnumMap<EventType, NotificationSeverity> map = new EnumMap<EventType, NotificationSeverity>(EventType.class);
            map.put(EventType.POLICY_OPEN, NotificationSeverity.WARN);
            map.put(EventType.POLICY_OPEN_WARNING, NotificationSeverity.WARN);
            map.put(EventType.POLICY_DOWNGRADED, NotificationSeverity.WARN);
            map.put(EventType.POLICY_CONTINUES_WARNING, NotificationSeverity.WARN);
            map.put(EventType.POLICY_CLOSE, NotificationSeverity.WARN);
            map.put(EventType.POLICY_CLOSE_WARNING, NotificationSeverity.WARN);
            map.put(EventType.POLICY_CLOSE_CRITICAL, NotificationSeverity.WARN);
            map.put(EventType.POLICY_CANCELLED, NotificationSeverity.WARN);
            map.put(EventType.POLICY_CANCELED_WARNING, NotificationSeverity.WARN);
            map.put(EventType.POLICY_CANCELED_CRITICAL, NotificationSeverity.WARN);
            map.put(EventType.POLICY_UPGRADED, NotificationSeverity.ERROR);
            map.put(EventType.POLICY_OPEN_CRITICAL, NotificationSeverity.ERROR);
            map.put(EventType.POLICY_CONTINUES_CRITICAL, NotificationSeverity.ERROR);
            map.put(EventType.SLOW, NotificationSeverity.ERROR);
            map.put(EventType.VERY_SLOW, NotificationSeverity.ERROR);
            map.put(EventType.STALL, NotificationSeverity.ERROR);
            map.put(EventType.APPLICATION_ERROR, NotificationSeverity.ERROR);
            map.put(EventType.ERROR, NotificationSeverity.ERROR);
            map.put(EventType.DEADLOCK, NotificationSeverity.ERROR);
            map.put(EventType.RESOURCE_POOL_LIMIT, NotificationSeverity.ERROR);
            map.put(EventType.APPLICATION_DEPLOYMENT, NotificationSeverity.INFO);
            map.put(EventType.APP_SERVER_RESTART, NotificationSeverity.INFO);
            map.put(EventType.APPLICATION_CONFIG_CHANGE, NotificationSeverity.INFO);
            map.put(EventType.APPLICATION_CRASH, NotificationSeverity.ERROR);
            map.put(EventType.CLR_CRASH, NotificationSeverity.ERROR);
            map.put(EventType.AGENT_CONFIGURATION_ERROR, NotificationSeverity.ERROR);
            map.put(EventType.APPLICATION_DISCOVERED, NotificationSeverity.INFO);
            map.put(EventType.TIER_DISCOVERED, NotificationSeverity.INFO);
            map.put(EventType.NODE_DISCOVERED, NotificationSeverity.INFO);
            map.put(EventType.MACHINE_DISCOVERED, NotificationSeverity.INFO);
            map.put(EventType.BT_DISCOVERED, NotificationSeverity.INFO);
            map.put(EventType.SERVICE_ENDPOINT_DISCOVERED, NotificationSeverity.INFO);
            map.put(EventType.BACKEND_DISCOVERED, NotificationSeverity.INFO);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_HEALTHY_EVENT, NotificationSeverity.INFO);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_WARNING_EVENT, NotificationSeverity.WARN);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_CONFIRMED_WARNING_EVENT, NotificationSeverity.WARN);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_ONGOING_WARNING_EVENT, NotificationSeverity.WARN);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_ERROR_EVENT, NotificationSeverity.ERROR);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_CONFIRMED_ERROR_EVENT, NotificationSeverity.ERROR);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_ONGOING_ERROR_EVENT, NotificationSeverity.ERROR);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_HEALTHY_EVENT, NotificationSeverity.INFO);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_WARNING_EVENT, NotificationSeverity.WARN);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_CONFIRMED_WARNING_EVENT, NotificationSeverity.WARN);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_ONGOING_WARNING_EVENT, NotificationSeverity.WARN);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_CRITICAL_EVENT, NotificationSeverity.INFO);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_CONFIRMED_CRITICAL_EVENT, NotificationSeverity.ERROR);
            map.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_ONGOING_CRITICAL_EVENT, NotificationSeverity.WARN);
            map.put(EventType.MOBILE_NEW_CRASH_EVENT, NotificationSeverity.ERROR);
            map.put(EventType.EMAIL_ACTION_FAILED, NotificationSeverity.WARN);
            map.put(EventType.HTTP_REQUEST_ACTION_FAILED, NotificationSeverity.WARN);
            map.put(EventType.HTTP_REQUEST_ACTION_FAILED, NotificationSeverity.WARN);
            map.put(EventType.CUSTOM_ACTION_FAILED, NotificationSeverity.WARN);
            map.put(EventType.CUSTOM_EMAIL_ACTION_FAILED, NotificationSeverity.WARN);
            map.put(EventType.ANOMALY_OPEN_CRITICAL, NotificationSeverity.ERROR);
            map.put(EventType.ANOMALY_OPEN_WARNING, NotificationSeverity.WARN);
            map.put(EventType.ANOMALY_UPGRADED, NotificationSeverity.ERROR);
            map.put(EventType.ANOMALY_DOWNGRADED, NotificationSeverity.WARN);
            map.put(EventType.ANOMALY_CLOSE_CRITICAL, NotificationSeverity.INFO);
            map.put(EventType.ANOMALY_CLOSE_WARNING, NotificationSeverity.INFO);
            map.put(EventType.ANOMALY_CANCELED_CRITICAL, NotificationSeverity.INFO);
            map.put(EventType.ANOMALY_CANCELED_WARNING, NotificationSeverity.INFO);
            eventTypeNotificationSeverityMap = Collections.unmodifiableMap(map);
        }
        return eventTypeNotificationSeverityMap;
    }

    public static NotificationSeverity getOrDefaultNotificationSeverityForEventType(EventType eventType, NotificationSeverity defaultValue) {
        NotificationSeverity severity = ActionPlanHelper.getEventTypeNotificationSeverityMap().get(eventType);
        return severity == null ? defaultValue : severity;
    }

    public static NotificationSeverity getNotificationSeverityForEventType(EventType eventType) {
        return ActionPlanHelper.getEventTypeNotificationSeverityMap().get(eventType);
    }

    static {
        ArrayList<EventType> tmpSupportedEventTypes = new ArrayList<EventType>();
        tmpSupportedEventTypes.add(EventType.POLICY_OPEN_WARNING);
        tmpSupportedEventTypes.add(EventType.POLICY_OPEN_CRITICAL);
        tmpSupportedEventTypes.add(EventType.POLICY_CONTINUES_WARNING);
        tmpSupportedEventTypes.add(EventType.POLICY_CONTINUES_CRITICAL);
        tmpSupportedEventTypes.add(EventType.POLICY_UPGRADED);
        tmpSupportedEventTypes.add(EventType.POLICY_DOWNGRADED);
        tmpSupportedEventTypes.add(EventType.POLICY_CLOSE_WARNING);
        tmpSupportedEventTypes.add(EventType.POLICY_CLOSE_CRITICAL);
        tmpSupportedEventTypes.add(EventType.POLICY_CANCELED_WARNING);
        tmpSupportedEventTypes.add(EventType.POLICY_CANCELED_CRITICAL);
        tmpSupportedEventTypes.add(EventType.SLOW);
        tmpSupportedEventTypes.add(EventType.VERY_SLOW);
        tmpSupportedEventTypes.add(EventType.STALL);
        tmpSupportedEventTypes.add(EventType.APPLICATION_ERROR);
        tmpSupportedEventTypes.add(EventType.ERROR);
        tmpSupportedEventTypes.add(EventType.DEADLOCK);
        tmpSupportedEventTypes.add(EventType.RESOURCE_POOL_LIMIT);
        tmpSupportedEventTypes.add(EventType.APPLICATION_DEPLOYMENT);
        tmpSupportedEventTypes.add(EventType.APP_SERVER_RESTART);
        tmpSupportedEventTypes.add(EventType.APPLICATION_CONFIG_CHANGE);
        tmpSupportedEventTypes.add(EventType.APPLICATION_CRASH);
        tmpSupportedEventTypes.add(EventType.CLR_CRASH);
        tmpSupportedEventTypes.add(EventType.AGENT_CONFIGURATION_ERROR);
        tmpSupportedEventTypes.add(EventType.APPLICATION_DISCOVERED);
        tmpSupportedEventTypes.add(EventType.TIER_DISCOVERED);
        tmpSupportedEventTypes.add(EventType.NODE_DISCOVERED);
        tmpSupportedEventTypes.add(EventType.MACHINE_DISCOVERED);
        tmpSupportedEventTypes.add(EventType.BT_DISCOVERED);
        tmpSupportedEventTypes.add(EventType.SERVICE_ENDPOINT_DISCOVERED);
        tmpSupportedEventTypes.add(EventType.BACKEND_DISCOVERED);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_HEALTHY_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_WARNING_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_CONFIRMED_WARNING_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_ONGOING_WARNING_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_ERROR_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_CONFIRMED_ERROR_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_ONGOING_ERROR_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_PERF_HEALTHY_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_PERF_WARNING_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_PERF_CONFIRMED_WARNING_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_PERF_ONGOING_WARNING_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_PERF_CRITICAL_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_PERF_CONFIRMED_CRITICAL_EVENT);
        tmpSupportedEventTypes.add(EventType.EUM_CLOUD_SYNTHETIC_PERF_ONGOING_CRITICAL_EVENT);
        tmpSupportedEventTypes.add(EventType.MOBILE_NEW_CRASH_EVENT);
        tmpSupportedEventTypes.add(EventType.EMAIL_ACTION_FAILED);
        tmpSupportedEventTypes.add(EventType.HTTP_REQUEST_ACTION_FAILED);
        tmpSupportedEventTypes.add(EventType.CUSTOM_ACTION_FAILED);
        tmpSupportedEventTypes.add(EventType.CUSTOM_EMAIL_ACTION_FAILED);
        tmpSupportedEventTypes.add(EventType.ANOMALY_OPEN_CRITICAL);
        tmpSupportedEventTypes.add(EventType.ANOMALY_OPEN_WARNING);
        tmpSupportedEventTypes.add(EventType.ANOMALY_UPGRADED);
        tmpSupportedEventTypes.add(EventType.ANOMALY_DOWNGRADED);
        tmpSupportedEventTypes.add(EventType.ANOMALY_CLOSE_CRITICAL);
        tmpSupportedEventTypes.add(EventType.ANOMALY_CLOSE_WARNING);
        tmpSupportedEventTypes.add(EventType.ANOMALY_CANCELED_CRITICAL);
        tmpSupportedEventTypes.add(EventType.ANOMALY_CANCELED_WARNING);
        supportedEventTypes = Collections.unmodifiableList(tmpSupportedEventTypes);
    }
}

