/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.dbmon.api.dtos;

import java.util.Objects;

public class IdentifierProperties {
    private String hostName;
    private Integer port;
    private String vendor;
    private String schema;
    private String database;

    private IdentifierProperties() {
    }

    private IdentifierProperties(String hostName, Integer port, String vendor, String schema, String database) {
        this.hostName = hostName;
        this.port = port;
        this.vendor = vendor;
        this.schema = schema;
        this.database = database;
    }

    public static IdentifierProperties builder() {
        return new IdentifierProperties();
    }

    public IdentifierProperties hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public IdentifierProperties port(Integer port) {
        this.port = port;
        return this;
    }

    public IdentifierProperties vendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public IdentifierProperties schema(String schema) {
        this.schema = schema;
        return this;
    }

    public IdentifierProperties database(String database) {
        this.database = database;
        return this;
    }

    public IdentifierProperties build() {
        return new IdentifierProperties(this.hostName, this.port, this.vendor, this.schema, this.database);
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDatabase() {
        return this.database;
    }

    public String toString() {
        return "IdentifierProperties{hostName='" + this.hostName + '\'' + ", port=" + this.port + ", vendor='" + this.vendor + '\'' + ", schema='" + this.schema + '\'' + ", database='" + this.database + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifierProperties)) {
            return false;
        }
        IdentifierProperties that = (IdentifierProperties)o;
        return Objects.equals(this.getHostName(), that.getHostName()) && Objects.equals(this.getPort(), that.getPort()) && Objects.equals(this.getVendor(), that.getVendor()) && Objects.equals(this.getSchema(), that.getSchema()) && Objects.equals(this.getDatabase(), that.getDatabase());
    }

    public int hashCode() {
        return Objects.hash(this.getHostName(), this.getPort(), this.getVendor(), this.getSchema(), this.getDatabase());
    }
}

