/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.dbmon.api.dtos;

import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import java.util.Objects;
import javax.validation.constraints.Size;

@UiCodeGen
public class CustomJdbcConnectionProperty {
    private static final long serialVersionUID = 1L;
    public static final int MAX_CUSTOM_JDBC_CONNECTION_KEY_LENGTH = 128;
    public static final String CUSTOM_JDBC_CONNECTION_KEY_LENGTH_EXCEEDED_MSG_SUFFIX = "JDBC property key should not be greater than 128 characters";
    public static final int MAX_CUSTOM_JDBC_CONNECTION_VALUE_LENGTH = 512;
    public static final String CUSTOM_JDBC_CONNECTION_VALUE_LENGTH_EXCEEDED_MSG_SUFFIX = "JDBC property value should not be greater than 512 characters";
    @Size(max=128, message="JDBC property key should not be greater than 128 characters")
    private @Size(max=128, message="JDBC property key should not be greater than 128 characters") String key;
    @Size(max=512, message="JDBC property value should not be greater than 512 characters")
    private @Size(max=512, message="JDBC property value should not be greater than 512 characters") String value;
    private boolean redact;

    public CustomJdbcConnectionProperty() {
    }

    public CustomJdbcConnectionProperty(String key, String value, boolean redact) {
        this.key = key;
        this.value = value;
        this.redact = redact;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isRedact() {
        return this.redact;
    }

    public void setRedact(boolean redact) {
        this.redact = redact;
    }

    public int hashCode() {
        int keyHash = this.key != null ? this.key.hashCode() : 0;
        int valueHash = this.value != null ? this.value.hashCode() : 0;
        int result = keyHash + 31 * valueHash;
        result = 31 * result + (this.redact ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomJdbcConnectionProperty)) {
            return false;
        }
        CustomJdbcConnectionProperty that = (CustomJdbcConnectionProperty)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue()) && this.isRedact() == that.isRedact();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CustomJdbcConnectionProperty{");
        sb.append(this.key).append("=").append(!this.redact ? this.value : "*****");
        sb.append("} ");
        return sb.toString();
    }
}

