/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.controller.api.util;

import com.singularity.ee.controller.api.constants.TimeRangeSpecifierType;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import java.util.Date;

public class TimeRangeUtil {
    public static TimeRangeSpecifier getTimeRangeSpecifier(long startTime, long endTime) {
        TimeRangeSpecifier timeRange = new TimeRangeSpecifier();
        timeRange.setType(TimeRangeSpecifierType.BETWEEN_TIMES);
        timeRange.setStartTime(new Date(startTime));
        timeRange.setEndTime(new Date(endTime));
        return timeRange;
    }

    public static TimeRangeSpecifier getBeforeNowTimeRangeSpecifier(int minutesBeforeNow) {
        TimeRangeSpecifier timeRangeSpecifier = new TimeRangeSpecifier();
        timeRangeSpecifier.setType(TimeRangeSpecifierType.BEFORE_NOW);
        timeRangeSpecifier.setDurationInMinutes(minutesBeforeNow);
        return timeRangeSpecifier;
    }

    public static long calculateDurationInMinutes(TimeRangeSpecifier timeRangeSpecifier) {
        if (timeRangeSpecifier.getType().equals((Object)TimeRangeSpecifierType.BETWEEN_TIMES)) {
            return (timeRangeSpecifier.getEndTime().getTime() - timeRangeSpecifier.getStartTime().getTime()) / 1000L / 60L;
        }
        return timeRangeSpecifier.getDurationInMinutes();
    }

    public static TimeRangeSpecifier extendTimeRangeIntoPast(TimeRangeSpecifier origTimeRange, int minutesToExtend) {
        TimeRangeSpecifier newTimeRangeSpecifier = origTimeRange.copy();
        switch (newTimeRangeSpecifier.getType()) {
            case BEFORE_NOW: 
            case BEFORE_TIME: {
                newTimeRangeSpecifier.setDurationInMinutes(origTimeRange.getDurationInMinutes() + minutesToExtend);
                break;
            }
            case AFTER_TIME: {
                newTimeRangeSpecifier.setDurationInMinutes(origTimeRange.getDurationInMinutes() + minutesToExtend);
                newTimeRangeSpecifier.setStartTime(new Date(origTimeRange.getStartTime().getTime() - (long)(minutesToExtend * 60000)));
                break;
            }
            case BETWEEN_TIMES: {
                newTimeRangeSpecifier.setStartTime(new Date(origTimeRange.getStartTime().getTime() - (long)(minutesToExtend * 60000)));
                break;
            }
        }
        return newTimeRangeSpecifier;
    }

    public static TimeRangeSpecifier convertBeforeNowToBetweenTime(TimeRangeSpecifier beforeNow) {
        if (beforeNow.getType() != TimeRangeSpecifierType.BEFORE_NOW && beforeNow.getDurationInMinutes() <= 0) {
            return beforeNow;
        }
        long nowMillis = System.currentTimeMillis();
        long beforeNowMillis = nowMillis - (long)beforeNow.getDurationInMinutes() * 60000L;
        return TimeRangeUtil.getTimeRangeSpecifier(beforeNowMillis, nowMillis);
    }
}

