/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.controller.api.eum.web.sourcemap.debug;

import com.appdynamics.controller.api.eum.web.sourcemap.debug.SourceFileDetailsData;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OriginalLocationData {
    private String sourceMapName;
    private String fileUrl;
    private String releaseInfoKey;
    private Integer originalLineNumber;
    private Integer originalColumnNumber;
    private Integer lineNumber;
    private Integer columnNumber;
    private SourceFileDetailsData sourceFileDetailsData;

    public OriginalLocationData() {
    }

    protected OriginalLocationData(String sourceMapName, String fileUrl, String releaseInfoKey, Integer originalLineNumber, Integer originalColumnNumber, Integer lineNumber, Integer columnNumber, SourceFileDetailsData sourceFileDetailsData) {
        this.sourceMapName = sourceMapName;
        this.fileUrl = fileUrl;
        this.releaseInfoKey = releaseInfoKey;
        this.originalLineNumber = originalLineNumber;
        this.originalColumnNumber = originalColumnNumber;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.sourceFileDetailsData = sourceFileDetailsData;
    }

    public String toString() {
        return "OriginalLocation{sourceMapName='" + this.sourceMapName + '\'' + ", fileUrl='" + this.fileUrl + '\'' + ", releaseInfoKey='" + this.releaseInfoKey + '\'' + ", originalLineNumber=" + this.originalLineNumber + ", originalColumnNumber=" + this.originalColumnNumber + ", lineNumber=" + this.lineNumber + ", columnNumber=" + this.columnNumber + ", sourceFileDetail=" + this.sourceFileDetailsData + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OriginalLocationData)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        OriginalLocationData that = (OriginalLocationData)object;
        return Objects.equals(this.sourceMapName, that.sourceMapName) && Objects.equals(this.fileUrl, that.fileUrl) && Objects.equals(this.releaseInfoKey, that.releaseInfoKey) && Objects.equals(this.originalLineNumber, that.originalLineNumber) && Objects.equals(this.originalColumnNumber, that.originalColumnNumber) && Objects.equals(this.lineNumber, that.lineNumber) && Objects.equals(this.columnNumber, that.columnNumber) && Objects.equals(this.sourceFileDetailsData, that.sourceFileDetailsData);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceMapName, this.fileUrl, this.releaseInfoKey, this.originalLineNumber, this.originalColumnNumber, this.lineNumber, this.columnNumber, this.sourceFileDetailsData);
    }

    public String getSourceMapName() {
        return this.sourceMapName;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public String getReleaseInfoKey() {
        return this.releaseInfoKey;
    }

    public Integer getOriginalLineNumber() {
        return this.originalLineNumber;
    }

    public Integer getOriginalColumnNumber() {
        return this.originalColumnNumber;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public SourceFileDetailsData getSourceFileDetailsData() {
        return this.sourceFileDetailsData;
    }

    public static class OriginalLocationBuilder {
        private String sourceMapName = "";
        private String fileUrl = "";
        private String releaseInfoKey = "";
        private Integer originalLineNumber = null;
        private Integer originalColumnNumber = null;
        private Integer lineNumber = null;
        private Integer columnNumber = null;
        private SourceFileDetailsData sourceFileDetailsData = null;

        public OriginalLocationBuilder withSourceMapName(String sourceMapName) {
            this.sourceMapName = sourceMapName;
            return this;
        }

        public OriginalLocationBuilder withFileUrl(String fileUrl) {
            this.fileUrl = fileUrl;
            return this;
        }

        public OriginalLocationBuilder withReleaseInfoKey(String releaseInfoKey) {
            this.releaseInfoKey = releaseInfoKey;
            return this;
        }

        public OriginalLocationBuilder withOriginalLineNumber(Integer originalLineNumber) {
            this.originalLineNumber = originalLineNumber;
            return this;
        }

        public OriginalLocationBuilder withOriginalColumnNumber(Integer originalColumnNumber) {
            this.originalColumnNumber = originalColumnNumber;
            return this;
        }

        public OriginalLocationBuilder withLineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public OriginalLocationBuilder withColumnNumber(Integer columnNumber) {
            this.columnNumber = columnNumber;
            return this;
        }

        public OriginalLocationBuilder withSourceFileDetail(SourceFileDetailsData sourceFileDetailsData) {
            this.sourceFileDetailsData = sourceFileDetailsData;
            return this;
        }

        public OriginalLocationData build() {
            return new OriginalLocationData(this.sourceMapName, this.fileUrl, this.releaseInfoKey, this.originalLineNumber, this.originalColumnNumber, this.lineNumber, this.columnNumber, this.sourceFileDetailsData);
        }
    }
}

