/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.controller.api.eum.userjourney;

import com.google.errorprone.annotations.Immutable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public class UserJourneyFilterQueryData {
    private final String appKey;
    private final String mobileAppName;
    private final List<String> filterFields;
    private final int limit;

    public UserJourneyFilterQueryData(String appKey, String mobileAppName, List<String> filterFields, int limit) {
        this.appKey = appKey;
        this.mobileAppName = mobileAppName;
        this.filterFields = new ArrayList<String>(filterFields);
        this.limit = limit;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getMobileAppName() {
        return this.mobileAppName;
    }

    public List<String> getFilterFields() {
        return Collections.unmodifiableList(this.filterFields);
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserJourneyFilterQueryData that = (UserJourneyFilterQueryData)o;
        return this.limit == that.limit && Objects.equals(this.appKey, that.appKey) && Objects.equals(this.mobileAppName, that.mobileAppName) && Objects.equals(this.filterFields, that.filterFields);
    }

    public int hashCode() {
        return Objects.hash(this.appKey, this.mobileAppName, this.filterFields, this.limit);
    }

    public String toString() {
        return "UserJourneyFilterQueryData{appKey='" + this.appKey + '\'' + ", mobileAppName='" + this.mobileAppName + '\'' + ", filterFields=" + this.filterFields + ", limit=" + this.limit + '}';
    }
}

