/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.controller.api.eum.userjourney;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Immutable
public class UserJourneyFilterData {
    private final Map<String, List<String>> filterValues;

    public UserJourneyFilterData(Map<String, List<String>> filterValues) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        if (filterValues != null) {
            for (Map.Entry<String, List<String>> entry : filterValues.entrySet()) {
                mapBuilder.put((Object)entry.getKey(), (Object)ImmutableList.copyOf((Collection)entry.getValue()));
            }
        }
        this.filterValues = mapBuilder.build();
    }

    public Map<String, List<String>> getFilterValues() {
        return this.filterValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserJourneyFilterData that = (UserJourneyFilterData)o;
        return Objects.equals(this.filterValues, that.filterValues);
    }

    public int hashCode() {
        return Objects.hash(this.filterValues);
    }

    public String toString() {
        return "UserJourneyFilterData{filterValues=" + this.filterValues + '}';
    }
}

