/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.validator;

import com.appdynamics.analytics.log.shared.dto.MaskConfiguration;
import com.appdynamics.analytics.log.shared.dto.MaskTypeDTO;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={StartIndexLessThanEndIndexValidator.class})
public @interface MaskingStartIndexLessThanEndIndex {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class StartIndexLessThanEndIndexValidator
    implements ConstraintValidator<MaskingStartIndexLessThanEndIndex, MaskConfiguration> {
        public void initialize(MaskingStartIndexLessThanEndIndex constraintAnnotation) {
        }

        public boolean isValid(MaskConfiguration config, ConstraintValidatorContext context) {
            if (config != null && config.getMaskType() == MaskTypeDTO.REPEAT && config.getEndIndex() < config.getStartIndex()) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate("End index must be greater than or equal to start index").addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

