/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.field;

import com.appdynamics.analytics.grok.GrokLoaderFactory;
import com.appdynamics.analytics.log.shared.dto.AddFieldConfiguration;
import com.appdynamics.analytics.log.shared.dto.AutoRegexFieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.FieldConfiguration;
import com.appdynamics.analytics.log.shared.dto.FieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.FieldInfo;
import com.appdynamics.analytics.log.shared.dto.FileConfigurationDTO;
import com.appdynamics.analytics.log.shared.dto.GrokFieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.KeyValueExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.LogCollectionType;
import com.appdynamics.analytics.log.shared.dto.LogSourceConfigurationDTO;
import com.appdynamics.analytics.log.shared.dto.ManualRegexFieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.RemoveFieldConfiguration;
import com.appdynamics.analytics.log.shared.dto.RenameConfiguration;
import com.appdynamics.analytics.log.shared.dto.TypeConversionConfiguration;
import com.appdynamics.common.util.grok.Grok;
import com.appdynamics.common.util.regex.RegexPattern;
import com.appdynamics.common.util.type.ValueType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldExtractor.class);
    private static final Grok GROK = new GrokLoaderFactory().makeGrok();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String SCHEMA_NODE = "schema";
    private static final String EVENT_TYPE_NODE = "eventType";
    private static final String TYPE_NODE = "type";
    private static final String TYPE_UNKNOWN = "unknown";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_INTEGER = "integer";
    private static final String TYPE_FLOAT = "float";
    private static final String TYPE_BOOLEAN = "boolean";
    private static final String TYPE_DATE = "date";
    private static final Map<String, ValueType> SCHEMA_TYPE_TO_VALUE_TYPE_MAP = ImmutableMap.builder().put((Object)"unknown", (Object)ValueType.UNKNOWN).put((Object)"string", (Object)ValueType.STRING).put((Object)"integer", (Object)ValueType.NUMBER).put((Object)"float", (Object)ValueType.NUMBER).put((Object)"boolean", (Object)ValueType.BOOLEAN).put((Object)"date", (Object)ValueType.TIMESTAMP).build();

    public static Set<FieldInfo> extractFields(LogSourceConfigurationDTO logSourceConfiguration) {
        Preconditions.checkNotNull((Object)logSourceConfiguration, (Object)"logSourceConfiguration can't be null");
        HashSet<FieldInfo> fields = new HashSet<FieldInfo>();
        LogCollectionType collectionType = logSourceConfiguration.getCollectionType();
        if (collectionType == LogCollectionType.FILE) {
            FieldExtractor.addFieldsFromFileConfig(logSourceConfiguration.getFileConfigurationDTO(), fields);
        }
        if (logSourceConfiguration.getExtractionConfigurations() != null) {
            block6: for (FieldExtractionConfiguration config : logSourceConfiguration.getExtractionConfigurations()) {
                switch (config.getFieldConfigType()) {
                    case GROK: {
                        FieldExtractor.addFieldsFromGrokConfig((GrokFieldExtractionConfiguration)config, fields);
                        continue block6;
                    }
                    case KEYVALUE: {
                        FieldExtractor.addFieldsFromKeyValueConfig((KeyValueExtractionConfiguration)config, fields);
                        continue block6;
                    }
                    case AUTOREGEX: {
                        FieldExtractor.addFieldsFromAutoRegexConfig((AutoRegexFieldExtractionConfiguration)config, fields);
                        continue block6;
                    }
                    case MANUALREGEX: {
                        FieldExtractor.addFieldsFromManualRegexConfig((ManualRegexFieldExtractionConfiguration)config, fields);
                        continue block6;
                    }
                }
                log.error("The configuration type was not found while extracting the fields.");
            }
        }
        return fields;
    }

    public static Map<String, ValueType> extractFieldsFromLogEventSchema(String schemaJson) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)schemaJson), (Object)"schemaJson can't be blank");
        JsonNode rootNode = OBJECT_MAPPER.readTree(schemaJson);
        String eventType = rootNode.path(EVENT_TYPE_NODE).asText();
        Preconditions.checkArgument((boolean)"log_v1".equals(eventType), (String)"The given schema event type [%s] was not equal to [%s]", (Object)eventType, (Object)"log_v1");
        HashMap<String, ValueType> fieldMap = new HashMap<String, ValueType>();
        Iterator fieldIterator = rootNode.path(SCHEMA_NODE).fields();
        while (fieldIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIterator.next();
            String fieldType = ((JsonNode)field.getValue()).isObject() ? ((JsonNode)field.getValue()).path(TYPE_NODE).asText(TYPE_UNKNOWN) : ((JsonNode)field.getValue()).asText(TYPE_UNKNOWN);
            ValueType valueType = FieldExtractor.convertType(fieldType);
            fieldMap.put((String)field.getKey(), valueType);
        }
        return fieldMap;
    }

    public static SetMultimap<String, ValueType> extractFieldsApplyingFieldTransformations(LogSourceConfigurationDTO logSourceConfiguration) {
        Preconditions.checkNotNull((Object)logSourceConfiguration, (Object)"logSourceConfiguration can't be null");
        Set<FieldInfo> fields = FieldExtractor.extractFields(logSourceConfiguration);
        HashMultimap fieldsMap = HashMultimap.create();
        for (FieldInfo field : fields) {
            fieldsMap.put((Object)field.getFieldName(), (Object)field.getType());
        }
        List<FieldConfiguration> fieldConfigurations = logSourceConfiguration.getFieldConfigurations();
        if (fieldConfigurations != null) {
            for (FieldConfiguration fieldConfig : fieldConfigurations) {
                if (fieldConfig instanceof RemoveFieldConfiguration) {
                    FieldExtractor.applyRemoveFieldConfigurations((RemoveFieldConfiguration)fieldConfig, (SetMultimap<String, ValueType>)fieldsMap);
                    continue;
                }
                if (fieldConfig instanceof AddFieldConfiguration) {
                    FieldExtractor.applyAddFieldConfigurations((AddFieldConfiguration)fieldConfig, (SetMultimap<String, ValueType>)fieldsMap);
                    continue;
                }
                if (fieldConfig instanceof RenameConfiguration) {
                    FieldExtractor.applyRenameConfigurations((RenameConfiguration)fieldConfig, (SetMultimap<String, ValueType>)fieldsMap);
                    continue;
                }
                if (!(fieldConfig instanceof TypeConversionConfiguration)) continue;
                FieldExtractor.applyTypeConversionConfigurations((TypeConversionConfiguration)fieldConfig, (SetMultimap<String, ValueType>)fieldsMap);
            }
        }
        return fieldsMap;
    }

    private static void applyAddFieldConfigurations(AddFieldConfiguration addField, SetMultimap<String, ValueType> fieldsMap) {
        if (addField != null) {
            fieldsMap.put((Object)addField.getField(), (Object)addField.getValueType());
        }
    }

    private static void applyRenameConfigurations(RenameConfiguration renameConfiguration, SetMultimap<String, ValueType> fieldsMap) {
        if (renameConfiguration != null) {
            String fieldName = renameConfiguration.getField();
            String alias = renameConfiguration.getNewField();
            if (StringUtils.isNotBlank((String)alias) && StringUtils.isNotBlank((String)fieldName) && fieldsMap.containsKey((Object)fieldName)) {
                HashSet existingValueTypes = Sets.newHashSet((Iterable)fieldsMap.get((Object)fieldName));
                fieldsMap.removeAll((Object)fieldName);
                fieldsMap.putAll((Object)alias, (Iterable)existingValueTypes);
            }
        }
    }

    private static void applyTypeConversionConfigurations(TypeConversionConfiguration typeConversionConfiguration, SetMultimap<String, ValueType> fieldsMap) {
        if (typeConversionConfiguration != null) {
            String fieldName = typeConversionConfiguration.getField();
            ValueType valueType = typeConversionConfiguration.getType();
            if (valueType != null && StringUtils.isNotBlank((String)fieldName) && fieldsMap.containsKey((Object)fieldName)) {
                fieldsMap.replaceValues((Object)fieldName, (Iterable)Sets.newHashSet((Object[])new ValueType[]{valueType}));
            }
        }
    }

    private static void applyRemoveFieldConfigurations(RemoveFieldConfiguration removeField, SetMultimap<String, ValueType> fieldsMap) {
        if (removeField != null) {
            fieldsMap.removeAll((Object)removeField.getField());
        }
    }

    public static void addFieldsFromFileConfig(FileConfigurationDTO fileConfiguration, Set<FieldInfo> fields) {
        String pathExtractedFieldsGrok;
        if (fileConfiguration != null && StringUtils.isNotBlank((String)(pathExtractedFieldsGrok = fileConfiguration.getPathExtractedFieldsGrok()))) {
            FieldExtractor.addGrokPatternAliasesToExtractedFields(pathExtractedFieldsGrok, fields);
        }
    }

    public static void addFieldsFromGrokConfig(GrokFieldExtractionConfiguration grokConfiguration, Set<FieldInfo> fields) {
        if (grokConfiguration.getPattern() != null) {
            FieldExtractor.addGrokPatternAliasesToExtractedFields(grokConfiguration.getPattern(), fields);
        }
    }

    public static void addFieldsFromKeyValueConfig(KeyValueExtractionConfiguration keyValueConfiguration, Set<FieldInfo> fields) {
        Map<String, FieldInfo> keyToFieldMap = keyValueConfiguration.getKeyToField();
        if (keyToFieldMap != null && keyToFieldMap.size() > 0) {
            fields.addAll(keyToFieldMap.values());
        }
    }

    public static void addFieldsFromAutoRegexConfig(AutoRegexFieldExtractionConfiguration autoRegexConfig, Set<FieldInfo> fields) {
        List<FieldInfo> logFields = autoRegexConfig.getFields();
        if (logFields != null && logFields.size() > 0) {
            fields.addAll(logFields);
        }
    }

    public static void addFieldsFromManualRegexConfig(ManualRegexFieldExtractionConfiguration manualRegexConfig, Set<FieldInfo> fields) {
        FieldInfo logField = manualRegexConfig.getField();
        if (logField != null) {
            fields.add(logField);
        }
    }

    public static void addGrokPatternAliasesToExtractedFields(String grokPattern, Set<FieldInfo> fields) {
        try {
            RegexPattern regexPattern = GROK.compile(grokPattern);
            if (regexPattern.getAliases() != null) {
                String[] aliases = regexPattern.getAliases();
                ValueType[] valueTypes = regexPattern.getValueTypes();
                for (int i = 0; i < aliases.length; ++i) {
                    fields.add(new FieldInfo(aliases[i], valueTypes[i]));
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to get extracted fields from grok pattern [{}] with error [{}]", (Object)grokPattern, (Object)e.getMessage());
            throw e;
        }
    }

    private static ValueType convertType(String fieldType) {
        ValueType valueType = SCHEMA_TYPE_TO_VALUE_TYPE_MAP.get(fieldType);
        return valueType == null ? ValueType.UNKNOWN : valueType;
    }
}

