/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.dto;

import com.appdynamics.analytics.log.shared.dto.SourceConfigurationDTO;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SyslogConfigurationDTO
extends SourceConfigurationDTO {
    @Range(min=0L, max=65535L)
    @Range(min=0L, max=65535L) int port;
    @NotNull
    Protocol protocol;
    @NotNull
    String charset = StandardCharsets.UTF_8.name();

    public SyslogConfigurationDTO(Protocol protocol) {
        this(514, protocol);
    }

    public SyslogConfigurationDTO(int port, Protocol protocol) {
        this.port = port;
        this.protocol = protocol;
    }

    public SyslogConfigurationDTO(int port, Protocol protocol, String charset) {
        this.port = port;
        this.protocol = protocol;
        this.charset = charset;
    }

    @Override
    public String getSource() {
        return String.format("%s-%s", new Object[]{this.getPort(), this.getProtocol()});
    }

    @Generated
    public SyslogConfigurationDTO() {
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getCharset() {
        return this.charset;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Generated
    public String toString() {
        return "SyslogConfigurationDTO(port=" + this.getPort() + ", protocol=" + String.valueOf((Object)this.getProtocol()) + ", charset=" + this.getCharset() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyslogConfigurationDTO)) {
            return false;
        }
        SyslogConfigurationDTO other = (SyslogConfigurationDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SyslogConfigurationDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        return result;
    }

    public static enum Protocol {
        TCP;

    }
}

