/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.dto;

import com.appdynamics.analytics.log.shared.dto.FieldConfiguration;
import com.appdynamics.analytics.log.shared.dto.FieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.FileConfigurationDTO;
import com.appdynamics.analytics.log.shared.dto.LogCollectionType;
import com.appdynamics.analytics.log.shared.dto.MultiLineConfiguration;
import com.appdynamics.analytics.log.shared.dto.SyslogConfigurationDTO;
import com.appdynamics.analytics.log.shared.dto.TimestampConfiguration;
import com.appdynamics.analytics.log.shared.dto.TimestampFilterConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LogSourceConfigurationDTO {
    @NotEmpty(message="The Log Source ID is missing")
    private @NotEmpty(message="The Log Source ID is missing") String logSourceId;
    long revisionNumber;
    @NotEmpty(message="The Source Name is missing")
    private @NotEmpty(message="The Source Name is missing") String sourceName;
    private String importedFromSourceId;
    private boolean disableImportedSourceId;
    private LogCollectionType collectionType;
    private boolean enabled;
    @NotEmpty(message="The Source Type is missing")
    private @NotEmpty(message="The Source Type is missing") String sourceType;
    @Min(value=1L)
    private @Min(value=1L) int numThreads;
    @Min(value=1L)
    private @Min(value=1L) int waitTime;
    private boolean collectCompressed;
    @Valid
    private MultiLineConfiguration multiLineConfiguration;
    @Valid
    private TimestampConfiguration timestampConfiguration;
    @Valid
    private TimestampFilterConfiguration timestampFilterConfiguration;
    @Valid
    private FileConfigurationDTO fileConfigurationDTO;
    @Valid
    private SyslogConfigurationDTO syslogConfigurationDTO;
    @Valid
    private List<FieldConfiguration> fieldConfigurations;
    @Valid
    private List<FieldExtractionConfiguration> extractionConfigurations;

    public void addFieldConfiguration(FieldConfiguration config) {
        if (this.fieldConfigurations == null) {
            this.fieldConfigurations = new ArrayList<FieldConfiguration>();
        }
        this.fieldConfigurations.add(config);
    }

    public void addExtractionConfiguration(FieldExtractionConfiguration config) {
        if (this.extractionConfigurations == null) {
            this.extractionConfigurations = new ArrayList<FieldExtractionConfiguration>();
        }
        this.extractionConfigurations.add(config);
    }

    @Generated
    public LogSourceConfigurationDTO() {
    }

    @ConstructorProperties(value={"logSourceId", "revisionNumber", "sourceName", "importedFromSourceId", "disableImportedSourceId", "collectionType", "enabled", "sourceType", "numThreads", "waitTime", "collectCompressed", "multiLineConfiguration", "timestampConfiguration", "timestampFilterConfiguration", "fileConfigurationDTO", "syslogConfigurationDTO", "fieldConfigurations", "extractionConfigurations"})
    @Generated
    public LogSourceConfigurationDTO(String logSourceId, long revisionNumber, String sourceName, String importedFromSourceId, boolean disableImportedSourceId, LogCollectionType collectionType, boolean enabled, String sourceType, int numThreads, int waitTime, boolean collectCompressed, MultiLineConfiguration multiLineConfiguration, TimestampConfiguration timestampConfiguration, TimestampFilterConfiguration timestampFilterConfiguration, FileConfigurationDTO fileConfigurationDTO, SyslogConfigurationDTO syslogConfigurationDTO, List<FieldConfiguration> fieldConfigurations, List<FieldExtractionConfiguration> extractionConfigurations) {
        this.logSourceId = logSourceId;
        this.revisionNumber = revisionNumber;
        this.sourceName = sourceName;
        this.importedFromSourceId = importedFromSourceId;
        this.disableImportedSourceId = disableImportedSourceId;
        this.collectionType = collectionType;
        this.enabled = enabled;
        this.sourceType = sourceType;
        this.numThreads = numThreads;
        this.waitTime = waitTime;
        this.collectCompressed = collectCompressed;
        this.multiLineConfiguration = multiLineConfiguration;
        this.timestampConfiguration = timestampConfiguration;
        this.timestampFilterConfiguration = timestampFilterConfiguration;
        this.fileConfigurationDTO = fileConfigurationDTO;
        this.syslogConfigurationDTO = syslogConfigurationDTO;
        this.fieldConfigurations = fieldConfigurations;
        this.extractionConfigurations = extractionConfigurations;
    }

    @Generated
    public String getLogSourceId() {
        return this.logSourceId;
    }

    @Generated
    public long getRevisionNumber() {
        return this.revisionNumber;
    }

    @Generated
    public String getSourceName() {
        return this.sourceName;
    }

    @Generated
    public String getImportedFromSourceId() {
        return this.importedFromSourceId;
    }

    @Generated
    public boolean isDisableImportedSourceId() {
        return this.disableImportedSourceId;
    }

    @Generated
    public LogCollectionType getCollectionType() {
        return this.collectionType;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public int getNumThreads() {
        return this.numThreads;
    }

    @Generated
    public int getWaitTime() {
        return this.waitTime;
    }

    @Generated
    public boolean isCollectCompressed() {
        return this.collectCompressed;
    }

    @Generated
    public MultiLineConfiguration getMultiLineConfiguration() {
        return this.multiLineConfiguration;
    }

    @Generated
    public TimestampConfiguration getTimestampConfiguration() {
        return this.timestampConfiguration;
    }

    @Generated
    public TimestampFilterConfiguration getTimestampFilterConfiguration() {
        return this.timestampFilterConfiguration;
    }

    @Generated
    public FileConfigurationDTO getFileConfigurationDTO() {
        return this.fileConfigurationDTO;
    }

    @Generated
    public SyslogConfigurationDTO getSyslogConfigurationDTO() {
        return this.syslogConfigurationDTO;
    }

    @Generated
    public List<FieldConfiguration> getFieldConfigurations() {
        return this.fieldConfigurations;
    }

    @Generated
    public List<FieldExtractionConfiguration> getExtractionConfigurations() {
        return this.extractionConfigurations;
    }

    @Generated
    public void setLogSourceId(String logSourceId) {
        this.logSourceId = logSourceId;
    }

    @Generated
    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    @Generated
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @Generated
    public void setImportedFromSourceId(String importedFromSourceId) {
        this.importedFromSourceId = importedFromSourceId;
    }

    @Generated
    public void setDisableImportedSourceId(boolean disableImportedSourceId) {
        this.disableImportedSourceId = disableImportedSourceId;
    }

    @Generated
    public void setCollectionType(LogCollectionType collectionType) {
        this.collectionType = collectionType;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Generated
    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @Generated
    public void setCollectCompressed(boolean collectCompressed) {
        this.collectCompressed = collectCompressed;
    }

    @Generated
    public void setMultiLineConfiguration(MultiLineConfiguration multiLineConfiguration) {
        this.multiLineConfiguration = multiLineConfiguration;
    }

    @Generated
    public void setTimestampConfiguration(TimestampConfiguration timestampConfiguration) {
        this.timestampConfiguration = timestampConfiguration;
    }

    @Generated
    public void setTimestampFilterConfiguration(TimestampFilterConfiguration timestampFilterConfiguration) {
        this.timestampFilterConfiguration = timestampFilterConfiguration;
    }

    @Generated
    public void setFileConfigurationDTO(FileConfigurationDTO fileConfigurationDTO) {
        this.fileConfigurationDTO = fileConfigurationDTO;
    }

    @Generated
    public void setSyslogConfigurationDTO(SyslogConfigurationDTO syslogConfigurationDTO) {
        this.syslogConfigurationDTO = syslogConfigurationDTO;
    }

    @Generated
    public void setFieldConfigurations(List<FieldConfiguration> fieldConfigurations) {
        this.fieldConfigurations = fieldConfigurations;
    }

    @Generated
    public void setExtractionConfigurations(List<FieldExtractionConfiguration> extractionConfigurations) {
        this.extractionConfigurations = extractionConfigurations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogSourceConfigurationDTO)) {
            return false;
        }
        LogSourceConfigurationDTO other = (LogSourceConfigurationDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRevisionNumber() != other.getRevisionNumber()) {
            return false;
        }
        if (this.isDisableImportedSourceId() != other.isDisableImportedSourceId()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getNumThreads() != other.getNumThreads()) {
            return false;
        }
        if (this.getWaitTime() != other.getWaitTime()) {
            return false;
        }
        if (this.isCollectCompressed() != other.isCollectCompressed()) {
            return false;
        }
        String this$logSourceId = this.getLogSourceId();
        String other$logSourceId = other.getLogSourceId();
        if (this$logSourceId == null ? other$logSourceId != null : !this$logSourceId.equals(other$logSourceId)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        String this$importedFromSourceId = this.getImportedFromSourceId();
        String other$importedFromSourceId = other.getImportedFromSourceId();
        if (this$importedFromSourceId == null ? other$importedFromSourceId != null : !this$importedFromSourceId.equals(other$importedFromSourceId)) {
            return false;
        }
        LogCollectionType this$collectionType = this.getCollectionType();
        LogCollectionType other$collectionType = other.getCollectionType();
        if (this$collectionType == null ? other$collectionType != null : !((Object)((Object)this$collectionType)).equals((Object)other$collectionType)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        MultiLineConfiguration this$multiLineConfiguration = this.getMultiLineConfiguration();
        MultiLineConfiguration other$multiLineConfiguration = other.getMultiLineConfiguration();
        if (this$multiLineConfiguration == null ? other$multiLineConfiguration != null : !((Object)this$multiLineConfiguration).equals(other$multiLineConfiguration)) {
            return false;
        }
        TimestampConfiguration this$timestampConfiguration = this.getTimestampConfiguration();
        TimestampConfiguration other$timestampConfiguration = other.getTimestampConfiguration();
        if (this$timestampConfiguration == null ? other$timestampConfiguration != null : !((Object)this$timestampConfiguration).equals(other$timestampConfiguration)) {
            return false;
        }
        TimestampFilterConfiguration this$timestampFilterConfiguration = this.getTimestampFilterConfiguration();
        TimestampFilterConfiguration other$timestampFilterConfiguration = other.getTimestampFilterConfiguration();
        if (this$timestampFilterConfiguration == null ? other$timestampFilterConfiguration != null : !((Object)this$timestampFilterConfiguration).equals(other$timestampFilterConfiguration)) {
            return false;
        }
        FileConfigurationDTO this$fileConfigurationDTO = this.getFileConfigurationDTO();
        FileConfigurationDTO other$fileConfigurationDTO = other.getFileConfigurationDTO();
        if (this$fileConfigurationDTO == null ? other$fileConfigurationDTO != null : !((Object)this$fileConfigurationDTO).equals(other$fileConfigurationDTO)) {
            return false;
        }
        SyslogConfigurationDTO this$syslogConfigurationDTO = this.getSyslogConfigurationDTO();
        SyslogConfigurationDTO other$syslogConfigurationDTO = other.getSyslogConfigurationDTO();
        if (this$syslogConfigurationDTO == null ? other$syslogConfigurationDTO != null : !((Object)this$syslogConfigurationDTO).equals(other$syslogConfigurationDTO)) {
            return false;
        }
        List<FieldConfiguration> this$fieldConfigurations = this.getFieldConfigurations();
        List<FieldConfiguration> other$fieldConfigurations = other.getFieldConfigurations();
        if (this$fieldConfigurations == null ? other$fieldConfigurations != null : !((Object)this$fieldConfigurations).equals(other$fieldConfigurations)) {
            return false;
        }
        List<FieldExtractionConfiguration> this$extractionConfigurations = this.getExtractionConfigurations();
        List<FieldExtractionConfiguration> other$extractionConfigurations = other.getExtractionConfigurations();
        return !(this$extractionConfigurations == null ? other$extractionConfigurations != null : !((Object)this$extractionConfigurations).equals(other$extractionConfigurations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogSourceConfigurationDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $revisionNumber = this.getRevisionNumber();
        result = result * 59 + (int)($revisionNumber >>> 32 ^ $revisionNumber);
        result = result * 59 + (this.isDisableImportedSourceId() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getNumThreads();
        result = result * 59 + this.getWaitTime();
        result = result * 59 + (this.isCollectCompressed() ? 79 : 97);
        String $logSourceId = this.getLogSourceId();
        result = result * 59 + ($logSourceId == null ? 43 : $logSourceId.hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        String $importedFromSourceId = this.getImportedFromSourceId();
        result = result * 59 + ($importedFromSourceId == null ? 43 : $importedFromSourceId.hashCode());
        LogCollectionType $collectionType = this.getCollectionType();
        result = result * 59 + ($collectionType == null ? 43 : ((Object)((Object)$collectionType)).hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        MultiLineConfiguration $multiLineConfiguration = this.getMultiLineConfiguration();
        result = result * 59 + ($multiLineConfiguration == null ? 43 : ((Object)$multiLineConfiguration).hashCode());
        TimestampConfiguration $timestampConfiguration = this.getTimestampConfiguration();
        result = result * 59 + ($timestampConfiguration == null ? 43 : ((Object)$timestampConfiguration).hashCode());
        TimestampFilterConfiguration $timestampFilterConfiguration = this.getTimestampFilterConfiguration();
        result = result * 59 + ($timestampFilterConfiguration == null ? 43 : ((Object)$timestampFilterConfiguration).hashCode());
        FileConfigurationDTO $fileConfigurationDTO = this.getFileConfigurationDTO();
        result = result * 59 + ($fileConfigurationDTO == null ? 43 : ((Object)$fileConfigurationDTO).hashCode());
        SyslogConfigurationDTO $syslogConfigurationDTO = this.getSyslogConfigurationDTO();
        result = result * 59 + ($syslogConfigurationDTO == null ? 43 : ((Object)$syslogConfigurationDTO).hashCode());
        List<FieldConfiguration> $fieldConfigurations = this.getFieldConfigurations();
        result = result * 59 + ($fieldConfigurations == null ? 43 : ((Object)$fieldConfigurations).hashCode());
        List<FieldExtractionConfiguration> $extractionConfigurations = this.getExtractionConfigurations();
        result = result * 59 + ($extractionConfigurations == null ? 43 : ((Object)$extractionConfigurations).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LogSourceConfigurationDTO(logSourceId=" + this.getLogSourceId() + ", revisionNumber=" + this.getRevisionNumber() + ", sourceName=" + this.getSourceName() + ", importedFromSourceId=" + this.getImportedFromSourceId() + ", disableImportedSourceId=" + this.isDisableImportedSourceId() + ", collectionType=" + String.valueOf((Object)this.getCollectionType()) + ", enabled=" + this.isEnabled() + ", sourceType=" + this.getSourceType() + ", numThreads=" + this.getNumThreads() + ", waitTime=" + this.getWaitTime() + ", collectCompressed=" + this.isCollectCompressed() + ", multiLineConfiguration=" + String.valueOf(this.getMultiLineConfiguration()) + ", timestampConfiguration=" + String.valueOf(this.getTimestampConfiguration()) + ", timestampFilterConfiguration=" + String.valueOf(this.getTimestampFilterConfiguration()) + ", fileConfigurationDTO=" + String.valueOf(this.getFileConfigurationDTO()) + ", syslogConfigurationDTO=" + String.valueOf(this.getSyslogConfigurationDTO()) + ", fieldConfigurations=" + String.valueOf(this.getFieldConfigurations()) + ", extractionConfigurations=" + String.valueOf(this.getExtractionConfigurations()) + ")";
    }
}

