/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.dto;

import com.appdynamics.analytics.log.shared.dto.FieldConfigType;
import com.appdynamics.analytics.log.shared.dto.FieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.FieldInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.ImmutableList;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KeyValueExtractionConfiguration
extends FieldExtractionConfiguration {
    @NotEmpty(message="The field to extract key-value pairs is missing")
    @NotEmpty(message="The field to extract key-value pairs is missing") String source;
    @NotEmpty(message="The separators for key-value pairs is missing")
    @NotEmpty(message="The separators for key-value pairs is missing") List<String> separators;
    @NotEmpty(message="The split for key-value pairs is missing")
    @NotEmpty(message="The split for key-value pairs is missing") List<String> splits;
    List<String> trim;
    @NotEmpty(message="Include for key-value pairs is missing")
    @NotEmpty(message="Include for key-value pairs is missing") Map<String, FieldInfo> keyToField;

    public KeyValueExtractionConfiguration() {
        this.fieldConfigType = FieldConfigType.KEYVALUE;
    }

    public KeyValueExtractionConfiguration(String source, List<String> separators, List<String> splits, List<String> trim, Map<String, FieldInfo> keyToField) {
        this.source = source;
        this.separators = separators;
        this.splits = splits;
        this.trim = trim;
        this.keyToField = keyToField;
        this.fieldConfigType = FieldConfigType.KEYVALUE;
    }

    @Override
    public List<String> getFieldNames() {
        ArrayList<String> stringFields = new ArrayList<String>();
        if (this.keyToField != null) {
            for (FieldInfo field : this.keyToField.values()) {
                stringFields.add(field.getFieldName());
            }
        }
        return ImmutableList.copyOf(stringFields);
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        if (this.keyToField != null) {
            return ImmutableList.copyOf(this.keyToField.values());
        }
        return ImmutableList.of();
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public List<String> getSeparators() {
        return this.separators;
    }

    @Generated
    public List<String> getSplits() {
        return this.splits;
    }

    @Generated
    public List<String> getTrim() {
        return this.trim;
    }

    @Generated
    public Map<String, FieldInfo> getKeyToField() {
        return this.keyToField;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setSeparators(List<String> separators) {
        this.separators = separators;
    }

    @Generated
    public void setSplits(List<String> splits) {
        this.splits = splits;
    }

    @Generated
    public void setTrim(List<String> trim) {
        this.trim = trim;
    }

    @Generated
    public void setKeyToField(Map<String, FieldInfo> keyToField) {
        this.keyToField = keyToField;
    }

    @Generated
    public String toString() {
        return "KeyValueExtractionConfiguration(source=" + this.getSource() + ", separators=" + String.valueOf(this.getSeparators()) + ", splits=" + String.valueOf(this.getSplits()) + ", trim=" + String.valueOf(this.getTrim()) + ", keyToField=" + String.valueOf(this.getKeyToField()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValueExtractionConfiguration)) {
            return false;
        }
        KeyValueExtractionConfiguration other = (KeyValueExtractionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<String> this$separators = this.getSeparators();
        List<String> other$separators = other.getSeparators();
        if (this$separators == null ? other$separators != null : !((Object)this$separators).equals(other$separators)) {
            return false;
        }
        List<String> this$splits = this.getSplits();
        List<String> other$splits = other.getSplits();
        if (this$splits == null ? other$splits != null : !((Object)this$splits).equals(other$splits)) {
            return false;
        }
        List<String> this$trim = this.getTrim();
        List<String> other$trim = other.getTrim();
        if (this$trim == null ? other$trim != null : !((Object)this$trim).equals(other$trim)) {
            return false;
        }
        Map<String, FieldInfo> this$keyToField = this.getKeyToField();
        Map<String, FieldInfo> other$keyToField = other.getKeyToField();
        return !(this$keyToField == null ? other$keyToField != null : !((Object)this$keyToField).equals(other$keyToField));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyValueExtractionConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<String> $separators = this.getSeparators();
        result = result * 59 + ($separators == null ? 43 : ((Object)$separators).hashCode());
        List<String> $splits = this.getSplits();
        result = result * 59 + ($splits == null ? 43 : ((Object)$splits).hashCode());
        List<String> $trim = this.getTrim();
        result = result * 59 + ($trim == null ? 43 : ((Object)$trim).hashCode());
        Map<String, FieldInfo> $keyToField = this.getKeyToField();
        result = result * 59 + ($keyToField == null ? 43 : ((Object)$keyToField).hashCode());
        return result;
    }
}

