/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.agent.configurator;

import com.appdynamics.analytics.log.shared.agent.configurator.PipelineStageConfigurationConverter;
import com.appdynamics.analytics.log.shared.dto.AddFieldConfiguration;
import com.appdynamics.analytics.log.shared.dto.AutoRegexFieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.FieldConfiguration;
import com.appdynamics.analytics.log.shared.dto.FieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.GrokFieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.KeyValueExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.LogCollectionType;
import com.appdynamics.analytics.log.shared.dto.LogSourceConfigurationDTO;
import com.appdynamics.analytics.log.shared.dto.ManualRegexFieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.MaskConfiguration;
import com.appdynamics.analytics.log.shared.dto.RemoveFieldConfiguration;
import com.appdynamics.analytics.log.shared.dto.RenameConfiguration;
import com.appdynamics.analytics.log.shared.dto.SourceConfigurationDTO;
import com.appdynamics.analytics.log.shared.dto.TimestampFilterConfiguration;
import com.appdynamics.analytics.log.shared.dto.TypeConversionConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.grok.GrokUtils;
import com.appdynamics.common.util.configuration.ConfigurationHelper;
import com.appdynamics.common.util.configuration.Sanitizer;
import com.appdynamics.common.util.grok.Grok;
import com.appdynamics.common.util.type.ValueType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineConfigurationConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineConfigurationConverter.class);
    private static final String EVENT_TYPE_LOG = "eventType.log";
    private static final String EVENT_ACCESS_KEY = "http.event.accessKey";

    public static PipelineConfiguration getPipelineConfigurationFromDTO(LogSourceConfigurationDTO logSourceConfigurationDTO) {
        PipelineConfiguration pipelineConfiguration = new PipelineConfiguration();
        pipelineConfiguration.setStages(PipelineConfigurationConverter.getPipelineStageConfigurationFromDTO(logSourceConfigurationDTO));
        pipelineConfiguration.setEnabled(logSourceConfigurationDTO.isEnabled());
        pipelineConfiguration.setId((Object)logSourceConfigurationDTO.getLogSourceId());
        return pipelineConfiguration;
    }

    private static List<PipelineStageConfiguration> getPipelineStageConfigurationFromDTO(LogSourceConfigurationDTO logSourceConfigurationDTO) {
        List<FieldConfiguration> fieldConfigurations;
        TimestampFilterConfiguration timestampFilterConfiguration;
        int collectLastNHours;
        ArrayList<PipelineStageConfiguration> stages = new ArrayList<PipelineStageConfiguration>();
        Properties variableValues = ConfigurationHelper.getProperties();
        SourceConfigurationDTO sourceConfigurationDTO = switch (logSourceConfigurationDTO.getCollectionType()) {
            case LogCollectionType.FILE -> logSourceConfigurationDTO.getFileConfigurationDTO();
            case LogCollectionType.NETWORK -> logSourceConfigurationDTO.getSyslogConfigurationDTO();
            default -> throw new IllegalStateException(String.format("Unknown Log Source type [%s]", new Object[]{logSourceConfigurationDTO.getCollectionType()}));
        };
        if (logSourceConfigurationDTO.getMultiLineConfiguration() != null) {
            stages.add(PipelineStageConfigurationConverter.createMultiLineStageConfiguration(logSourceConfigurationDTO.getMultiLineConfiguration()));
        }
        stages.add(PipelineStageConfigurationConverter.createMapStageConfiguration());
        AddFieldConfiguration addSourceField = new AddFieldConfiguration("source", sourceConfigurationDTO.getSource(), ValueType.STRING);
        stages.add(PipelineStageConfigurationConverter.createAddFieldStageConfiguration(addSourceField));
        AddFieldConfiguration addSourceTypeField = new AddFieldConfiguration("sourceType", logSourceConfigurationDTO.getSourceType(), ValueType.STRING);
        stages.add(PipelineStageConfigurationConverter.createAddFieldStageConfiguration(addSourceTypeField));
        if (logSourceConfigurationDTO.getExtractionConfigurations() != null) {
            boolean guidStageExists = false;
            for (FieldExtractionConfiguration config : logSourceConfigurationDTO.getExtractionConfigurations()) {
                PipelineStageConfiguration psc;
                GrokFieldExtractionConfiguration grokConfig;
                if (config instanceof AutoRegexFieldExtractionConfiguration) {
                    stages.add(PipelineStageConfigurationConverter.createAutoRegexStageConfiguration((AutoRegexFieldExtractionConfiguration)config));
                    continue;
                }
                if (config instanceof ManualRegexFieldExtractionConfiguration) {
                    stages.add(PipelineStageConfigurationConverter.createManualRegexStageConfiguration((ManualRegexFieldExtractionConfiguration)config));
                    continue;
                }
                if (config instanceof KeyValueExtractionConfiguration) {
                    KeyValueExtractionConfiguration keyValueConfig = (KeyValueExtractionConfiguration)config;
                    if (keyValueConfig.getKeyToField() == null) continue;
                    stages.add(PipelineStageConfigurationConverter.createKeyValueStageConfiguration(keyValueConfig));
                    continue;
                }
                if (!(config instanceof GrokFieldExtractionConfiguration) || (grokConfig = (GrokFieldExtractionConfiguration)config).getPattern() == null) continue;
                stages.add(PipelineStageConfigurationConverter.createGrokStageConfiguration(grokConfig));
                if (guidStageExists || (psc = PipelineConfigurationConverter.createRequestGuidStageConfiguration(variableValues, grokConfig)) == null) continue;
                guidStageExists = true;
                stages.add(psc);
            }
        }
        if (logSourceConfigurationDTO.getTimestampConfiguration() != null) {
            stages.add(PipelineStageConfigurationConverter.createDateTimeStageConfiguration(logSourceConfigurationDTO.getTimestampConfiguration()));
        }
        if (logSourceConfigurationDTO.getTimestampFilterConfiguration() != null && (collectLastNHours = (timestampFilterConfiguration = logSourceConfigurationDTO.getTimestampFilterConfiguration()).getCollectLastNHours()) != 0) {
            stages.add(PipelineStageConfigurationConverter.createTimestampFilterStageConfiguration(timestampFilterConfiguration));
        }
        if (logSourceConfigurationDTO.getTimestampConfiguration() != null && logSourceConfigurationDTO.getTimestampConfiguration().isCorrectDuplicateTimestamps()) {
            stages.add(PipelineStageConfigurationConverter.createDuplicateTimeCorrectionConfiguration());
        }
        if ((fieldConfigurations = logSourceConfigurationDTO.getFieldConfigurations()) != null) {
            for (FieldConfiguration fieldConfig : fieldConfigurations) {
                if (fieldConfig instanceof RemoveFieldConfiguration) {
                    stages.add(PipelineStageConfigurationConverter.createFieldRemovalStage((RemoveFieldConfiguration)fieldConfig));
                    continue;
                }
                if (fieldConfig instanceof MaskConfiguration) {
                    stages.add(PipelineStageConfigurationConverter.createFieldMaskingStageConfiguration((MaskConfiguration)fieldConfig));
                    continue;
                }
                if (fieldConfig instanceof AddFieldConfiguration) {
                    stages.add(PipelineStageConfigurationConverter.createAddFieldStageConfiguration((AddFieldConfiguration)fieldConfig));
                    continue;
                }
                if (fieldConfig instanceof RenameConfiguration) {
                    stages.add(PipelineStageConfigurationConverter.createFieldRenameStageConfiguration((RenameConfiguration)fieldConfig));
                    continue;
                }
                if (!(fieldConfig instanceof TypeConversionConfiguration)) continue;
                stages.add(PipelineStageConfigurationConverter.createFieldTypeConversionStageConfiguration((TypeConversionConfiguration)fieldConfig));
            }
        }
        stages.add(PipelineStageConfigurationConverter.createFieldRestrictionStageConfiguration());
        stages.add(PipelineStageConfigurationConverter.createMap2JsonStageConfiguration(true));
        String eventType = variableValues.getProperty(EVENT_TYPE_LOG);
        stages.add(PipelineStageConfigurationConverter.createTapStageConfiguration(eventType));
        return stages;
    }

    private static PipelineStageConfiguration createRequestGuidStageConfiguration(Properties variableValues, GrokFieldExtractionConfiguration grokFieldExtractionConfiguration) {
        String pattern = grokFieldExtractionConfiguration.getPattern();
        try {
            Grok grok = new Grok();
            List inputStreams = GrokUtils.getGrokFromResourcesSection();
            grok.addFromInputStreams(inputStreams.toArray(new InputStream[inputStreams.size()]));
            if (variableValues.containsKey(EVENT_ACCESS_KEY)) {
                String key = Sanitizer.sanitizeForJavaName((String)variableValues.getProperty(EVENT_ACCESS_KEY));
                Map fieldNameAndAlias = grok.getFieldNamesAndAlias(pattern);
                if (fieldNameAndAlias.containsKey("REQUEST_GUID")) {
                    return PipelineStageConfigurationConverter.createRequestGuidStageConfiguration(key, (String)fieldNameAndAlias.get("REQUEST_GUID"));
                }
            }
        }
        catch (IOException e) {
            log.error("Error occurred while parsing the Grok patterns", (Throwable)e);
        }
        return null;
    }

    @Generated
    private PipelineConfigurationConverter() {
    }
}

