/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.javaspecific.scheduler.ADScheduledThreadPoolExecutor;
import com.singularity.ee.util.javaspecific.scheduler.AgentScheduledThreadPoolExecutorImpl;
import com.singularity.ee.util.javaspecific.scheduler.ExecutionTracker;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentAtomicLong;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class AgentExecutorFactory {
    private volatile boolean pauseExecutions = false;
    private IAgentAtomicLong sleepTimeDuringPause = new AgentAtomicLongImpl(100L);

    public IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, ILogger logger) {
        return this.toIAgentScheduledThreadPoolExecutor(this.createADScheduledThreadPoolExecutor(corePoolSize, threadFactory), logger);
    }

    public IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int corePoolSize, ILogger logger) {
        return this.toIAgentScheduledThreadPoolExecutor(this.createADScheduledThreadPoolExecutor(corePoolSize), logger);
    }

    public IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int corePoolSize, int maxTasksAllowed, BoundsPolicy policy, ICustomAction customAction, ThreadFactory threadFactory, ILogger logger) {
        return this.toIAgentScheduledThreadPoolExecutor(this.createADScheduledThreadPoolExecutor(corePoolSize, maxTasksAllowed, policy, customAction, threadFactory), logger);
    }

    public IAgentScheduledThreadPoolExecutor newNonPausedScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, ILogger logger) {
        return this.toIAgentScheduledThreadPoolExecutor(new ADScheduledThreadPoolExecutor(corePoolSize, threadFactory), logger);
    }

    public IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int coreSize) {
        ILogger logger = null;
        return this.newScheduledThreadPool(coreSize, logger);
    }

    public IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        ILogger logger = null;
        return this.newScheduledThreadPool(corePoolSize, threadFactory, logger);
    }

    public void pauseExecutions(int sleepTimeDuringPause) {
        this.pauseExecutions = true;
        this.sleepTimeDuringPause.set((long)sleepTimeDuringPause);
    }

    public void resumeExecutions() {
        this.pauseExecutions = false;
    }

    private ADScheduledThreadPoolExecutor createADScheduledThreadPoolExecutor(int corePoolSize) {
        return new PausedExecutionScheduledThreadPoolExecutor(corePoolSize);
    }

    private ADScheduledThreadPoolExecutor createADScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        return new PausedExecutionScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    private ADScheduledThreadPoolExecutor createADScheduledThreadPoolExecutor(int corePoolSize, int maxTasksAllowed, BoundsPolicy policy, ICustomAction customAction, ThreadFactory threadFactory) {
        return new PausedExecutionScheduledThreadPoolExecutor(corePoolSize, maxTasksAllowed, policy, customAction, threadFactory);
    }

    private IAgentScheduledThreadPoolExecutor toIAgentScheduledThreadPoolExecutor(ADScheduledThreadPoolExecutor executor, ILogger logger) {
        return new AgentScheduledThreadPoolExecutorImpl(executor, logger);
    }

    private class PausedExecutionScheduledThreadPoolExecutor
    extends ADScheduledThreadPoolExecutor {
        public PausedExecutionScheduledThreadPoolExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        public PausedExecutionScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        public PausedExecutionScheduledThreadPoolExecutor(int corePoolSize, int maxTasksAllowed, BoundsPolicy policy, ICustomAction customAction, ThreadFactory threadFactory) {
            super(corePoolSize, maxTasksAllowed, policy, customAction, threadFactory);
        }

        protected void beforeExecute(Thread t, Runnable r) {
            while (AgentExecutorFactory.this.pauseExecutions) {
                try {
                    Thread.sleep(AgentExecutorFactory.this.sleepTimeDuringPause.get());
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (ExecutionTracker.ENABLED) {
                ExecutionTracker.track((Runnable)r);
            }
            super.beforeExecute(t, r);
        }
    }
}

