/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.xml;

import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatchType;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AgentXMLParseUtility {
    private static final String MATCH_TYPE = "match-type";
    private static final String MATCH_PATTERN = "match-pattern";
    private static final String REDACTION_REGEX = "redaction-regex";

    public static StringMatch[] parseStringMatches(Element containerElem, String tagName) {
        ArrayList<StringMatch> result = new ArrayList<StringMatch>();
        List elems = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)containerElem, (String)tagName);
        if (null != elems) {
            for (Element elem : elems) {
                result.add(AgentXMLParseUtility.parseStringMatch(elem));
            }
            return (StringMatch[])CollectionHelper.collectionToArray(result, (Object[])new StringMatch[result.size()]);
        }
        return null;
    }

    public static StringMatch parseStringMatch(Element elem) {
        Map attributes = XMLParseUtility.getAttributeMapForElement((Element)elem);
        String matchType = (String)attributes.get(MATCH_TYPE);
        String matchPattern = (String)attributes.get(MATCH_PATTERN);
        return new StringMatch(AgentXMLParseUtility.parseStringMatchType(matchType), matchPattern);
    }

    public static String parseRedactionRegex(Element elem) {
        Map attributes = XMLParseUtility.getAttributeMapForElement((Element)elem);
        return (String)attributes.get(REDACTION_REGEX);
    }

    public static StringMatchType parseStringMatchType(String matchType) {
        try {
            return (StringMatchType)EnumHelper.getEnum(StringMatchType.class, (String)matchType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid string match type : " + matchType);
        }
    }
}

