/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.shared.bounded.collections.safety;

import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.events.AgentEventData;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.util.HashMap;

public abstract class ASharedCustomAction
implements ICustomAction {
    private static final String ACTION_FOLLOW_UP_DELAY_PROPERTY = "action-follow-up-delay";
    private static long DEFAULT_FOLLOW_UP_DELAY_IN_MINUTES = SystemUtilsTranslateable.getLongProperty((String)"action-follow-up-delay", (long)5L);
    protected long followUpDelayInSeconds = DEFAULT_FOLLOW_UP_DELAY_IN_MINUTES * 60L;
    private final IEventGenerationService eventService;
    private final IAgentScheduledExecutorService scheduler;
    protected final String raiseBarrierDesc;
    protected final String lowerBarrierDesc;
    protected volatile boolean barrierRaised;
    protected volatile boolean disabled;
    protected volatile IAgentScheduledFuture followUpFuture;
    private static final String CURRENT_SIZE = "current size";
    private static final String MAX_SIZE = "max size";
    private static final String PROPERTY_NAME = "property name";
    private static final String SERVICE_NAME = "service name";

    protected ASharedCustomAction(IEventGenerationService eventService, IAgentScheduledExecutorService scheduler, String raiseBarrierDesc, String lowerBarrierDesc) {
        this.eventService = eventService;
        this.scheduler = scheduler;
        this.raiseBarrierDesc = raiseBarrierDesc;
        this.lowerBarrierDesc = lowerBarrierDesc;
    }

    protected abstract IADLogger getLogger();

    protected abstract void raiseBarrier(IBoundedCollection var1);

    protected abstract void lowerBarrier(IBoundedCollection var1);

    protected boolean isSafeToLowerBarrier(IBoundedCollection collection) {
        return collection.getCurrentSize() < collection.getBoundsEnforcer().getUpperLimit();
    }

    public synchronized void aboveCapacity(IBoundedCollection collection) {
        if (this.barrierRaised) {
            this.getLogger().debugParams("[{}] was already called, this invocation will be skipped", this.raiseBarrierDesc);
            return;
        }
        if (this.disabled) {
            this.getLogger().info("Attempt to [" + this.raiseBarrierDesc + "] ignored as the override flag is set");
            return;
        }
        this.notifyAndRaiseBarrier(collection);
        this.scheduleFollowUp(collection);
    }

    private void scheduleFollowUp(IBoundedCollection collection) {
        this.getLogger().debugParams("Scheduling follow-up task to attempt to un-{}", this.raiseBarrierDesc);
        FollowUpTask followUpTask = new FollowUpTask(this, collection);
        this.followUpFuture = this.scheduler.schedule((IAgentRunnable)followUpTask, this.followUpDelayInSeconds, AgentTimeUnit.SECONDS);
    }

    private void notifyAndRaiseBarrier(IBoundedCollection collection) {
        String eventMessage = String.format("[%s] triggered due to [%s]", this.raiseBarrierDesc, ActionEventType.ABOVE_CAPACITY.toString());
        this.sendEvent(eventMessage, collection);
        this.getLogger().debugParams("Performing: {}" + eventMessage, new Object[0]);
        this.raiseBarrier(collection);
        this.barrierRaised = true;
    }

    private void notifyAndLowerBarrier(IBoundedCollection collection) {
        String eventMessage = String.format("[%s] triggered due to [%s]", this.lowerBarrierDesc, ActionEventType.BELOW_CAPACITY);
        this.sendEvent(eventMessage, collection);
        this.getLogger().debugParams("Performing: {}" + eventMessage, new Object[0]);
        this.lowerBarrier(collection);
        this.barrierRaised = false;
    }

    public boolean isBarrierRaised() {
        return this.barrierRaised;
    }

    public void reset() {
        if (this.followUpFuture != null) {
            this.followUpFuture.cancel(true);
            this.followUpFuture = null;
        }
        this.barrierRaised = false;
    }

    private void sendEvent(String eventMessage, IBoundedCollection collection) {
        String boundsPropertyName = collection.getBoundsEnforcer().getBoundsPropertyName();
        String serviceName = collection.getBoundsEnforcer().getBoundsServiceName();
        int currentSize = collection.getCurrentSize();
        int upperLimit = collection.getBoundsEnforcer().getUpperLimit();
        HashMap<String, String> details = new HashMap<String, String>();
        details.put(SERVICE_NAME, serviceName);
        details.put(PROPERTY_NAME, boundsPropertyName);
        details.put(CURRENT_SIZE, String.valueOf(currentSize));
        details.put(MAX_SIZE, String.valueOf(upperLimit));
        String message = String.format("%s - Collection [%s]: currentSize=%d, upperLimit=%d, serviceName=%s, boundsPropertyName=%s", eventMessage, ReflectionUtilityCommon.getName(collection.getClass()), currentSize, upperLimit, serviceName, boundsPropertyName);
        this.getLogger().info(message);
        AgentEventData event = new AgentEventData(ClockUtils.getCurrentTime(), NotificationSeverity.WARN, EventType.AGENT_EVENT, details, message);
        event.setSubType("Transaction Monitoring Paused");
        this.eventService.addApplicationEvent(event);
    }

    protected static class ActionEventType {
        public static final ActionEventType ABOVE_CAPACITY = new ActionEventType("Collection size above capacity");
        public static final ActionEventType BELOW_CAPACITY = new ActionEventType("Collection size below capacity");
        private String text;

        private ActionEventType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    protected static final class FollowUpTask
    implements IAgentRunnable {
        private final ASharedCustomAction action;
        private final IBoundedCollection collection;

        public FollowUpTask(ASharedCustomAction action, IBoundedCollection collection) {
            this.action = action;
            this.collection = collection;
        }

        public void run() {
            if (this.action.isSafeToLowerBarrier(this.collection)) {
                this.action.notifyAndLowerBarrier(this.collection);
            } else {
                String message = String.format("Collection still at or above capacity. Will re-check in %s minute(s)", DEFAULT_FOLLOW_UP_DELAY_IN_MINUTES);
                this.action.sendEvent(message, this.collection);
                this.action.getLogger().debug(message);
                this.action.scheduleFollowUp(this.collection);
            }
        }
    }
}

