/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.log4j;

import com.google.common.annotations.VisibleForTesting;
import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.agent.util.log4j.ADLoggerWrapper;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicBooleanImpl;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.javaspecific.atomic.AgentVolatileLongImpl;
import com.singularity.ee.util.spi.IAgentAtomicBoolean;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IAgentVolatileLong;

public class RateLimitLogger
extends ADLoggerWrapper {
    private final IAgentVolatileLong lastResetTime;
    private final long minimumIntervalInMSec;
    private final IAgentAtomicBoolean suppressionLogged = new AgentAtomicBooleanImpl();
    private final IAgentAtomicInteger numLogged;
    private final int threshold;
    private final boolean limitTrace;
    private final boolean limitDebug;

    protected RateLimitLogger(IADLogger baseLogger, int threshold, long minimumIntervalInMSec) {
        this(baseLogger, ClockUtils.getCurrentTime(), threshold, minimumIntervalInMSec, false, false);
    }

    protected RateLimitLogger(IADLogger baseLogger, int threshold, long minimumIntervalInMSec, boolean limitDebug, boolean limitTrace) {
        this(baseLogger, ClockUtils.getCurrentTime(), threshold, minimumIntervalInMSec, limitDebug, limitTrace);
    }

    protected RateLimitLogger(IADLogger baseLogger, long currentTime, int threshold, long minimumIntervalInMSec, boolean limitDebug, boolean limitTrace) {
        super(baseLogger);
        this.lastResetTime = new AgentVolatileLongImpl(currentTime);
        this.minimumIntervalInMSec = minimumIntervalInMSec;
        this.threshold = threshold;
        this.limitDebug = limitDebug;
        this.limitTrace = limitTrace;
        this.numLogged = new AgentAtomicIntegerImpl();
    }

    @Override
    public void fatal(Object o) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.fatal(o);
    }

    @Override
    public void fatal(Object o, Throwable t) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.fatal(o, t);
    }

    @Override
    public void fatal(String msg) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.fatal(msg);
    }

    @Override
    public void fatal(String msg, Throwable t) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.fatal(msg, t);
    }

    @Override
    public void error(Object o) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.error(o);
    }

    @Override
    public void error(Object o, Throwable t) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.error(o, t);
    }

    @Override
    public void error(String msg) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.error(msg);
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.error(msg, t);
    }

    @Override
    public void warn(Object o) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.warn(o);
    }

    @Override
    public void warn(Object o, Throwable t) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.warn(o, t);
    }

    @Override
    public void warn(String msg) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.warn(msg);
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.warn(msg, t);
    }

    @Override
    public void info(Object o) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.info(o);
    }

    @Override
    public void info(Object o, Throwable t) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.info(o, t);
    }

    @Override
    public void info(String msg) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.info(msg);
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.info(msg, t);
    }

    @Override
    public void debug(Object o) {
        if (!this.baseLogger.isDebugEnabled()) {
            return;
        }
        if (this.limitDebug && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.debug(o);
    }

    @Override
    public void debug(Object o, Throwable t) {
        if (!this.baseLogger.isDebugEnabled()) {
            return;
        }
        if (this.limitDebug && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.debug(o, t);
    }

    @Override
    public void debug(String msg) {
        if (!this.baseLogger.isDebugEnabled()) {
            return;
        }
        if (this.limitDebug && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.debug(msg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (!this.baseLogger.isDebugEnabled()) {
            return;
        }
        if (this.limitDebug && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.debug(msg, t);
    }

    @Override
    public void debugParams(String msg, Object ... objects) {
        if (!this.baseLogger.isDebugEnabled()) {
            return;
        }
        if (this.limitDebug && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.debugParams(msg, objects);
    }

    @Override
    public void trace(Object o) {
        if (!this.baseLogger.isTraceEnabled()) {
            return;
        }
        if (this.limitTrace && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.trace(o);
    }

    @Override
    public void trace(Object o, Throwable t) {
        if (!this.baseLogger.isTraceEnabled()) {
            return;
        }
        if (this.limitTrace && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.trace(o, t);
    }

    @Override
    public void trace(String msg) {
        if (!this.baseLogger.isTraceEnabled()) {
            return;
        }
        if (this.limitTrace && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.trace(msg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (!this.baseLogger.isTraceEnabled()) {
            return;
        }
        if (this.limitTrace && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.trace(msg, t);
    }

    @Override
    public void traceParams(String msg, Object ... objects) {
        if (!this.baseLogger.isTraceEnabled()) {
            return;
        }
        if (this.limitTrace && this.incrementAndCheckLimit()) {
            return;
        }
        this.baseLogger.traceParams(msg, objects);
    }

    @Override
    public void log(ADLevel level, Object obj) {
        switch (level) {
            case DEBUG: {
                this.debug(obj);
                break;
            }
            case TRACE: {
                this.trace(obj);
                break;
            }
            default: {
                if (this.incrementAndCheckLimit()) {
                    return;
                }
                this.baseLogger.log(level, obj);
            }
        }
    }

    @Override
    public void log(ADLevel level, Object obj, Throwable t) {
        switch (level) {
            case DEBUG: {
                this.debug(obj, t);
                break;
            }
            case TRACE: {
                this.trace(obj, t);
                break;
            }
            default: {
                if (this.incrementAndCheckLimit()) {
                    return;
                }
                this.baseLogger.log(level, obj, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected boolean incrementAndCheckLimit() {
        if (this.numLogged.getAndIncrement() < this.threshold) {
            return false;
        }
        IAgentVolatileLong iAgentVolatileLong = this.lastResetTime;
        synchronized (iAgentVolatileLong) {
            long currentTime = this.getCurrentTime();
            long newResetTime = this.lastResetTime.get() + this.minimumIntervalInMSec;
            if (currentTime > newResetTime) {
                this.lastResetTime.set(currentTime);
                this.numLogged.set(1);
                this.suppressionLogged.set(false);
                return false;
            }
            if (this.numLogged.getAndIncrement() < this.threshold) {
                return false;
            }
        }
        if (this.baseLogger.isTraceEnabled() && this.suppressionLogged.compareAndSet(false, true)) {
            this.baseLogger.trace("Rate limit logger for [" + this.baseLogger.getName() + "] has been suppressed");
        }
        return true;
    }

    protected long getCurrentTime() {
        return ClockUtils.getCurrentTime();
    }

    public String toString() {
        return "RateLimitLogger{minimumIntervalInMSec=" + this.minimumIntervalInMSec + ", threshold=" + this.threshold + ", baseLoggerName=" + this.baseLogger.getName() + '}';
    }
}

