/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.log4j;

import com.singularity.ee.agent.util.log4j.ADLoggerWrapper;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.log4j.Log4J2Logger;
import com.singularity.ee.agent.util.log4j.Log4JLogger;
import com.singularity.ee.agent.util.log4j.LoggingFramework;
import com.singularity.ee.agent.util.log4j.RateLimitLogger;
import com.singularity.util.org.apache.log4j.Logger;
import org.apache.logging.log4j.LogManager;

public class ADLoggerFactory {
    private static volatile boolean isLog4J2 = true;
    private static Class<? extends ADLoggerWrapper> wrapperLoggerClass = null;

    private ADLoggerFactory() {
    }

    public static boolean isIsLog4J2() {
        return isLog4J2;
    }

    public static void setIsLog4J2(boolean isLog4J2) {
        ADLoggerFactory.isLog4J2 = isLog4J2;
    }

    public static void setWrapper(Class<? extends ADLoggerWrapper> loggerClazz) {
        wrapperLoggerClass = loggerClazz;
    }

    public static IADLogger getLogger(String name) {
        IADLogger logger = isLog4J2 ? new Log4J2Logger(LogManager.getLogger((String)name)) : new Log4JLogger(Logger.getLogger((String)name));
        return ADLoggerFactory.wrap(logger);
    }

    public static IADLogger getLogger(Class clazz) {
        IADLogger logger = isLog4J2 ? new Log4J2Logger(LogManager.getLogger((Class)clazz)) : new Log4JLogger(Logger.getLogger((Class)clazz));
        return ADLoggerFactory.wrap(logger);
    }

    public static IADLogger getLogger(String name, LoggingFramework framework) {
        IADLogger logger;
        switch (framework) {
            case LOG4J2: {
                logger = new Log4J2Logger(LogManager.getLogger((String)name));
                break;
            }
            case LOG4J: {
                logger = new Log4JLogger(Logger.getLogger((String)name));
                break;
            }
            default: {
                logger = new Log4JLogger(Logger.getLogger((String)name));
            }
        }
        return ADLoggerFactory.wrap(logger);
    }

    public static IADLogger getRootLogger() {
        if (isLog4J2) {
            return new Log4J2Logger(LogManager.getRootLogger());
        }
        return new Log4JLogger(Logger.getRootLogger());
    }

    public static IADLogger getRootLogger(LoggingFramework framework) {
        switch (framework) {
            case LOG4J: {
                return new Log4JLogger(Logger.getRootLogger());
            }
        }
        return new Log4J2Logger(LogManager.getRootLogger());
    }

    public static IADLogger getRateLimitLogger(IADLogger logger, int threshold, long minimumIntervalInMSec) {
        return new RateLimitLogger(logger, threshold, minimumIntervalInMSec);
    }

    public static IADLogger getRateLimitLogger(IADLogger logger, int threshold, long minimumIntervalInMSec, boolean limitDebug, boolean limitTrace) {
        return new RateLimitLogger(logger, threshold, minimumIntervalInMSec, limitDebug, limitTrace);
    }

    public static IADLogger exists(String name) {
        if (isLog4J2) {
            if (LogManager.getContext((boolean)false).hasLogger(name)) {
                return new Log4J2Logger(LogManager.getLogger((String)name));
            }
        } else {
            Logger trueLogger = Logger.getRootLogger().getLoggerRepository().exists(name);
            if (trueLogger != null) {
                return new Log4JLogger(trueLogger);
            }
        }
        return null;
    }

    private static IADLogger wrap(IADLogger baseLogger) {
        if (wrapperLoggerClass != null) {
            try {
                return wrapperLoggerClass.getConstructor(IADLogger.class).newInstance(baseLogger);
            }
            catch (Exception e) {
                baseLogger.error("error creating wrapper", e);
            }
        }
        return baseLogger;
    }
}

