/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container.clusteragentapi;

import com.singularity.ee.agent.util.container.ContainerInfoFetchService;
import com.singularity.ee.agent.util.container.clusteragentapi.ClusterAgentAPIConnector;
import java.util.Arrays;
import java.util.HashMap;

public class ContainerInfoClusterAgentApiService
extends ContainerInfoFetchService {
    private static final String[] requirementsList = new String[]{"APPDYNAMICS_CONTAINERINFO_FETCH_SERVICE", "HOSTNAME", "(APPDYNAMICS_CONTAINER_NAME or appdynamics.container.name)", "(APPDYNAMICS_POD_NAMESPACE or appdynamics.pod.namespace or /var/run/secrets/kubernetes.io/serviceaccount/namespace)"};

    @Override
    protected boolean checkAndInitRequirements() {
        boolean requirementsPresent = false;
        propertiesMap = new HashMap();
        requirementsPresent = ContainerInfoClusterAgentApiService.checkAndInitProp("APPDYNAMICS_CONTAINERINFO_FETCH_SERVICE", null) && ContainerInfoClusterAgentApiService.checkAndInitProp("HOSTNAME", null) && ContainerInfoClusterAgentApiService.checkAndInitProp("APPDYNAMICS_CONTAINER_NAME", "appdynamics.container.name");
        boolean bl = requirementsPresent = requirementsPresent && (ContainerInfoClusterAgentApiService.checkAndInitProp("APPDYNAMICS_POD_NAMESPACE", "appdynamics.pod.namespace") || ContainerInfoClusterAgentApiService.checkFileAndInitProp("/var/run/secrets/kubernetes.io/serviceaccount", "namespace", false));
        if (!requirementsPresent) {
            logger.warn("Make sure, following are configured and accessible to Agent\n" + Arrays.toString(requirementsList));
            return false;
        }
        logger.info("ClusterAgent API service Properties Successfully Initialized: " + propertiesMap.toString());
        logger.info("Creating Http Client using these props");
        apiConnector = new ClusterAgentAPIConnector(propertiesMap);
        if (apiConnector.getHttpClient() == null) {
            logger.warn("Could not create Http Client for " + apiConnector.getTarget());
            requirementsPresent = false;
        }
        return requirementsPresent;
    }

    @Override
    protected String parseResponse(String response) {
        String key;
        String[] kvUnformatted = response.split(":");
        if (kvUnformatted.length == 2 && (key = kvUnformatted[0].substring(kvUnformatted[0].indexOf(34) + 1, kvUnformatted[0].lastIndexOf(34))).equals("containerID")) {
            String value = kvUnformatted[1].substring(kvUnformatted[1].indexOf(34) + 1, kvUnformatted[1].lastIndexOf(34));
            return this.formatContainerId(value);
        }
        logger.warn("Unable to parse json response= " + response);
        return null;
    }
}

