/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container.clusteragentapi;

import com.singularity.ee.agent.util.container.APIConnector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public class ClusterAgentAPIConnector
extends APIConnector {
    private static final String TARGET_FORMAT = "http://%s/containerid";
    private static final String POD_NAME_PARAM = "podname";
    private static final String CONTAINER_NAME_PARAM = "containername";
    private static final String NAMESPACE_PARAM = "namespace";

    protected ClusterAgentAPIConnector() {
    }

    public ClusterAgentAPIConnector(Map<String, String> props) {
        super(props);
    }

    @Override
    protected void setTarget() {
        this.target = String.format(TARGET_FORMAT, this.APIProperties.get("APPDYNAMICS_CONTAINERINFO_FETCH_SERVICE"));
    }

    @Override
    protected void createRequest() {
        String namespace = (String)this.APIProperties.get("APPDYNAMICS_POD_NAMESPACE");
        if (namespace == null && (namespace = (String)this.APIProperties.get("appdynamics.pod.namespace")) == null) {
            namespace = (String)this.APIProperties.get(NAMESPACE_PARAM);
        }
        this.request = new HttpGet(this.target);
        try {
            URI uri = new URIBuilder(this.request.getURI()).addParameter(POD_NAME_PARAM, (String)this.APIProperties.get("HOSTNAME")).addParameter(CONTAINER_NAME_PARAM, (String)this.APIProperties.get("APPDYNAMICS_CONTAINER_NAME")).addParameter(NAMESPACE_PARAM, namespace).build();
            this.request.setURI(uri);
            this.request.setConfig(RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setSocketTimeout(this.readTimeout).build());
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    protected CloseableHttpClient createHttpClient() {
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>();
        headerList.add(new BasicHeader("Accept", "application/json"));
        headerList.add(new BasicHeader("Content-Type", "application/json"));
        return HttpClients.custom().setDefaultHeaders(headerList).build();
    }
}

