/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container;

import com.singularity.ee.agent.util.container.AbstractCGroupDetector;
import com.singularity.ee.util.logging.ILogger;

final class CGroupV2Detector
extends AbstractCGroupDetector {
    private static final String FILE_PATHNAME = "/proc/self/mountinfo";
    private static final String MARKING_PREFIX = "containers";

    protected CGroupV2Detector(ILogger logger) {
        super(logger);
    }

    @Override
    public String discoverContainerId() {
        return this.getContainerIdFromFile(FILE_PATHNAME);
    }

    @Override
    protected String extractContainerIdFromLine(String line) {
        if (line.contains(MARKING_PREFIX)) {
            String[] sections = line.split("/");
            for (int i = 0; i < sections.length - 1; ++i) {
                String section;
                if (!MARKING_PREFIX.equals(sections[i]) || (section = sections[i + 1]).length() != 64 || !section.matches("^[a-fA-F0-9]+$")) continue;
                return section;
            }
        }
        return null;
    }
}

