/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container;

import com.singularity.ee.agent.util.container.AbstractCGroupDetector;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import java.io.File;

final class CGroupV1Detector
extends AbstractCGroupDetector {
    private static final String UNIQUE_HOST_NAME_FILE_NAME = "/proc/self/cgroup";
    private static final String CRIO = "crio-";
    private static final String CRI_CONTAINERD = "cri-containerd-";
    private static final String DOCKER = "docker-";
    private static final String PREFIX_KEY = "appdynamics.container.id.prefix";
    private final String otherPrefix = System.getProperty("appdynamics.container.id.prefix");

    protected CGroupV1Detector(ILogger logger) {
        super(logger);
    }

    @Override
    public String discoverContainerId() {
        return this.getContainerIdFromFile(UNIQUE_HOST_NAME_FILE_NAME);
    }

    @Override
    protected String extractContainerIdFromLine(String line) {
        String[] sections;
        if (StringOperations.isNotEmpty((String)line) && (sections = line.split(File.separator)).length > 1) {
            String lastSection = sections[sections.length - 1];
            if (lastSection.startsWith(CRIO)) {
                lastSection = this.truncatePrefix(lastSection, CRIO);
            } else if (lastSection.startsWith(DOCKER)) {
                lastSection = this.truncatePrefix(lastSection, DOCKER);
            } else if (lastSection.startsWith(CRI_CONTAINERD)) {
                lastSection = this.truncatePrefix(lastSection, CRI_CONTAINERD);
            } else if (this.otherPrefix != null && lastSection.startsWith(this.otherPrefix)) {
                lastSection = this.truncatePrefix(lastSection, this.otherPrefix + "-");
            }
            if (lastSection.contains(".")) {
                lastSection = lastSection.split("\\.")[0];
            }
            if (lastSection.matches("^[a-fA-F0-9]+$")) {
                this.logger.debug("Detected appropriate hex string container ID: " + lastSection);
                return lastSection;
            }
        }
        this.logger.debug("Container ID is not a valid hex string");
        return null;
    }

    private String truncatePrefix(String lastSection, String prefix) {
        lastSection = lastSection.substring(prefix.length());
        return lastSection;
    }
}

