/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util;

import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

public class FastStringEncoder {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.FastStringEncoder");
    private MessageDigest firstMD5DigestInstance;
    private boolean supportClone;
    private static final FastStringEncoder instance = new FastStringEncoder(true);
    ThreadLocal<MessageDigest> threadLocalDigest;

    FastStringEncoder(boolean useClone) {
        try {
            this.firstMD5DigestInstance = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("MD5 not available");
            return;
        }
        if (!useClone) {
            return;
        }
        this.supportClone = true;
        try {
            this.firstMD5DigestInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.warn("MD5 digest instance clone not available, performance is impacted");
            this.supportClone = false;
        }
        if (this.supportClone) {
            this.threadLocalDigest = new ThreadLocal<MessageDigest>(){

                @Override
                protected MessageDigest initialValue() {
                    if (FastStringEncoder.this.firstMD5DigestInstance == null) {
                        return null;
                    }
                    try {
                        return (MessageDigest)FastStringEncoder.this.firstMD5DigestInstance.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        return null;
                    }
                }
            };
        }
    }

    public static FastStringEncoder getInstance() {
        return instance;
    }

    public String calculateMd5(String rawValue) {
        MessageDigest md;
        if (this.firstMD5DigestInstance == null) {
            return "";
        }
        try {
            md = this.createNewMd5Digest();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error happened when calculating md5", e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("sql digest instance [%s] at thread [%s]", System.identityHashCode(md), Thread.currentThread().getId()));
        }
        byte[] messageDigest = md.digest(StringUtils.getBytesUtf8((String)rawValue));
        return Hex.encodeHexString((byte[])messageDigest);
    }

    private MessageDigest createNewMd5Digest() throws NoSuchAlgorithmException {
        if (this.supportClone) {
            return this.threadLocalDigest.get();
        }
        return MessageDigest.getInstance("MD5");
    }

    MessageDigest getNewMd5DigestInstance() {
        return this.threadLocalDigest.get();
    }
}

