/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.AgentAccountInfo;
import com.singularity.ee.agent.resolver.AgentRegistrationInfo;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.resolver.IAgentAccountInfoResolver;
import com.singularity.ee.agent.resolver.IAgentRegistrationInfoResolver;
import com.singularity.ee.agent.resolver.IControllerInfoResolver;
import com.singularity.ee.agent.resolver.IHostIdentifierResolver;
import com.singularity.ee.agent.resolver.IIPAddressResolver;
import com.singularity.ee.agent.resolver.IResolver;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import java.util.ArrayList;
import java.util.List;

public class ResolverGroup {
    protected final ILogger logger;
    final List<IResolver> resolvers = new ArrayList<IResolver>();
    private String uniqueHostIdentifier;
    private ControllerInfo controllerInfo;
    private ControllerInfo.ControllerInfoMemento controllerInfoMemento;
    private AgentRegistrationInfo agentRegistrationInfo;
    private AgentAccountInfo agentAccountInfo;
    private String[] ipAddresses;
    private boolean expectedAsyncExecution;

    public ResolverGroup(ILogger logger) {
        this.logger = logger;
    }

    public void addResolver(IResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException("resolver is null");
        }
        if (this.resolvers.isEmpty()) {
            this.expectedAsyncExecution = resolver.resolveAsync();
        } else if (this.expectedAsyncExecution != resolver.resolveAsync()) {
            throw new IllegalStateException("ResolverGroup resolvers must all be sync or async, not mixed");
        }
        if (!(resolver instanceof IControllerInfoResolver || resolver instanceof IHostIdentifierResolver || resolver instanceof IIPAddressResolver || resolver instanceof IAgentRegistrationInfoResolver || resolver instanceof IAgentAccountInfoResolver)) {
            throw new IllegalArgumentException("Only controller info, account info, host identifier, ip address, and agent registration resolvers are supported");
        }
        this.resolvers.add(resolver);
    }

    public boolean containsUniqueHostIdentifierResolver() {
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IHostIdentifierResolver)) continue;
            return true;
        }
        return false;
    }

    public boolean resolvedUniqueHostIdentifier() {
        return this.uniqueHostIdentifier != null;
    }

    public String getUniqueHostIdentifier() {
        return this.uniqueHostIdentifier;
    }

    public boolean containsControllerInfoResolver() {
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IControllerInfoResolver)) continue;
            return true;
        }
        return false;
    }

    public boolean isControllerHostInfoResolved() {
        return this.controllerInfo != null || this.controllerInfoMergeRequired() && this.controllerInfoMemento.isPrimitiveInfoResolved() && this.controllerInfoMemento.isSecureCredentialInfoResolved() && this.controllerInfoMemento.isSslClientAuthInfoResolved();
    }

    private boolean isControllerHostInfoFullyResolved() {
        return this.controllerInfo != null;
    }

    public ControllerInfo getControllerHostInfo() {
        if (this.isControllerHostInfoFullyResolved()) {
            return this.controllerInfo;
        }
        if (this.isControllerHostInfoResolved()) {
            return this.controllerInfoMemento.getControllerInfo();
        }
        return null;
    }

    public boolean containsAgentAccountInfoResolver() {
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IAgentAccountInfoResolver)) continue;
            return true;
        }
        return false;
    }

    public boolean resolvedAgentAccountInfo() {
        return this.agentAccountInfo != null && !StringOperations.isEmptyAfterTrim((String)this.agentAccountInfo.getAccountName()) && !StringOperations.isEmptyAfterTrim((String)this.agentAccountInfo.getAccountAccessKey());
    }

    public AgentAccountInfo getAgentAccountInfo() {
        return this.agentAccountInfo;
    }

    public boolean containsAgentRegistrationInfoResolver() {
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IAgentRegistrationInfoResolver)) continue;
            return true;
        }
        return false;
    }

    public boolean resolvedAgentRegistrationInfo() {
        return this.agentRegistrationInfo != null;
    }

    public AgentRegistrationInfo getAgentRegistrationInfo() {
        return this.agentRegistrationInfo;
    }

    public boolean containsIPAddressResolver() {
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IIPAddressResolver)) continue;
            return true;
        }
        return false;
    }

    public boolean resolvedIPAddresses() {
        return this.ipAddresses != null;
    }

    public String[] getIPAddresses() {
        return this.ipAddresses;
    }

    int getNumberControllerInfoResolvers() {
        int numControllerInfoResolvers = 0;
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IControllerInfoResolver)) continue;
            ++numControllerInfoResolvers;
        }
        return numControllerInfoResolvers;
    }

    int getNumberAgentAccountInfoResolvers() {
        int numAccountInfoResolvers = 0;
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IAgentAccountInfoResolver)) continue;
            ++numAccountInfoResolvers;
        }
        return numAccountInfoResolvers;
    }

    int getNumberAgentRegistrationInfoResolvers() {
        int numHostIdResolvers = 0;
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IAgentRegistrationInfoResolver)) continue;
            ++numHostIdResolvers;
        }
        return numHostIdResolvers;
    }

    int getNumberHostIdResolvers() {
        int numHostIdResolvers = 0;
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IHostIdentifierResolver)) continue;
            ++numHostIdResolvers;
        }
        return numHostIdResolvers;
    }

    int getNumberIPAddressResolvers() {
        int numIPAddressResolvers = 0;
        for (IResolver resolver : this.resolvers) {
            if (!(resolver instanceof IIPAddressResolver)) continue;
            ++numIPAddressResolvers;
        }
        return numIPAddressResolvers;
    }

    void gatherResolutionOutcomeFrom(IResolver resolver) {
        if (resolver instanceof IControllerInfoResolver && !this.isControllerHostInfoFullyResolved()) {
            if (resolver.resolutionSucceeded()) {
                if (!this.controllerInfoMergeRequired()) {
                    this.controllerInfo = ((IControllerInfoResolver)resolver).getControllerHostInfo();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Fully resolved: " + this.controllerInfo);
                    }
                } else {
                    this.controllerInfo = ControllerInfo.ControllerInfoMemento.merge((ControllerInfo.ControllerInfoMemento)this.controllerInfoMemento, (ControllerInfo)((IControllerInfoResolver)resolver).getControllerHostInfo());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Fully resolved after merge: " + this.controllerInfo);
                    }
                }
            } else if (((IControllerInfoResolver)resolver).resolutionPartiallyCompleted()) {
                this.controllerInfoMemento = ControllerInfo.ControllerInfoMemento.merge((ControllerInfo.ControllerInfoMemento)this.controllerInfoMemento, (ControllerInfo.ControllerInfoMemento)((IControllerInfoResolver)resolver).getControllerInfoMemento());
                if (this.logger.isDebugEnabled()) {
                    ControllerInfo copyOfControllerInfo = this.controllerInfoMemento.getControllerInfo();
                    this.logger.debug("After successive merge: " + (copyOfControllerInfo != null ? copyOfControllerInfo.toString() : "Still incomplete primitive info."));
                }
                if (this.controllerInfoMemento.isFullyResolved()) {
                    this.controllerInfo = this.controllerInfoMemento.getControllerInfo();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Fully resolved after merge: " + this.controllerInfo);
                    }
                }
            }
        }
        if (resolver instanceof IAgentAccountInfoResolver && resolver.resolutionSucceeded()) {
            AgentAccountInfo agentAccountInfo = ((IAgentAccountInfoResolver)resolver).getAgentAccountInfo();
            if (this.agentAccountInfo == null) {
                this.agentAccountInfo = agentAccountInfo;
            } else {
                this.agentAccountInfo.merge(agentAccountInfo);
            }
        }
        if (resolver instanceof IAgentRegistrationInfoResolver && !this.resolvedAgentRegistrationInfo() && resolver.resolutionSucceeded()) {
            this.agentRegistrationInfo = ((IAgentRegistrationInfoResolver)resolver).getAgentRegistrationInfo();
        }
        if (resolver instanceof IHostIdentifierResolver && !this.resolvedUniqueHostIdentifier() && resolver.resolutionSucceeded()) {
            this.uniqueHostIdentifier = ((IHostIdentifierResolver)resolver).getUniqueHostIdentifier();
        }
        if (resolver instanceof IIPAddressResolver && !this.resolvedIPAddresses() && resolver.resolutionSucceeded()) {
            this.ipAddresses = ((IIPAddressResolver)resolver).getIPAddresses();
        }
    }

    private boolean controllerInfoMergeRequired() {
        return this.controllerInfoMemento != null;
    }
}

