/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.util.system.SystemUtils;
import com.singularity.ee.util.uuid.UUIDUtils;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EphemeralNodeNameResolverHelper {
    private static final int STRING_SIZE_64 = 64;
    private static final int NODE_NAME_UUID_SUFFIX_LENGTH = 5;

    public static String generateEphemeralNodeName() {
        StringBuilder nodeNameBuffer = new StringBuilder(64);
        try {
            String hostname = SystemUtils.getLocalHostName();
            if (hostname != null) {
                nodeNameBuffer.append(hostname);
                nodeNameBuffer.append('-');
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        nodeNameBuffer.append(new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss.SSSSSS").format(new Date()));
        nodeNameBuffer.append("-");
        nodeNameBuffer.append(UUIDUtils.getRandomUUID().substring(0, 5));
        return nodeNameBuffer.toString();
    }
}

