/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.util.logging.ILogger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;

public class DefaultIPAddressResolverHelper {
    public static String[] determineIPAddresses(ILogger logger) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    Enumeration<InetAddress> ipAddresses;
                    NetworkInterface ni = interfaces.nextElement();
                    if (ni == null || (ipAddresses = ni.getInetAddresses()) == null) continue;
                    while (ipAddresses.hasMoreElements()) {
                        String hostAddress;
                        InetAddress ipAddress = ipAddresses.nextElement();
                        if (ipAddress.isLoopbackAddress() || (hostAddress = ipAddress.getHostAddress()) == null) continue;
                        list.add(hostAddress);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Error finding ipaddresses for the host", e);
        }
        return list.toArray(new String[list.size()]);
    }

    static String getSingleIPAddress(ILogger logger) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                if (addresses == null) continue;
                InetAddress firstIPv4Address = null;
                InetAddress firstIPv6Address = null;
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress()) {
                        logger.info(String.format("Address '%s' not used for identification since it's a loopback address", address.getHostAddress()));
                        continue;
                    }
                    if (address.isLinkLocalAddress()) {
                        logger.info(String.format("Address '%s' not used for identification since it's a link-local address", address.getHostAddress()));
                        continue;
                    }
                    byte[] addressInBytes = address.getAddress();
                    if (addressInBytes == null) continue;
                    if (firstIPv4Address == null && addressInBytes.length == 4) {
                        firstIPv4Address = address;
                    }
                    if (firstIPv6Address != null || addressInBytes.length != 16) continue;
                    firstIPv6Address = address;
                }
                InetAddress chosenAddress = null;
                if (firstIPv4Address != null) {
                    chosenAddress = firstIPv4Address;
                } else if (firstIPv6Address != null) {
                    chosenAddress = firstIPv6Address;
                }
                if (chosenAddress == null) continue;
                logger.info(String.format("Using IP address '%s' from interface '%s' for identification", chosenAddress.getHostAddress(), iface.getName()));
                return chosenAddress.getHostAddress();
            }
        }
        catch (Throwable e) {
            logger.warn("Unexpected exception when querying network interfaces", e);
        }
        logger.warn("Could not determine suitable IP address.  Consider setting the appdynamics.agent.uniqueHostIdproperty.");
        return "<unknown>";
    }
}

