/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.ADefaultResolver;
import com.singularity.ee.agent.resolver.DefaultIPAddressResolverHelper;
import com.singularity.ee.agent.resolver.IIPAddressResolver;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.logging.ILogger;

public class DefaultIPAddressResolver
extends ADefaultResolver
implements IIPAddressResolver {
    private String[] ipAddresses;

    public DefaultIPAddressResolver(ILogger logger) {
        super(logger);
    }

    @Override
    public String getName() {
        return "Default IP Address Resolver";
    }

    @Override
    public String[] getIPAddresses() {
        return this.ipAddresses;
    }

    @Override
    public boolean resolveAsync() {
        return false;
    }

    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        this.ipAddresses = DefaultIPAddressResolverHelper.determineIPAddresses(this.logger);
        if (this.ipAddresses != null && this.ipAddresses.length > 0) {
            this.logger.info(this.getName() + " found IP addresses [" + CollectionHelper.arrayToString((Object[])this.ipAddresses) + "]");
        }
        this.logger.debug(this.getName() + " finished running");
    }

    @Override
    public boolean resolutionSucceeded() {
        return this.ipAddresses != null;
    }
}

