/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.DefaultHostIdentifierResolver;
import com.singularity.ee.agent.resolver.DefaultIPAddressResolverHelper;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.system.SystemUtils;

public class DefaultHostIdentifierResolverHelper {
    static String determineHostInfo(ILogger logger, String resolverName, DefaultHostIdentifierResolver.TruncateHostname truncate) {
        String hostName;
        try {
            hostName = truncate != null ? truncate.doTruncation(SystemUtils.getLocalHostName(), logger) : SystemUtils.getLocalHostName();
            logger.info(resolverName + " using host name for unique host identifier [" + hostName + "]");
        }
        catch (Throwable e) {
            logger.warn("Error in " + resolverName + " resolving host name", e);
            hostName = DefaultIPAddressResolverHelper.getSingleIPAddress(logger);
        }
        return hostName;
    }
}

