/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.agent.resolver.ADefaultResolver;
import com.singularity.ee.agent.resolver.DefaultHostIdentifierResolverHelper;
import com.singularity.ee.agent.resolver.IHostIdentifierResolver;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.string.StringRegexOperations;
import com.singularity.ee.util.system.SystemUtils;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.File;
import java.util.regex.Pattern;

public class DefaultHostIdentifierResolver
extends ADefaultResolver
implements IHostIdentifierResolver {
    private String uniqueHostInformation;
    private final String[] configFilePaths;

    public DefaultHostIdentifierResolver(ILogger logger, String[] configFilePath) {
        super(logger);
        this.configFilePaths = configFilePath;
    }

    @Override
    public String getUniqueHostIdentifier() {
        return this.uniqueHostInformation;
    }

    @Override
    public String getName() {
        return "Default Host Identifier Resolver";
    }

    @Override
    public boolean resolveAsync() {
        return false;
    }

    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        String uniqueHostIdentifier = this.getProperty("APPDYNAMICS_AGENT_UNIQUE_HOST_ID", "appdynamics.agent.uniqueHostId", "unique host identifier");
        if (uniqueHostIdentifier != null) {
            this.uniqueHostInformation = uniqueHostIdentifier;
        } else {
            TruncateHostname hostnameTruncationFromConfigs = this.getHostnameTruncationFromConfigsAndSysProp();
            this.uniqueHostInformation = DefaultHostIdentifierResolverHelper.determineHostInfo(this.logger, this.getName(), hostnameTruncationFromConfigs);
        }
        this.logger.debug(this.getName() + " finished running");
    }

    @Override
    public boolean resolutionSucceeded() {
        return this.uniqueHostInformation != null;
    }

    private TruncateHostname getHostnameTruncationFromConfigsAndSysProp() {
        boolean useSimpleHostname = Boolean.parseBoolean(SystemUtils.getProperty((String)"appdynamics.agent.use.simple.hostname"));
        if (useSimpleHostname) {
            return new TruncateHostname();
        }
        if (this.configFilePaths != null) {
            for (String nextConfigFile : this.configFilePaths) {
                TruncateHostname truncator;
                if (nextConfigFile == null || !new File(nextConfigFile).exists() || (truncator = this.getTruncateHostnameConfig(nextConfigFile)) == null) continue;
                return truncator;
            }
        }
        return null;
    }

    private TruncateHostname getTruncateHostnameConfig(String configFile) {
        Element rootElement;
        String truncateHostNameText;
        Document xmlDoc = null;
        try {
            xmlDoc = XMLParseUtility.getXMLDocument((String)configFile, (String)"Agent Identity XML File", (ILogger)this.logger);
        }
        catch (Exception e) {
            this.logger.error("Error reading identity xml file", (Throwable)e);
        }
        if (xmlDoc != null && !StringOperations.isEmpty((String)(truncateHostNameText = XMLParseUtility.getTextForTagForElement((Node)(rootElement = xmlDoc.getDocumentElement()), (String)"use-simple-hostname")))) {
            if ((truncateHostNameText = truncateHostNameText.toLowerCase()).equals("true")) {
                return new TruncateHostname();
            }
            if (truncateHostNameText.equals("false")) {
                return null;
            }
            this.logger.info(String.format("Received unrecognized value for [%s] property: [%s]", "use-simple-hostname", truncateHostNameText));
        }
        return null;
    }

    protected static class TruncateHostname {
        private static final Pattern IPV4_PATTERN = Pattern.compile("[0-9.]*");
        private int segmentsToTruncate;
        private boolean onlyRetainFirstSegment;

        protected TruncateHostname(int truncateDomains) {
            this.segmentsToTruncate = truncateDomains;
            this.onlyRetainFirstSegment = this.segmentsToTruncate > 0;
        }

        protected TruncateHostname() {
            this.onlyRetainFirstSegment = true;
            this.segmentsToTruncate = 0;
        }

        public String doTruncation(String hostname, ILogger logger) {
            if (this.checkIPv4address(hostname) || this.checkIPv6address(hostname)) {
                return hostname;
            }
            String truncatedHostName = hostname;
            if (this.segmentsToTruncate > 0) {
                int temp;
                int currIdx = hostname.length();
                for (int segmentsLeftToTruncate = this.segmentsToTruncate; segmentsLeftToTruncate > 0 && (temp = hostname.lastIndexOf(".", currIdx - 1)) >= 0; --segmentsLeftToTruncate) {
                    currIdx = temp;
                }
                truncatedHostName = hostname.substring(0, currIdx);
            } else if (this.onlyRetainFirstSegment) {
                String[] split = StringRegexOperations.split((String)hostname, (String)"\\.");
                truncatedHostName = split[0];
            }
            logger.info(String.format("Full hostname [%s] truncated to [%s}", hostname, truncatedHostName));
            return truncatedHostName;
        }

        private boolean checkIPv6address(String hostName) {
            return hostName.indexOf(58) >= 0;
        }

        private boolean checkIPv4address(String hostName) {
            return IPV4_PATTERN.matcher(hostName).matches();
        }
    }
}

