/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.ADefaultResolver;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.resolver.IControllerInfoResolver;
import com.singularity.ee.util.httpclient.TrustManagerShouldDoDefaultValidation;
import com.singularity.ee.util.logging.ILogger;

public class DefaultControllerInfoResolver
extends ADefaultResolver
implements IControllerInfoResolver {
    private ControllerInfo.ControllerInfoMemento controllerInfoMemento;

    public DefaultControllerInfoResolver(ILogger logger) {
        super(logger);
    }

    @Override
    public ControllerInfo getControllerHostInfo() {
        return null;
    }

    @Override
    public ControllerInfo.ControllerInfoMemento getControllerInfoMemento() {
        return this.controllerInfoMemento;
    }

    @Override
    public String getName() {
        return "Default Controller Info Resolver";
    }

    @Override
    public boolean resolutionSucceeded() {
        return false;
    }

    @Override
    public boolean resolutionPartiallyCompleted() {
        return this.controllerInfoMemento != null;
    }

    @Override
    public boolean resolveAsync() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        String controllerHostName = this.getProperty("APPDYNAMICS_CONTROLLER_HOST_NAME", "appdynamics.controller.hostName", "controller host name");
        String controllerPort = this.getProperty("APPDYNAMICS_CONTROLLER_PORT", "appdynamics.controller.port", "controller port");
        String sslEnabled = this.getProperty("APPDYNAMICS_CONTROLLER_SSL_ENABLED", "appdynamics.controller.ssl.enabled", "controller ssl enabled");
        String controllerKeystoreFileName = this.getProperty("APPDYNAMICS_CONTROLLER_KEYSTORE_FILENAME", "appdynamics.controller.keystoreFileName", "controller keystore filename");
        String controllerKeystorePassword = this.getProperty("APPDYNAMICS_CONTROLLER_KEYSTORE_PASSWORD", "appdynamics.controller.keystorePassword", "controller keystore password");
        try {
            this.saveToMemento(controllerHostName, controllerPort, sslEnabled, controllerKeystoreFileName, controllerKeystorePassword);
        }
        catch (Exception e) {
            this.logger.warn("Error in " + this.getName() + " resolving controller info", (Throwable)e);
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getName() + " finished running. Read:  hostName: " + controllerHostName + " portNo: " + controllerPort + " SSL-Enabled: " + sslEnabled + " Controller keystore filename" + controllerKeystoreFileName);
            }
        }
    }

    private void saveToMemento(String controllerHostName, String controllerPort, String sslEnabled, String keystoreFileName, String keystorePassword) {
        this.controllerInfoMemento = new ControllerInfo.ControllerInfoMemento(controllerHostName, controllerPort, sslEnabled, keystoreFileName, keystorePassword, (String)null, (String)null, (String)null, (String)null, (String)null, (String)null, (String)null, (String)null, (String)null, TrustManagerShouldDoDefaultValidation.UNSPECIFIED);
    }
}

