/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.ADefaultResolver;
import com.singularity.ee.agent.resolver.AgentRegistrationInfo;
import com.singularity.ee.agent.resolver.IAgentRegistrationInfoResolver;
import com.singularity.ee.util.logging.ILogger;

public class DefaultAgentRegistrationInfoResolver
extends ADefaultResolver
implements IAgentRegistrationInfoResolver {
    private AgentRegistrationInfo agentRegistrationInfo;

    public DefaultAgentRegistrationInfoResolver(ILogger logger) {
        super(logger);
    }

    @Override
    public AgentRegistrationInfo getAgentRegistrationInfo() {
        return this.agentRegistrationInfo;
    }

    @Override
    public String getName() {
        return "Default Agent Registration Info Resolver";
    }

    @Override
    public boolean resolutionSucceeded() {
        return this.agentRegistrationInfo != null;
    }

    @Override
    public boolean resolveAsync() {
        return false;
    }

    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        String applicationName = this.getProperty("APPDYNAMICS_AGENT_APPLICATION_NAME", "appdynamics.agent.applicationName", "application name");
        String tierName = this.getProperty("APPDYNAMICS_AGENT_TIER_NAME", "appdynamics.agent.tierName", "tier name");
        String nodeName = this.getProperty("APPDYNAMICS_AGENT_NODE_NAME", "appdynamics.agent.nodeName", "node name");
        if (applicationName != null && tierName != null) {
            this.agentRegistrationInfo = new AgentRegistrationInfo(applicationName, tierName, nodeName, false);
        }
        this.logger.debug(this.getName() + " finished running");
    }
}

