/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.ADefaultResolver;
import com.singularity.ee.agent.resolver.AgentAccountInfo;
import com.singularity.ee.agent.resolver.IAgentAccountInfoResolver;
import com.singularity.ee.util.logging.ILogger;

public class DefaultAgentAccountInfoResolver
extends ADefaultResolver
implements IAgentAccountInfoResolver {
    private AgentAccountInfo agentAccountInfo;

    public DefaultAgentAccountInfoResolver(ILogger logger) {
        super(logger);
    }

    @Override
    public AgentAccountInfo getAgentAccountInfo() {
        return this.agentAccountInfo;
    }

    @Override
    public String getName() {
        return "Default Agent Account Info Resolver";
    }

    @Override
    public boolean resolutionSucceeded() {
        return this.agentAccountInfo != null;
    }

    @Override
    public boolean resolveAsync() {
        return false;
    }

    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        String accountName = this.getProperty("APPDYNAMICS_AGENT_ACCOUNT_NAME", "appdynamics.agent.accountName", "account name");
        String accountAccessKey = this.getProperty("APPDYNAMICS_AGENT_ACCOUNT_ACCESS_KEY", "appdynamics.agent.accountAccessKey", "account access key");
        this.agentAccountInfo = new AgentAccountInfo(accountName, accountAccessKey, false);
        this.logger.debug(this.getName() + " finished running");
    }
}

