/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.ACloudInstanceUserDataResolver;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.util.SystemInfo;
import com.singularity.ee.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class CloudResolver
extends ACloudInstanceUserDataResolver {
    public CloudResolver(ILogger logger) {
        super(logger);
    }

    @Override
    public String getName() {
        return "Agent Resolver";
    }

    @Override
    public void cancelResolution() {
    }

    @Override
    public void cleanUpAfterRun() {
    }

    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        try {
            String userData = this.retrieveUserDataFromFileSystem();
            this.parseUserDataResponse(userData);
        }
        catch (Exception e) {
            this.logger.error("Exception during " + this.getName() + " resolution", (Throwable)e);
        }
        finally {
            this.logger.debug(this.getName() + " finished running");
        }
    }

    private String retrieveUserDataFromFileSystem() throws IOException {
        boolean isWindows;
        File[] roots = File.listRoots();
        if (roots != null && roots.length > 0) {
            for (File root : roots) {
                File userDataFile = new File(root, ".appdynamics");
                if (!userDataFile.isFile()) continue;
                return this.readUserDataFromFile(userDataFile);
            }
        }
        if (isWindows = SystemInfo.isWindowsMachine()) {
            for (char letter = 'A'; letter <= 'Z'; letter = (char)(letter + '\u0001')) {
                File userDataFile = new File(letter + ":" + File.separator + "appdynamics.txt");
                if (!userDataFile.isFile()) continue;
                return this.readUserDataFromFile(userDataFile);
            }
        } else {
            File userDataFile = new File("/.appdynamics");
            if (userDataFile.isFile()) {
                return this.readUserDataFromFile(userDataFile);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readUserDataFromFile(File file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String string = reader.readLine();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public ControllerInfo.ControllerInfoMemento getControllerInfoMemento() {
        return null;
    }

    @Override
    public boolean resolutionPartiallyCompleted() {
        return false;
    }
}

