/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.AgentAccountInfo;
import com.singularity.ee.agent.resolver.AgentRegistrationInfo;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.resolver.ResolverGroup;
import com.singularity.ee.agent.resolver.ResolverGroupHelper;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.httpclient.HttpProxyCredential;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapperFactory;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.util.ArrayList;
import java.util.List;

public class AgentResolver {
    public static final long NEVER_TIMEOUT_EXECUTION = -1L;
    public static final String JCEKS_FORMAT = "JCEKS";
    private final List<ResolverGroup> resolverGroups;
    private String uniqueHostIdentifier;
    private ControllerInfo controllerInfo;
    private AgentRegistrationInfo agentRegistrationInfo;
    private AgentAccountInfo agentAccountInfo;
    private String[] ipAddresses;
    private HttpProxyCredential httpProxyCredential;
    private final ILogger logger;

    public AgentResolver(ILogger logger) {
        this.logger = logger;
        this.resolverGroups = new ArrayList<ResolverGroup>();
    }

    public void addResolverGroup(ResolverGroup resolverGroup) {
        if (resolverGroup == null) {
            throw new NullPointerException("resolver group is null");
        }
        this.resolverGroups.add(resolverGroup);
    }

    public boolean execute(long timeoutMilliseconds, long sleepInterval) throws InterruptedException {
        if (timeoutMilliseconds == 0L) {
            throw new IllegalArgumentException("illegal timeout: " + timeoutMilliseconds);
        }
        if (sleepInterval <= 0L) {
            throw new IllegalArgumentException("illegal sleep interval: " + sleepInterval);
        }
        if (timeoutMilliseconds <= -1L) {
            timeoutMilliseconds = Long.MAX_VALUE;
        }
        boolean expectToResolveHostIdBoolean = this.expectToResolveHostId();
        boolean expectToResolveControllerInfoBoolean = this.expectToResolveControllerInfo();
        boolean expectToResolveAgentRegistrationInfoBoolean = this.expectToResolveAgentRegistrationInfo();
        boolean expectToResolveAgentAccountInfoBoolean = this.expectToResolveAgentAccountInfo();
        boolean expectToResolveIPAddressesBoolean = this.expectToResolveIPAddresses();
        if (!(expectToResolveHostIdBoolean || expectToResolveControllerInfoBoolean || expectToResolveAgentAccountInfoBoolean || expectToResolveIPAddressesBoolean)) {
            throw new IllegalStateException("The agent resolver is not doing the expected resolution!");
        }
        ArrayList<String> resolutionIssues = new ArrayList<String>();
        boolean foundResults = false;
        long startTime = ClockUtils.getCurrentTime();
        do {
            for (ResolverGroup resolverGroup : this.resolverGroups) {
                StringBuilder builder;
                this.handleFindResolverGroupInfo(resolverGroup);
                if (expectToResolveHostIdBoolean != this.resolvedUniqueHostIdentifier()) {
                    builder = new StringBuilder();
                    builder.append("Host ID is supposed to be ").append(expectToResolveHostIdBoolean ? "" : "not ").append("resolved, but found ").append(this.resolvedUniqueHostIdentifier() ? "resolved host ID" : "no resolved host ID");
                    resolutionIssues.add(builder.toString());
                    this.logger.debug("Mismatch for host id resolution");
                    continue;
                }
                if (expectToResolveControllerInfoBoolean != this.resolvedControllerHostInfo()) {
                    builder = new StringBuilder();
                    builder.append("Controller host info is supposed to be ").append(expectToResolveControllerInfoBoolean ? "" : "not ").append("resolved, but found ").append(this.resolvedControllerHostInfo() ? "resolved controller host info" : "no resolved controller host info");
                    resolutionIssues.add(builder.toString());
                    this.logger.debug("Mismatch for controller info resolution");
                    continue;
                }
                if (expectToResolveAgentRegistrationInfoBoolean != this.resolvedAgentRegistrationInfo()) {
                    builder = new StringBuilder();
                    builder.append("Agent registration info is supposed to be ").append(expectToResolveAgentRegistrationInfoBoolean ? "" : "not ").append("resolved, but found ").append(this.resolvedAgentRegistrationInfo() ? "resolved agent registration info" : "no resolved agent registration info");
                    resolutionIssues.add(builder.toString());
                    resolutionIssues.add(builder.toString());
                    this.logger.debug("Mismatch for agent registration info resolution");
                    continue;
                }
                if (expectToResolveAgentAccountInfoBoolean != this.resolvedAgentAccountInfo()) {
                    builder = new StringBuilder();
                    builder.append("Agent account info is supposed to be ").append(expectToResolveAgentAccountInfoBoolean ? "" : "not ").append("resolved, but found ").append(this.resolvedAgentAccountInfo() ? "resolved agent account info" : "no account info, empty account name, or empty account key");
                    resolutionIssues.add(builder.toString());
                    this.logger.debug("Mismatch for agent account info resolution");
                    continue;
                }
                if (expectToResolveIPAddressesBoolean != this.resolvedIPAddresses()) {
                    builder = new StringBuilder();
                    builder.append("IP address is supposed to be ").append(expectToResolveIPAddressesBoolean ? "" : "not ").append("resolved, but found ").append(this.resolvedIPAddresses() ? "" : "no ").append("resolved IP addresses");
                    resolutionIssues.add(builder.toString());
                    this.logger.debug("Mismatch for ip address solution");
                    continue;
                }
                foundResults = true;
                break;
            }
            if (foundResults) continue;
            Thread.sleep((int)sleepInterval);
        } while (!foundResults && ClockUtils.getCurrentTime() - startTime < timeoutMilliseconds);
        if (foundResults && expectToResolveControllerInfoBoolean) {
            this.decryptControllerInfo();
        } else if (resolutionIssues.size() > 0) {
            this.logger.warn("Possible reasons for unsuccessful agent resolver leading to agent disable: [" + StringOperations.convertToDelimiterSeparatedString(resolutionIssues, (String)"][") + "]");
        }
        return foundResults;
    }

    private void handleFindResolverGroupInfo(ResolverGroup resolverGroup) throws InterruptedException {
        ResolverGroupHelper.executeResolvers(resolverGroup);
        if (!this.resolvedUniqueHostIdentifier() && resolverGroup.resolvedUniqueHostIdentifier()) {
            this.uniqueHostIdentifier = resolverGroup.getUniqueHostIdentifier();
        }
        if (!this.resolvedControllerHostInfo() && resolverGroup.isControllerHostInfoResolved()) {
            this.controllerInfo = resolverGroup.getControllerHostInfo();
        }
        if (!this.resolvedAgentRegistrationInfo() && resolverGroup.resolvedAgentRegistrationInfo()) {
            this.agentRegistrationInfo = resolverGroup.getAgentRegistrationInfo();
        }
        if (!this.resolvedAgentAccountInfo() && resolverGroup.resolvedAgentAccountInfo()) {
            this.agentAccountInfo = resolverGroup.getAgentAccountInfo();
        }
        if (!this.resolvedIPAddresses() && resolverGroup.resolvedIPAddresses()) {
            this.ipAddresses = resolverGroup.getIPAddresses();
        }
    }

    private void decryptControllerInfo() {
        KeyStoreBasedEncryptionWrapper encryptionWrapper = null;
        try {
            if (this.controllerInfo.getUseEncryptedCredentials()) {
                String credentialStoreFileName = this.controllerInfo.getCredentialStoreFilename();
                String obfuscatedStorePassword = this.controllerInfo.getCredentialStorePassword();
                String credentialStoreFormat = this.controllerInfo.getCredentialStoreFormat();
                encryptionWrapper = new KeyStoreBasedEncryptionWrapperFactory().createWithObfuscatedPassword(credentialStoreFileName, obfuscatedStorePassword, credentialStoreFormat != null && credentialStoreFormat.length() > 0 ? credentialStoreFormat : JCEKS_FORMAT);
                String accountAccessKey = encryptionWrapper.decryptCipherTextString(this.agentAccountInfo.getAccountAccessKey());
                this.agentAccountInfo = new AgentAccountInfo(this.agentAccountInfo.getAccountName(), accountAccessKey, false);
                if (!(StringOperations.isEmptyAfterTrim((String)this.controllerInfo.getKeystorePassword()) && StringOperations.isEmptyAfterTrim((String)this.controllerInfo.getAsymmetricKeysStorePassword()) && StringOperations.isEmptyAfterTrim((String)this.controllerInfo.getAsymmetricKeyPassword()))) {
                    String keyStorePassword = !StringOperations.isEmptyAfterTrim((String)this.controllerInfo.getKeystorePassword()) ? encryptionWrapper.decryptCipherTextString(this.controllerInfo.getKeystorePassword()) : this.controllerInfo.getKeystorePassword();
                    String asymmetricKeysStorePassword = !StringOperations.isEmptyAfterTrim((String)this.controllerInfo.getAsymmetricKeysStorePassword()) ? encryptionWrapper.decryptCipherTextString(this.controllerInfo.getAsymmetricKeysStorePassword()) : this.controllerInfo.getAsymmetricKeysStorePassword();
                    String asymmetricKeyPassword = !StringOperations.isEmptyAfterTrim((String)this.controllerInfo.getAsymmetricKeyPassword()) ? encryptionWrapper.decryptCipherTextString(this.controllerInfo.getAsymmetricKeyPassword()) : this.controllerInfo.getAsymmetricKeyPassword();
                    this.controllerInfo = new ControllerInfo(this.controllerInfo.getControllerHostName(), this.controllerInfo.getControllerPort(), this.controllerInfo.getSslEnabled(), this.controllerInfo.getResolvedKeystoreFileName(), keyStorePassword, this.controllerInfo.getUseEncryptedCredentials(), this.controllerInfo.getCredentialStoreFilename(), this.controllerInfo.getCredentialStorePassword(), this.controllerInfo.getCredentialStoreFormat(), this.controllerInfo.getUseSslClientAuth(), this.controllerInfo.getAsymmetricKeysStoreFilename(), asymmetricKeysStorePassword, asymmetricKeyPassword, this.controllerInfo.getAsymmetricKeyAlias(), this.controllerInfo.getValidation());
                }
            }
            this.httpProxyCredential = new HttpProxyCredential(encryptionWrapper, SystemUtils.getSystemProperties(), this.logger);
        }
        catch (Exception allExceptions) {
            throw new IllegalStateException("Agent resolver failed to decrypt credentials. ", allExceptions);
        }
    }

    private boolean expectToResolveHostId() {
        for (ResolverGroup resolverGroup : this.resolverGroups) {
            if (!resolverGroup.containsUniqueHostIdentifierResolver()) continue;
            return true;
        }
        return false;
    }

    private boolean expectToResolveControllerInfo() {
        for (ResolverGroup resolverGroup : this.resolverGroups) {
            if (!resolverGroup.containsControllerInfoResolver()) continue;
            return true;
        }
        return false;
    }

    private boolean expectToResolveAgentRegistrationInfo() {
        for (ResolverGroup resolverGroup : this.resolverGroups) {
            if (!resolverGroup.containsAgentRegistrationInfoResolver()) continue;
            return true;
        }
        return false;
    }

    private boolean expectToResolveAgentAccountInfo() {
        for (ResolverGroup resolverGroup : this.resolverGroups) {
            if (!resolverGroup.containsAgentAccountInfoResolver()) continue;
            return true;
        }
        return false;
    }

    private boolean expectToResolveIPAddresses() {
        for (ResolverGroup resolverGroup : this.resolverGroups) {
            if (!resolverGroup.containsIPAddressResolver()) continue;
            return true;
        }
        return false;
    }

    public boolean resolvedUniqueHostIdentifier() {
        return this.uniqueHostIdentifier != null;
    }

    public String getUniqueHostIdentifier() {
        return this.uniqueHostIdentifier;
    }

    public boolean resolvedControllerHostInfo() {
        return this.controllerInfo != null;
    }

    public ControllerInfo getControllerHostInfo() {
        return this.controllerInfo;
    }

    public boolean resolvedAgentRegistrationInfo() {
        return this.agentRegistrationInfo != null;
    }

    public AgentRegistrationInfo getAgentRegistrationInfo() {
        return this.agentRegistrationInfo;
    }

    public boolean resolvedAgentAccountInfo() {
        return this.agentAccountInfo != null && !StringOperations.isEmptyAfterTrim((String)this.agentAccountInfo.getAccountName()) && !StringOperations.isEmptyAfterTrim((String)this.agentAccountInfo.getAccountAccessKey());
    }

    public AgentAccountInfo getAgentAccountInfo() {
        return this.agentAccountInfo;
    }

    public boolean resolvedIPAddresses() {
        return this.ipAddresses != null;
    }

    public String[] getIPAddresses() {
        return this.ipAddresses;
    }

    public HttpProxyCredential getHttpProxyCredential() {
        return this.httpProxyCredential;
    }
}

