/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.ACloudInstanceUserDataResolver;
import com.singularity.ee.agent.resolver.CloudInstanceDataWebServiceResolverHelper;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.util.logging.ILogger;

public class AWSResolver
extends ACloudInstanceUserDataResolver {
    private final CloudInstanceDataWebServiceResolverHelper helper;

    public AWSResolver(ILogger logger) {
        super(logger);
        this.helper = new CloudInstanceDataWebServiceResolverHelper(this, logger);
        this.cleanUpAfterRun();
    }

    @Override
    public String getName() {
        return "AWS Agent Resolver";
    }

    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        try {
            CloudInstanceDataWebServiceResolverHelper.WebServiceResponse response = this.helper.connectToDataWebServiceAndParseResponse(true, false);
            if (response != null) {
                this.parseUserDataResponse(response.userData);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception during " + this.getName() + " resolution", (Throwable)e);
        }
        finally {
            this.logger.debug(this.getName() + " finished running");
        }
    }

    @Override
    public void cancelResolution() {
        this.helper.cancelResolution();
    }

    @Override
    public void cleanUpAfterRun() {
        this.helper.cleanUpAfterRun();
    }

    @Override
    public ControllerInfo.ControllerInfoMemento getControllerInfoMemento() {
        return null;
    }

    @Override
    public boolean resolutionPartiallyCompleted() {
        return false;
    }
}

