/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.AgentAccountInfo;
import com.singularity.ee.agent.resolver.AgentResolutionDecoder;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.resolver.IAgentAccountInfoResolver;
import com.singularity.ee.agent.resolver.IControllerInfoResolver;
import com.singularity.ee.agent.resolver.IHostIdentifierResolver;
import com.singularity.ee.util.logging.ILogger;

public abstract class ACloudInstanceUserDataResolver
implements IHostIdentifierResolver,
IControllerInfoResolver,
IAgentAccountInfoResolver {
    protected final ILogger logger;
    private final Object resolutionInfoLock = new Object();
    private String uniqueHostId;
    private ControllerInfo controllerInfo;
    private AgentAccountInfo accountInfo;

    protected ACloudInstanceUserDataResolver(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public abstract String getName();

    @Override
    public abstract void cleanUpAfterRun();

    @Override
    public abstract void cancelResolution();

    @Override
    public abstract void run();

    @Override
    public boolean resolveAsync() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resolutionSucceeded() {
        Object object = this.resolutionInfoLock;
        synchronized (object) {
            return this.uniqueHostId != null && this.controllerInfo != null && this.accountInfo != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseUserDataResponse(String userData) {
        AgentResolutionDecoder decoder = new AgentResolutionDecoder(userData, this.logger);
        if (decoder.isValidAgentResolutionInfo()) {
            this.logger.info(this.getName() + " found valid agent resolution info [" + userData + "]");
        } else {
            this.logger.info(this.getName() + " did not find valid agent resolution info [" + userData + "]");
        }
        Object object = this.resolutionInfoLock;
        synchronized (object) {
            this.controllerInfo = decoder.getControllerHostInfo();
            if (this.controllerInfo != null) {
                this.logger.info(this.getName() + " using controller host name [" + this.controllerInfo.getControllerHostName() + "]");
                this.logger.info(this.getName() + " using controller port [" + this.controllerInfo.getControllerPort() + "]");
            }
            this.uniqueHostId = decoder.getUniqueHostIdentifier();
            if (this.uniqueHostId != null) {
                this.logger.info(this.getName() + " using unique host identifier [" + this.uniqueHostId + "]");
            }
            this.accountInfo = decoder.getAgentAccountInfo();
            if (this.accountInfo != null) {
                this.logger.info(this.getName() + " using account name [" + this.accountInfo.getAccountName() + "]");
                this.logger.info(this.getName() + " using account access key [****]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUniqueHostIdentifier() {
        Object object = this.resolutionInfoLock;
        synchronized (object) {
            return this.uniqueHostId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControllerInfo getControllerHostInfo() {
        Object object = this.resolutionInfoLock;
        synchronized (object) {
            return this.controllerInfo;
        }
    }

    @Override
    public abstract ControllerInfo.ControllerInfoMemento getControllerInfoMemento();

    @Override
    public abstract boolean resolutionPartiallyCompleted();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentAccountInfo getAgentAccountInfo() {
        Object object = this.resolutionInfoLock;
        synchronized (object) {
            return this.accountInfo;
        }
    }
}

