/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.debug.events;

import com.singularity.ee.agent.debug.events.AgentDebugEvent;
import com.singularity.ee.agent.debug.events.AgentDebugEventBaseHelper;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.uuid.UUIDUtils;
import java.util.HashMap;

public class AgentDebugEventBase
implements AgentDebugEvent,
SingularitySerializable {
    private static final long serialVersionUID = 7887134200824815804L;
    private static final String SRC_GUID = UUIDUtils.getRandomUUID();
    private static int SERIAL_ID = 0;
    private String eventType;
    private Object eventObject;
    protected String tierName;
    protected String appName;
    protected String nodeName;
    protected String tierId;
    protected String appId;
    protected String nodeId;
    protected AgentDebugEvent response;
    private int serialId = 0;
    private long timestamp;
    private final String sourceGuid = SRC_GUID;
    private HashMap<String, Object> attributes = null;

    protected AgentDebugEventBase(String type, Object eventObject) {
        this.eventObject = eventObject;
        this.eventType = type;
        this.serialId = ++SERIAL_ID;
        this.timestamp = ClockUtils.getCurrentTime();
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public Object getEventObject() {
        return this.eventObject;
    }

    @Override
    public void setEventObject(Object eventObject) {
        this.eventObject = eventObject;
    }

    @Override
    public boolean isSync() {
        return false;
    }

    @Override
    public long getSyncWaitTimeMillis() {
        return 0L;
    }

    @Override
    public void setResponse(AgentDebugEvent response) {
        this.response = response;
        AgentDebugEventBaseHelper.notifyAll(this);
    }

    @Override
    public AgentDebugEvent getResponse() {
        return this.response;
    }

    @Override
    public String getTierName() {
        return this.tierName;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getTierId() {
        return this.tierId;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public void setTierName(String tierName) {
        this.tierName = tierName;
    }

    @Override
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public void setTierId(String tierId) {
        this.tierId = tierId;
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public int getSerialId() {
        return this.serialId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes != null ? this.attributes.get(key) : null;
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, o);
    }

    @Override
    public String getSourceGuid() {
        return this.sourceGuid;
    }

    public String toString() {
        return "AgentDebugEventBase{eventType='" + this.eventType + '\'' + ", eventObject=" + this.eventObject + ", tierName='" + this.tierName + '\'' + ", appName='" + this.appName + '\'' + ", nodeName='" + this.nodeName + '\'' + ", tierId='" + this.tierId + '\'' + ", appId='" + this.appId + '\'' + ", nodeId='" + this.nodeId + '\'' + ", response=" + this.response + ", serialId=" + this.serialId + ", timestamp=" + this.timestamp + ", sourceGuid='" + this.sourceGuid + '\'' + ", attributes=" + this.attributes + '}';
    }
}

