/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.crashdetect;

import com.singularity.ee.agent.crashdetect.DetectedJVM;
import com.singularity.ee.agent.resolver.AgentRegistrationInfo;
import com.singularity.ee.agent.util.StringEncoder;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.serialize.LookAheadObjectInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class JVMProcessPersistenceFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FILE_NAME = "processPersistenceFile.ser";
    private final long pid;
    private final long nodeID;
    private final String nodeDirectory;
    private final String appName;
    private final String tierName;
    private final String nodeName;
    private final String homeDirectory;
    private final String machineId;
    private final String controllerHost;
    private final String accountKey;
    private final String versionDirectory;
    private final String uniqueHostId;
    private final int controllerPort;
    private final String[] javaCommandLineOptions;
    private final Map<String, String> environmentVars;
    private final long timeCreated;
    private transient ILogger logger;

    public JVMProcessPersistenceFile(long pid, String nodeDirectory, String appName, String tierName, String nodeName, String homeDirectory, String machineId, String uniqueHostId, long nodeID, String controllerHost, int controllerPort, String accountKey, String[] javaCommandLineOptions, Map<String, String> environmentVars, String versionDirectory, ILogger logger) {
        this.pid = pid;
        this.nodeDirectory = nodeDirectory;
        this.appName = appName;
        this.tierName = tierName;
        this.nodeName = nodeName;
        this.homeDirectory = homeDirectory;
        this.machineId = machineId;
        this.uniqueHostId = uniqueHostId;
        this.nodeID = nodeID;
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.accountKey = accountKey;
        this.javaCommandLineOptions = javaCommandLineOptions;
        this.environmentVars = new HashMap<String, String>(environmentVars);
        this.versionDirectory = versionDirectory;
        this.timeCreated = System.currentTimeMillis();
        this.logger = logger;
    }

    public long getPid() {
        return this.pid;
    }

    public void delete() {
        File persistenceFile = JVMProcessPersistenceFile.getFile(this.nodeDirectory, this.nodeName);
        if (persistenceFile.exists() && !persistenceFile.delete()) {
            this.logger.warn("Unable to delete JVM process persistence file " + persistenceFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        File persistenceFile = JVMProcessPersistenceFile.getFile(this.nodeDirectory, this.nodeName);
        try {
            File directory = persistenceFile.getParentFile();
            if (!directory.exists() && !directory.mkdirs()) {
                this.logger.warn("Unable to create directory " + directory.getAbsolutePath() + ".  Cannot write JVM process persistence file");
                return;
            }
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(persistenceFile));
            try {
                oos.writeObject(this);
            }
            finally {
                oos.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Unable to write JVM process persistence file " + persistenceFile.getAbsolutePath(), (Throwable)e);
            this.delete();
        }
    }

    public DetectedJVM createDetectedJVM(StringEncoder stringEncoder) {
        AgentRegistrationInfo regInfo = new AgentRegistrationInfo(this.appName, this.tierName, this.nodeName, false);
        DetectedJVM returnObject = new DetectedJVM(this.pid, this.nodeDirectory, this.homeDirectory, this.javaCommandLineOptions, this.environmentVars, regInfo, this.timeCreated, stringEncoder, this.logger);
        returnObject.setProcessPersistenceFile(this);
        return returnObject;
    }

    public static JVMProcessPersistenceFile read(String nodeDirectory, String nodeName, ILogger logger) {
        JVMProcessPersistenceFile returnObject = null;
        File persistenceFile = JVMProcessPersistenceFile.getFile(nodeDirectory, nodeName);
        if (persistenceFile != null && persistenceFile.exists() && !persistenceFile.isDirectory()) {
            returnObject = JVMProcessPersistenceFile.read(persistenceFile, logger);
        }
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JVMProcessPersistenceFile read(File persistenceFile, ILogger logger) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader serviceClassLoader = JVMProcessPersistenceFile.class.getClassLoader();
        logger.debug("Setting AgentClassLoader as Context ClassLoader");
        Thread.currentThread().setContextClassLoader(serviceClassLoader);
        JVMProcessPersistenceFile returnObject = null;
        try {
            LookAheadObjectInputStream iis = new LookAheadObjectInputStream((InputStream)new FileInputStream(persistenceFile));
            try {
                returnObject = (JVMProcessPersistenceFile)iis.readObject();
                returnObject.logger = logger;
            }
            finally {
                iis.close();
            }
        }
        catch (Exception e) {
            logger.error(e.toString(), (Throwable)e);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Restoring Context ClassLoader to " + originalClassLoader);
            }
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return returnObject;
    }

    private static File getFile(String nodeDirectory, String nodeName) {
        File returnFile = new File(JVMProcessPersistenceFile.createDirectory(nodeDirectory, nodeName), FILE_NAME);
        return returnFile;
    }

    private static File createDirectory(String nodeDirectory, String nodeName) {
        File dir = new File(new File(nodeDirectory), "conf" + File.separator + nodeName);
        return dir;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public String getUniqueHostId() {
        return this.uniqueHostId;
    }

    public long getNodeID() {
        return this.nodeID;
    }

    public Map<String, String> getEnvironmentVars() {
        return this.environmentVars;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public String getControllerHost() {
        return this.controllerHost;
    }

    public int getControllerPort() {
        return this.controllerPort;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public String getTierName() {
        return this.tierName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getVersionDirectory() {
        return this.versionDirectory;
    }

    public static JVMProcessPersistenceFile locateProcessPersistenceFileForPid(long pid, String directory, ILogger logger) {
        JVMProcessPersistenceFile returnObject;
        block3: {
            returnObject = null;
            try {
                File[] subDirectories;
                File directoryFile = new File(directory);
                if (!directoryFile.isDirectory() || (subDirectories = directoryFile.listFiles()) == null) break block3;
                for (File nextSubDirectory : subDirectories) {
                    JVMProcessPersistenceFile nextFile;
                    File processPersistenceFile;
                    if (!nextSubDirectory.isDirectory() || !(processPersistenceFile = new File(nextSubDirectory, FILE_NAME)).exists() || (nextFile = JVMProcessPersistenceFile.read(processPersistenceFile, logger)) == null || nextFile.pid != pid) continue;
                    returnObject = nextFile;
                    break;
                }
            }
            catch (Exception e) {
                logger.error(String.format("Caught %s attempting to locate process persistence file in %s", e, directory), (Throwable)e);
            }
        }
        return returnObject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<pid = ").append(Long.toString(this.pid));
        sb.append("    nodeDirectory = ").append(this.nodeDirectory);
        sb.append("    appName = ").append(this.appName);
        sb.append("    tierName = ").append(this.tierName);
        sb.append("    nodeName = ").append(this.nodeName);
        sb.append("    homeDirectory = ").append(this.homeDirectory);
        sb.append("    machineId = ").append(this.machineId);
        sb.append("    uniqueHostId = ").append(this.uniqueHostId != null ? this.uniqueHostId : "null");
        sb.append("    controllerHost = ").append(this.controllerHost);
        sb.append("    controllerPort = ").append(Integer.toString(this.controllerPort));
        sb.append("    accountKey = ").append(this.accountKey);
        sb.append("    versionDirectory = ").append(this.versionDirectory).append(">");
        return sb.toString();
    }
}

