/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.crashdetect;

import com.singularity.ee.agent.crashdetect.ACrashAnalyzerImpl;
import com.singularity.ee.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JRockitCrashAnalyzer
extends ACrashAnalyzerImpl {
    private static final String ERROR_MESSAGE_PREFIX = "Error Message: ";
    private static final String SIGNAL_INFO_PREFIX = "Signal info  :";
    private static final String DATE_TIME_REGEX = "JRockit dump produced after \\d+ days, \\d\\d:\\d\\d:\\d\\d on [A-Z][a-z][a-z] [A-Z][a-z][a-z] [ \\d]\\d \\d\\d:\\d\\d:\\d\\d \\d\\d\\d\\d";

    JRockitCrashAnalyzer(File hotspotErrorFile, ILogger logger) {
        super(hotspotErrorFile, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readAndAnalyzeCrashFile() {
        if (!this.crashFileRead) {
            this.crashReason = "Unknown";
            StringBuilder sbCrashReason = null;
            BufferedReader reader = null;
            try {
                String nextLineRead;
                reader = this.getReader();
                while ((nextLineRead = reader.readLine()) != null) {
                    int indexOfOn;
                    if ((nextLineRead = nextLineRead.trim()).startsWith(ERROR_MESSAGE_PREFIX)) {
                        sbCrashReason = new StringBuilder(nextLineRead);
                        continue;
                    }
                    if (nextLineRead.startsWith(SIGNAL_INFO_PREFIX)) {
                        sbCrashReason.append("\n").append(nextLineRead);
                        break;
                    }
                    if (!nextLineRead.matches(DATE_TIME_REGEX) || (indexOfOn = nextLineRead.indexOf(" on ")) <= 0) continue;
                    nextLineRead = nextLineRead.substring(indexOfOn + 4).trim();
                    try {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
                        Date parsedDateAndTime = dateFormat.parse(nextLineRead);
                        this.crashDateTime = parsedDateAndTime.getTime();
                    }
                    catch (ParseException e) {
                        if (this.logger == null) continue;
                        this.logger.warn(String.format("%s caught trying to parse date/time %s from crash log", e, nextLineRead), (Throwable)e);
                    }
                }
                if (sbCrashReason != null) {
                    this.crashReason = sbCrashReason.toString();
                }
            }
            catch (Throwable t) {
                if (this.logger != null) {
                    this.logger.error(t.toString(), t);
                }
            }
            finally {
                block21: {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable t) {
                            if (this.logger == null) break block21;
                            this.logger.error(t.toString(), t);
                        }
                    }
                }
            }
            this.crashFileRead = true;
        }
    }

    @Override
    public boolean matchesPID(long pid) {
        return true;
    }
}

