/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.crashdetect;

import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.w3c.dom.NodeList;
import com.singularity.ee.agent.crashdetect.HotspotCrashAnalyzer;
import com.singularity.ee.agent.crashdetect.IBMCrashAnalyzer;
import com.singularity.ee.agent.crashdetect.ICrashAnalyzer;
import com.singularity.ee.agent.crashdetect.ICrashDetectEventHelper;
import com.singularity.ee.agent.crashdetect.JRockitCrashAnalyzer;
import com.singularity.ee.agent.crashdetect.JVMProcessPersistenceFile;
import com.singularity.ee.agent.crashdetect.JvmCrashData;
import com.singularity.ee.agent.crashdetect.UnableToUploadFilesException;
import com.singularity.ee.agent.resolver.AgentRegistrationInfo;
import com.singularity.ee.agent.util.StringEncoder;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.rest.controller.request.FileUploadRequest;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DetectedJVM {
    private final StringEncoder stringEncoder;
    private static final String HOTSPOT_ERROR_FILE_ARGUMENT = "-XX:ErrorFile=";
    private static final String[][] ERROR_FILE_ARGUMENT_SUBSTITUTION = new String[][]{{"%%", "\t\t"}, {"%p", "PID"}, {"\\t\\t", "%"}};
    private static final int[] PID_INDEX_IN_ARG_SUBSTITUTION = new int[]{1, 1};
    private static String[][] URL_QUERY_STRING_REPLACE_STRINGS = new String[][]{{"%", "%25"}, {" ", "%20"}, {"\"", "%22"}, {"\\", "%5C"}, {":", "%3A"}, {"/", "%2F"}, {"<", "%3C"}, {">", "%3E"}, {"#", "%23"}, {"{", "%7B"}, {"}", "%7D"}, {"|", "%7C"}, {"^", "%5E"}, {"~", "%7E"}, {"[", "%5B"}, {"]", "%5D"}, {"`", "%60"}, {";", "%3B"}, {"?", "%3F"}, {"@", "%40"}, {"=", "%3D"}, {"&", "%26"}, {"$", "%24"}, {"+", "%2B"}};
    private final String INET_ADDRESS_REGEX = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    private static final String IBM_JAVA_DUMP_FILE_REGEX_FORMAT_STRING_WINDOWS_LINUX = "javacore\\.[\\d]+\\.[\\d]+\\.%d.*\\.txt";
    private static final String IBM_JAVACORE_DIR_ENV_VAR = "IBM_JAVACOREDIR";
    private static final String IBM_WORKING_DIR_PROP = "-DWORKING_DIR=";
    private static final String IBM_JAVA_DUMP_FILE_REGEX_FORMAT_STRING_AIX = "javacore%d\\.[\\d]+\\.txt";
    private static final String[] IBM_JAVA_DUMP_FILE_REGEX_FORMAT_STRINGS = new String[]{"javacore\\.[\\d]+\\.[\\d]+\\.%d.*\\.txt", "javacore%d\\.[\\d]+\\.txt"};
    private static final long DEFAULT_MAX_TIME_TO_LOCATE_CRASH_LOG = 5000L;
    private static final String MAX_TIME_TO_LOCATE_CRASH_LOG_PROP = "appdynamics.crashdetect.max.search.time";
    private static final String PAUSE_BEFORE_SEARCHING_PROP = "appdynamics.crashdetect.pause.before.searching";
    private static ProcessBuilder processBuilder;
    private static ThreadGroup startedProcessThreadGroup;
    private static List<String> processBuilderCommandLineArgs;
    private final long pid;
    private String homeDirectory;
    private final String nodeDirectory;
    private String appName;
    private String tierName;
    private String nodeName;
    private String hashedAccountKeyFromFile;
    private final String[] javaCommandLineOptions;
    private Map<String, String> environmentVars;
    final ILogger logger;
    private JVMProcessPersistenceFile processPersistenceFile;
    static long maxTimeToSearchForCrashLogs;
    static long pauseBeforeSearchingTime;
    static final AgentAtomicIntegerImpl numberOfDeferredUploadRequests;
    private static final int MAX_DEFERRED_UPLOAD_REQUESTS = 5;
    private static final int MAX_UPLOAD_ATTEMPTS = 60;
    private IAgentScheduledFuture future;
    private volatile int numUploadAttempts;
    private final long timeDetected;

    private static long getMaxTimeToSearchForCrashLogs() {
        int maxSearchTimeOverride;
        long returnValue = 5000L;
        String strProp = System.getProperty(MAX_TIME_TO_LOCATE_CRASH_LOG_PROP);
        if (strProp != null && (maxSearchTimeOverride = StringOperations.safeParseInteger((String)strProp, (int)-1)) >= 0) {
            returnValue = (long)maxSearchTimeOverride * 1000L;
        }
        return returnValue;
    }

    private static long getPauseBeforeSearchingTime() {
        int pauseBeforeSearchingTime;
        long returnValue = 0L;
        String strProp = System.getProperty(PAUSE_BEFORE_SEARCHING_PROP);
        if (strProp != null && (pauseBeforeSearchingTime = StringOperations.safeParseInteger((String)strProp, (int)0)) >= 0) {
            returnValue = (long)pauseBeforeSearchingTime * 1000L;
        }
        return returnValue;
    }

    public DetectedJVM(long pid, String nodeDirectory, String homeDirectory, String[] javaCommandLineOptions, Map<String, String> environmentVars, AgentRegistrationInfo agentRegistrationInfo, long timeDetected, StringEncoder stringEncoder, ILogger logger) {
        this.pid = pid;
        this.nodeDirectory = nodeDirectory;
        this.homeDirectory = homeDirectory;
        this.javaCommandLineOptions = javaCommandLineOptions;
        this.environmentVars = environmentVars;
        this.logger = logger;
        this.timeDetected = timeDetected;
        this.stringEncoder = stringEncoder;
        if (agentRegistrationInfo != null) {
            this.appName = agentRegistrationInfo.getApplicationName();
            this.tierName = agentRegistrationInfo.getApplicationComponentName();
            this.nodeName = agentRegistrationInfo.getApplicationComponentNodeName();
        }
    }

    public boolean noLongerActive(ICrashDetectEventHelper eventGenerator) {
        boolean bReturn = false;
        this.logger.info(String.format("Detected that JVM for PID %d is no longer active", this.pid));
        JvmCrashData collectedData = this.collectCrashData(eventGenerator.getControllerHost(), eventGenerator.getAccountKey(), eventGenerator.getUniqueHostID());
        if (collectedData != null && !collectedData.getFilesToUpload().isEmpty()) {
            Map<String, String> uploadedFiles = null;
            boolean okToSendError = true;
            if (collectedData.getCrashAnalyzer() != null) {
                try {
                    uploadedFiles = this.uploadFilesAndAddToEventDetails(collectedData.getFilesToUpload(), collectedData.getEventDetailsMap(), eventGenerator);
                }
                catch (UnableToUploadFilesException e) {
                    this.scheduleFutureFileUpload(eventGenerator, collectedData.getFilesToUpload(), collectedData.getEventDetailsMap(), collectedData.getMachineId(), collectedData.getNodeId());
                    okToSendError = false;
                }
            }
            if (okToSendError) {
                this.sendError(eventGenerator, collectedData.getEventDetailsMap(), uploadedFiles, collectedData.getMachineId(), collectedData.getNodeId());
                this.logger.info("JVM Crash event was sent to controller");
            }
            bReturn = true;
        }
        return bReturn;
    }

    public JvmCrashData getJVMCrashData(String curControllerHost, String curAccountKey, String curUniqueHostId) {
        this.logger.info(String.format("Detected that JVM for PID %d is no longer active", this.pid));
        JvmCrashData collectedData = this.collectCrashData(curControllerHost, curAccountKey, curUniqueHostId);
        if (collectedData != null && !collectedData.getFilesToUpload().isEmpty()) {
            return collectedData;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JvmCrashData collectCrashData(String curControllerHost, String curAccountKey, String curUniqueHostId) {
        long crashTimeStamp;
        JvmCrashData crashData = null;
        long nodeId = 0L;
        String machineId = null;
        if (this.nodeDirectory != null && this.nodeName != null) {
            if (this.processPersistenceFile == null) {
                this.processPersistenceFile = JVMProcessPersistenceFile.read(this.nodeDirectory, this.nodeName, this.logger);
            }
            if (this.processPersistenceFile != null) {
                String homeDirectoryFromPPF;
                if (this.processPersistenceFile.getPid() != this.pid) {
                    this.logger.info(String.format("JVM Process Persistence file %s does not match PID and/or machine id - ignored", this.processPersistenceFile));
                    return crashData;
                }
                if (this.environmentVars == null) {
                    this.environmentVars = this.processPersistenceFile.getEnvironmentVars();
                }
                if ((homeDirectoryFromPPF = this.processPersistenceFile.getHomeDirectory()) != null && !homeDirectoryFromPPF.equals(this.homeDirectory)) {
                    this.logger.info(String.format("Home directory %s from ProcessPersistenceFile for pid %d is used instead of original value %s", homeDirectoryFromPPF, this.pid, this.homeDirectory != null ? this.homeDirectory : "null"));
                    this.homeDirectory = homeDirectoryFromPPF;
                }
                String controllerHost = this.processPersistenceFile.getControllerHost();
                this.hashedAccountKeyFromFile = this.processPersistenceFile.getAccountKey();
                String currentAccountKeyHash = null;
                try {
                    currentAccountKeyHash = this.stringEncoder.calculateSha1(curAccountKey);
                }
                catch (NoSuchAlgorithmException e) {
                    this.logger.warn("Account access key cannot be hashed");
                }
                if ((controllerHost == null || this.normalizeHost(controllerHost).equals(this.normalizeHost(curControllerHost))) && (this.hashedAccountKeyFromFile == null || this.hashedAccountKeyFromFile.equals(currentAccountKeyHash))) {
                    String uniqueHostIdFromPPF = this.processPersistenceFile.getUniqueHostId();
                    String currentUniqueHostId = curUniqueHostId;
                    if (uniqueHostIdFromPPF != null && currentUniqueHostId != null && !uniqueHostIdFromPPF.equals(currentUniqueHostId)) {
                        this.logger.info(String.format("JVM Process Persistence file %s is ignored, because unique host id does not match current unique host id %s", this.processPersistenceFile, currentUniqueHostId));
                        return crashData;
                    }
                    nodeId = this.processPersistenceFile.getNodeID();
                    machineId = this.processPersistenceFile.getMachineId();
                    this.appName = this.processPersistenceFile.getAppName();
                    this.tierName = this.processPersistenceFile.getTierName();
                    this.nodeName = this.processPersistenceFile.getNodeName();
                    this.processPersistenceFile.delete();
                    this.logger.info(String.format("JVM Process Persistence file %s has been deleted", this.processPersistenceFile));
                } else {
                    this.logger.info(String.format("JVM Process Persistence file %s does not match current controller or account - ignored", this.processPersistenceFile));
                    return crashData;
                }
            }
        }
        ICrashAnalyzer crashAnalyzer = null;
        HashMap<String, String> eventDetails = new HashMap<String, String>();
        ArrayList<File> listOfFilesToUpload = new ArrayList<File>();
        File hotspotErrorFile = this.getHotspotErrorFile();
        if (hotspotErrorFile != null) {
            this.logger.info(String.format("Hotspot error log file %s was found", hotspotErrorFile));
            if (this.wasFileCreatedAfterProcessDiscovery(hotspotErrorFile)) {
                crashAnalyzer = this.getHotspotCrashAnalyzer(hotspotErrorFile);
                if (!crashAnalyzer.matchesPID(this.pid)) {
                    this.logger.info(String.format("Hotspot error log file %s does not match pid %d - ignored", hotspotErrorFile, this.pid));
                } else {
                    listOfFilesToUpload.add(hotspotErrorFile);
                }
            }
        }
        if (listOfFilesToUpload.isEmpty()) {
            File jRockitCrashFile;
            File ibmDumpFile = this.getIBMJavaCoreFile();
            if (ibmDumpFile != null) {
                this.logger.info(String.format("IBM error log file %s was found", ibmDumpFile));
                if (this.wasFileCreatedAfterProcessDiscovery(ibmDumpFile)) {
                    crashAnalyzer = this.getIbmCrashAnalyzer(ibmDumpFile);
                    if (!crashAnalyzer.matchesPID(this.pid)) {
                        this.logger.info(String.format("IBM error log file %s does not match pid %d - ignored", ibmDumpFile, this.pid));
                    } else {
                        listOfFilesToUpload.add(ibmDumpFile);
                    }
                }
            }
            if (listOfFilesToUpload.isEmpty() && (jRockitCrashFile = this.getJRockitCrashFile()) != null) {
                this.logger.info(String.format("JRockit error log file %s was found", jRockitCrashFile));
                if (this.wasFileCreatedAfterProcessDiscovery(jRockitCrashFile)) {
                    crashAnalyzer = this.getjRockitCrashAnalyzer(jRockitCrashFile);
                    if (!crashAnalyzer.matchesPID(this.pid)) {
                        this.logger.info(String.format("IBM error log file %s does not match pid %d - ignored", jRockitCrashFile, this.pid));
                    } else {
                        listOfFilesToUpload.add(jRockitCrashFile);
                    }
                }
            }
        }
        if (listOfFilesToUpload.isEmpty()) return new JvmCrashData(nodeId, machineId, eventDetails, crashAnalyzer, listOfFilesToUpload);
        if (crashAnalyzer == null) return new JvmCrashData(nodeId, machineId, eventDetails, crashAnalyzer, listOfFilesToUpload);
        String crashReason = crashAnalyzer.getCrashReason();
        if (crashReason != null) {
            eventDetails.put("Crash Reason", crashReason);
        }
        if ((crashTimeStamp = crashAnalyzer.getCrashTimestamp()) > 0L) {
            eventDetails.put("Crash Date/Time", new Date(crashTimeStamp).toString());
        }
        eventDetails.put("PID", Long.toString(this.pid));
        if (this.appName != null) {
            eventDetails.put("appName", this.appName);
        }
        if (this.tierName != null) {
            eventDetails.put("tierName", this.tierName);
        }
        if (this.nodeName != null) {
            eventDetails.put("nodeName", this.nodeName);
        }
        eventDetails.put("Command line", this.createStringFromJVMArgs());
        try {
            eventDetails.put("IP Address", InetAddress.getLocalHost().getHostAddress());
            eventDetails.put("Host name", SystemUtils.getLocalHostName());
            return new JvmCrashData(nodeId, machineId, eventDetails, crashAnalyzer, listOfFilesToUpload);
        }
        catch (UnknownHostException e) {
            this.logger.warn("Unable to resolve IP Address and/or Host name because of " + e.toString(), (Throwable)e);
        }
        return new JvmCrashData(nodeId, machineId, eventDetails, crashAnalyzer, listOfFilesToUpload);
    }

    protected ICrashAnalyzer getjRockitCrashAnalyzer(File jRockitCrashFile) {
        return new JRockitCrashAnalyzer(jRockitCrashFile, this.logger);
    }

    protected ICrashAnalyzer getIbmCrashAnalyzer(File ibmDumpFile) {
        return new IBMCrashAnalyzer(ibmDumpFile, this.logger);
    }

    protected ICrashAnalyzer getHotspotCrashAnalyzer(File hotspotErrorFile) {
        return new HotspotCrashAnalyzer(hotspotErrorFile, this.logger);
    }

    private void sendError(ICrashDetectEventHelper helper, Map<String, String> eventDetails, Map<String, String> uploadedFiles, String machineId, long nodeID) {
        helper.sendError(this, eventDetails, uploadedFiles, machineId, nodeID);
        this.logger.info("JVM Crash event is queued for the controller");
    }

    private Map<String, String> uploadFilesAndAddToEventDetails(List<File> listOfFilesToUpload, Map<String, String> eventDetails, ICrashDetectEventHelper helper) throws UnableToUploadFilesException {
        Map<String, String> uploadedFiles = this.uploadFilesToController(listOfFilesToUpload, helper);
        int fileIndex = 0;
        for (String nextFile : uploadedFiles.keySet()) {
            eventDetails.put("File_" + Integer.toString(fileIndex++), nextFile);
        }
        return uploadedFiles;
    }

    private void scheduleFutureFileUpload(final ICrashDetectEventHelper helper, final List<File> listOfFilesToUpload, final Map<String, String> eventDetails, final String machineId, final long nodeID) {
        if (numberOfDeferredUploadRequests.incrementAndGet() > 5) {
            numberOfDeferredUploadRequests.decrementAndGet();
            this.logger.warn(String.format("Unable to schedule deferred file upload for crashed JVM with pid %d because maximum deferred requests is reached", this.pid));
        } else {
            IAgentScheduledExecutorService scheduler = helper.getScheduler();
            if (scheduler != null) {
                this.numUploadAttempts = 1;
                this.future = scheduler.scheduleAtFixedRate(new IAgentRunnable(){

                    public void run() {
                        DetectedJVM.this.uploadFilesAndSendErrorInBackground(helper, listOfFilesToUpload, eventDetails, machineId, nodeID);
                    }
                }, 60L, 60L, AgentTimeUnit.SECONDS);
            } else {
                numberOfDeferredUploadRequests.decrementAndGet();
                this.logger.warn(String.format("Unable to schedule deferred file upload for crashed JVM with pid %d because no scheduler is available", this.pid));
            }
        }
    }

    void uploadFilesAndSendErrorInBackground(ICrashDetectEventHelper helper, List<File> listOfFilesToUpload, Map<String, String> eventDetails, String machineId, long nodeID) {
        Map<String, String> uploadedFileMap;
        boolean sendEvent;
        block5: {
            sendEvent = true;
            uploadedFileMap = null;
            this.trimNonExistentFiles(listOfFilesToUpload);
            if (listOfFilesToUpload.size() > 0) {
                try {
                    uploadedFileMap = this.uploadFilesAndAddToEventDetails(listOfFilesToUpload, eventDetails, helper);
                }
                catch (UnableToUploadFilesException e) {
                    if (++this.numUploadAttempts >= 60) {
                        this.logger.warn(String.format("Maximum number of file upload attempts reached for crashed JVM pid %d", this.pid));
                    }
                    sendEvent = false;
                    if (!this.logger.isDebugEnabled()) break block5;
                    this.logger.debug(String.format("Still unable to upload files to controller for crashed JVM pid %d", this.pid), (Throwable)e);
                }
            }
        }
        if (sendEvent) {
            this.sendError(helper, eventDetails, uploadedFileMap, machineId, nodeID);
            this.future.cancel(false);
            this.future = null;
            numberOfDeferredUploadRequests.decrementAndGet();
        }
    }

    private void trimNonExistentFiles(List<File> listOfFiles) {
        Iterator<File> fileIter = listOfFiles.iterator();
        while (fileIter.hasNext()) {
            File file = fileIter.next();
            if (file.exists()) continue;
            this.logger.warn(String.format("File %s no longer exists - cannot be uploaded", file));
            fileIter.remove();
        }
    }

    private File getHotspotErrorFile() {
        File returnFile = null;
        String errorFileArgument = this.getHotspotErrorFileArgument();
        if (errorFileArgument != null && (returnFile = this.getFileFromErrorFileArgument(errorFileArgument)) != null && (!returnFile.exists() || returnFile.isDirectory())) {
            returnFile = null;
        }
        if (returnFile == null) {
            returnFile = this.getDefaultHotspotErrorLog();
        }
        if (returnFile != null && !returnFile.exists()) {
            returnFile = null;
        }
        return returnFile;
    }

    private String getHotspotErrorFileArgument() {
        String returnString = null;
        if (this.javaCommandLineOptions != null) {
            for (String nextArg : this.javaCommandLineOptions) {
                if (!(nextArg = nextArg.trim()).startsWith(HOTSPOT_ERROR_FILE_ARGUMENT)) continue;
                returnString = nextArg.substring(HOTSPOT_ERROR_FILE_ARGUMENT.length());
                break;
            }
        }
        return returnString;
    }

    private File getFileFromErrorFileArgument(String errorFileArg) {
        String[][] argSubstitutionArray = new String[ERROR_FILE_ARGUMENT_SUBSTITUTION.length][ERROR_FILE_ARGUMENT_SUBSTITUTION[0].length];
        System.arraycopy(ERROR_FILE_ARGUMENT_SUBSTITUTION, 0, argSubstitutionArray, 0, ERROR_FILE_ARGUMENT_SUBSTITUTION.length);
        argSubstitutionArray[DetectedJVM.PID_INDEX_IN_ARG_SUBSTITUTION[0]][DetectedJVM.PID_INDEX_IN_ARG_SUBSTITUTION[1]] = Long.toString(this.pid);
        for (String[] subStrings : argSubstitutionArray) {
            errorFileArg = errorFileArg.replaceAll(subStrings[0], subStrings[1]);
        }
        File returnFile = new File(errorFileArg);
        return returnFile;
    }

    private File getDefaultHotspotErrorLog() {
        Object tempDir;
        File returnFile = null;
        String simpleFileName = String.format("hs_err_pid%d.log", this.pid);
        if (this.homeDirectory != null) {
            returnFile = this.searchForFileInDirectory(new File(this.homeDirectory), simpleFileName);
        }
        if (returnFile == null && (tempDir = this.getTempDirectory()) != null) {
            returnFile = this.searchForFileInDirectory((File)tempDir, simpleFileName);
        }
        if (returnFile == null && (tempDir = System.getProperty("java.io.tmpdir")) != null) {
            returnFile = this.searchForFileInDirectory(new File((String)tempDir), simpleFileName);
        }
        return returnFile;
    }

    private File getIBMJavaCoreFile() {
        String javaCoreDir;
        File returnFile = null;
        String[] ibmDumpRegexStrings = new String[IBM_JAVA_DUMP_FILE_REGEX_FORMAT_STRINGS.length];
        for (int i = 0; i < ibmDumpRegexStrings.length; ++i) {
            ibmDumpRegexStrings[i] = String.format(IBM_JAVA_DUMP_FILE_REGEX_FORMAT_STRINGS[i], this.pid);
        }
        String string = javaCoreDir = this.environmentVars != null ? this.environmentVars.get(IBM_JAVACORE_DIR_ENV_VAR) : null;
        if (javaCoreDir != null) {
            returnFile = this.searchForIBMJavaCoreFiles(new File(javaCoreDir), ibmDumpRegexStrings);
        } else {
            javaCoreDir = this.getIBMWorkingDirProp();
            if (javaCoreDir != null) {
                returnFile = this.searchForIBMJavaCoreFiles(new File(javaCoreDir), ibmDumpRegexStrings);
            } else if (this.homeDirectory != null) {
                returnFile = this.searchForIBMJavaCoreFiles(new File(this.homeDirectory), ibmDumpRegexStrings);
            }
        }
        return returnFile;
    }

    private String getIBMWorkingDirProp() {
        String returnString = null;
        if (this.javaCommandLineOptions != null) {
            for (String nextOption : this.javaCommandLineOptions) {
                if (!nextOption.startsWith(IBM_WORKING_DIR_PROP)) continue;
                returnString = nextOption.substring(IBM_WORKING_DIR_PROP.length());
                break;
            }
        }
        return returnString;
    }

    private File searchForIBMJavaCoreFiles(File directoryToSearch, String[] ibmDumpRegexStrings) {
        Object[] matchingFiles;
        Object returnFile = null;
        if (directoryToSearch != null && directoryToSearch.isDirectory() && (matchingFiles = this.searchForFilePatternInDirectory(directoryToSearch, ibmDumpRegexStrings)) != null && matchingFiles.length > 0) {
            if (matchingFiles != null && matchingFiles.length == 1) {
                returnFile = matchingFiles[0];
            } else {
                Arrays.sort(matchingFiles);
                returnFile = matchingFiles[matchingFiles.length - 1];
            }
        }
        return returnFile;
    }

    private File getJRockitCrashFile() {
        File returnFile = null;
        String crashFileName = String.format("jrockit.%d.dump", this.pid);
        String crashDir = this.getJRockitCrashDirectory();
        if (crashDir != null && !(returnFile = new File(new File(crashDir), crashFileName)).exists()) {
            returnFile = null;
        }
        if (returnFile == null && this.homeDirectory != null && !(returnFile = new File(new File(this.homeDirectory), crashFileName)).exists()) {
            returnFile = null;
        }
        return returnFile;
    }

    private String getJRockitCrashDirectory() {
        String returnString = this.environmentVars != null ? this.environmentVars.get("JROCKIT_DUMP_PATH") : null;
        return returnString;
    }

    protected File searchForFileInDirectory(File directory, String simpleFileName) {
        File returnFile = null;
        FileSearcher fileSearcher = new FileSearcher(directory, simpleFileName);
        fileSearcher.start();
        try {
            if (maxTimeToSearchForCrashLogs > 0L) {
                fileSearcher.join(maxTimeToSearchForCrashLogs);
            } else {
                fileSearcher.join();
            }
            if (fileSearcher.isAlive()) {
                fileSearcher.stop();
            } else {
                File[] files = fileSearcher.getFiles();
                if (files != null && files.length == 1) {
                    returnFile = files[0];
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
        return returnFile;
    }

    private File[] searchForFilePatternInDirectory(File directory, String[] fileRegexStrings) {
        File[] files = null;
        FileSearcher fileSearcher = new FileSearcher(directory, fileRegexStrings);
        fileSearcher.start();
        try {
            if (maxTimeToSearchForCrashLogs > 0L) {
                fileSearcher.join(maxTimeToSearchForCrashLogs);
            } else {
                fileSearcher.join();
            }
            if (fileSearcher.isAlive()) {
                fileSearcher.stop();
            } else {
                files = fileSearcher.getFiles();
            }
        }
        catch (InterruptedException e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
        return files;
    }

    private File getTempDirectory() {
        File returnFile = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (this.environmentVars != null) {
                String tempDirName = this.environmentVars.get("TMP");
                if (tempDirName == null) {
                    tempDirName = this.environmentVars.get("TEMP");
                }
                if (tempDirName != null) {
                    returnFile = new File(tempDirName);
                }
            }
        } else {
            returnFile = new File("/tmp");
        }
        if (!(returnFile == null || returnFile.exists() && returnFile.isDirectory())) {
            returnFile = null;
        }
        return returnFile;
    }

    private Map<String, String> uploadFilesToController(List<File> filesToUpload, ICrashDetectEventHelper crashEventGenerator) throws UnableToUploadFilesException {
        Map<String, String> returnMap;
        ArrayList<NameValuePair> listOfNVPairs = new ArrayList<NameValuePair>();
        listOfNVPairs.add(new NameValuePair("action", "jvmcrashupload"));
        listOfNVPairs.add(new NameValuePair("jvmcrashappname", DetectedJVM.editQueryStringParm(this.appName != null ? this.appName : "unknown")));
        listOfNVPairs.add(new NameValuePair("jvmcrashtiername", DetectedJVM.editQueryStringParm(this.tierName != null ? this.tierName : "unknown")));
        listOfNVPairs.add(new NameValuePair("jvmcrashnodename", DetectedJVM.editQueryStringParm(this.nodeName != null ? this.nodeName : "unknown")));
        listOfNVPairs.add(new NameValuePair("jvmcrashpid", Long.toString(this.pid)));
        if (!StringOperations.isEmpty((String)crashEventGenerator.getAccountKey())) {
            listOfNVPairs.add(new NameValuePair("accountkey", DetectedJVM.editQueryStringParm(crashEventGenerator.getAccountKey())));
        }
        try {
            FileUploadRequest uploadRequest = new FileUploadRequest(crashEventGenerator.getControllerHost(), crashEventGenerator.getControllerPort(), crashEventGenerator.getMachineId(), this.logger, listOfNVPairs);
            for (File file : filesToUpload) {
                uploadRequest.addFile(file);
            }
            HttpExecutionResponse execResponse = uploadRequest.sendRequest();
            if (execResponse.isStatusNotOk() || execResponse.isExceptionHappened()) {
                String message = String.format("Failed to send Java crash files to controller: %s", execResponse.getExceptionMessage());
                this.logger.error(message);
                throw new UnableToUploadFilesException(message, null);
            }
            for (File file : filesToUpload) {
                this.logger.info(String.format("File %s was uploaded to controller", file));
            }
            returnMap = this.createFileUploadMapFromServletResponse(execResponse.getResponseBody());
        }
        catch (UnableToUploadFilesException e) {
            throw e;
        }
        catch (Throwable t) {
            String message = String.format("Failed to send Java crash files to controller: %s", t.toString());
            this.logger.error(message);
            throw new UnableToUploadFilesException(message, t);
        }
        return returnMap;
    }

    private Map<String, String> createFileUploadMapFromServletResponse(String servletResponse) {
        HashMap<String, String> fileUploadMap = new HashMap<String, String>();
        try {
            Document doc = XMLParseUtility.getXmlDocumentFromString((String)servletResponse);
            NodeList nl = doc.getElementsByTagName("crashFileTransfers");
            if (nl != null && nl.getLength() == 1) {
                Node outerNode = nl.item(0);
                String GUID = null;
                if (outerNode instanceof Element) {
                    Element outerElement = (Element)outerNode;
                    GUID = outerElement.getAttribute("guid");
                }
                nl = outerNode.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element innerElement;
                    Node innerNode = nl.item(i);
                    if (!(innerNode instanceof Element) || !(innerElement = (Element)innerNode).getNodeName().equals("crashFile")) continue;
                    String targetFile = (GUID != null ? GUID + File.separator : "") + innerElement.getAttribute("target");
                    String downloadURL = innerElement.getAttribute("url");
                    if (targetFile == null || downloadURL == null) continue;
                    fileUploadMap.put(targetFile, downloadURL);
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Unable to parse response from ServletUpload request: " + t.toString(), t);
        }
        return fileUploadMap;
    }

    private static String editQueryStringParm(String originalString) {
        String returnString = originalString;
        for (String[] substitutionPair : URL_QUERY_STRING_REPLACE_STRINGS) {
            returnString = returnString.replace(substitutionPair[0], substitutionPair[1]);
        }
        return returnString;
    }

    void setProcessPersistenceFile(JVMProcessPersistenceFile processPersistenceFile) {
        this.processPersistenceFile = processPersistenceFile;
    }

    private String createStringFromJVMArgs() {
        StringBuilder sb = new StringBuilder();
        if (this.javaCommandLineOptions != null) {
            for (String nextCommandLineArg : this.javaCommandLineOptions) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(nextCommandLineArg);
            }
        }
        return sb.toString();
    }

    private String normalizeHost(String hostNameOrAddress) {
        String returnString = hostNameOrAddress;
        if (!hostNameOrAddress.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
            try {
                InetAddress address = InetAddress.getByName(hostNameOrAddress);
                returnString = address.getHostAddress();
            }
            catch (UnknownHostException uhe) {
                this.logger.warn(String.format("%s exception caught trying to resolve host name %s", uhe.toString(), hostNameOrAddress));
            }
        }
        return returnString;
    }

    private boolean wasFileCreatedAfterProcessDiscovery(File fileToTest) {
        boolean bReturn = true;
        if (fileToTest.lastModified() < this.timeDetected) {
            this.logger.info(String.format("Error log file %s was created before JVM was detected - ignored", fileToTest));
            bReturn = false;
        }
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart() {
        boolean bReturn = false;
        try {
            ProcessBuilder processBuilder = DetectedJVM.getProcessBuilder();
            ThreadGroup threadGroup = DetectedJVM.getThreadGroupForStartedProcesses();
            ProcessBuilder processBuilder2 = processBuilder;
            synchronized (processBuilder2) {
                List<String> args = processBuilder.command();
                args.clear();
                if (this.javaCommandLineOptions != null) {
                    args.addAll(Arrays.asList(this.javaCommandLineOptions));
                }
                processBuilder.directory(this.homeDirectory != null ? new File(this.homeDirectory) : null);
                Map<String, String> envVars = processBuilder.environment();
                envVars.clear();
                if (this.environmentVars != null) {
                    envVars.putAll(this.environmentVars);
                }
                Process process = processBuilder.start();
                this.createReaderThreadForProcess(process, threadGroup);
                bReturn = true;
            }
        }
        catch (Throwable t) {
            this.logger.error("Unable to restart process because of " + t.toString(), t);
        }
        return bReturn;
    }

    private static synchronized ProcessBuilder getProcessBuilder() {
        if (processBuilder == null) {
            processBuilderCommandLineArgs = new ArrayList<String>();
            processBuilder = new ProcessBuilder(processBuilderCommandLineArgs);
            processBuilder.redirectErrorStream(true);
        }
        return processBuilder;
    }

    private static synchronized ThreadGroup getThreadGroupForStartedProcesses() {
        if (startedProcessThreadGroup == null) {
            startedProcessThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "AD DetectedJVM Started Process ThreadGroup");
        }
        return startedProcessThreadGroup;
    }

    private void createReaderThreadForProcess(final Process process, ThreadGroup threadGroup) {
        Thread t = new Thread(threadGroup, String.format("Read thread for process %s", process)){

            @Override
            public void run() {
                try {
                    String nextLine;
                    InputStream stdOutInputStream = process.getInputStream();
                    BufferedReader bReader = new BufferedReader(new InputStreamReader(stdOutInputStream));
                    while ((nextLine = bReader.readLine()) != null) {
                        if (!DetectedJVM.this.logger.isTraceEnabled()) continue;
                        DetectedJVM.this.logger.trace(nextLine);
                    }
                }
                catch (IOException e) {
                    DetectedJVM.this.logger.error(String.format("%s caught in read thread for process %s", e, process), (Throwable)e);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    static {
        maxTimeToSearchForCrashLogs = DetectedJVM.getMaxTimeToSearchForCrashLogs();
        pauseBeforeSearchingTime = DetectedJVM.getPauseBeforeSearchingTime();
        numberOfDeferredUploadRequests = new AgentAtomicIntegerImpl();
    }

    private class FileSearcher
    extends Thread {
        private volatile File[] files;
        private File directory;
        private String simpleFileName;
        private String[] fileNameRegexs;

        FileSearcher(File directory, String simpleFileName) {
            this.directory = directory;
            this.simpleFileName = simpleFileName;
            this.setDaemon(true);
        }

        FileSearcher(File directory, String[] fileNameRegexs) {
            this.directory = directory;
            this.fileNameRegexs = fileNameRegexs;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (pauseBeforeSearchingTime != 0L) {
                try {
                    Thread.sleep(pauseBeforeSearchingTime);
                }
                catch (InterruptedException e) {
                    DetectedJVM.this.logger.debug(e.toString(), (Throwable)e);
                }
            }
            File[] files = this.directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    boolean bReturn = false;
                    if (FileSearcher.this.simpleFileName != null) {
                        bReturn = file.getName().equals(FileSearcher.this.simpleFileName);
                    } else {
                        for (String nextRegex : FileSearcher.this.fileNameRegexs) {
                            if (!file.getName().matches(nextRegex)) continue;
                            bReturn = true;
                            break;
                        }
                    }
                    return bReturn;
                }
            });
            this.files = files;
        }

        File[] getFiles() {
            return this.files;
        }
    }
}

