/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.crashdetect;

import com.singularity.ee.agent.crashdetect.ICrashAnalyzer;
import com.singularity.ee.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

abstract class ACrashAnalyzerImpl
implements ICrashAnalyzer {
    protected static final String UNKNOWN_REASON = "Unknown";
    protected final File errorFile;
    protected final ILogger logger;
    protected String crashReason;
    protected long crashDateTime;
    protected boolean crashFileRead = false;

    ACrashAnalyzerImpl(File errorFile, ILogger logger) {
        this.errorFile = errorFile;
        this.logger = logger;
    }

    @Override
    public long getCrashTimestamp() {
        this.readAndAnalyzeCrashFile();
        if (this.crashDateTime > 0L) {
            return this.crashDateTime;
        }
        return this.errorFile.lastModified();
    }

    protected BufferedReader getReader() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.errorFile)));
        return reader;
    }

    @Override
    public abstract boolean matchesPID(long var1);

    protected abstract void readAndAnalyzeCrashFile();

    @Override
    public String getCrashReason() {
        if (this.crashReason == null) {
            this.readAndAnalyzeCrashFile();
        }
        return this.crashReason;
    }
}

