/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.impl;

import com.singularity.ee.agent.configuration.spi.AgentThreadListener;
import com.singularity.ee.agent.util.AgentSystemUtil;
import com.singularity.ee.agent.util.thread.AgentThread;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.javaspecific.scheduler.AgentExecutorFactory;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import java.lang.reflect.Field;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public class AgentSchedulerThreadPoolExecutorFactory {
    private final String INHERITABLE_THREAD_LOCALS = "inheritableThreadLocals";
    private final String IBM_ACCESS_CONTROL_CONTEXT = "accessControlContext";
    private final String INHERITED_ACCESS_CONTROL_CONTEXT = "inheritedAccessControlContext";
    private final String ACC_PROTECTION_DOMAIN_ARRAY_FIELD = "context";
    private ILogger logger;
    private AccessControlContext defaultCleanContext;
    private Field inheritableThreadLocalsField;
    private Field inheritedAccessControlContextField;
    private final AgentExecutorFactory executorFactory;

    public AgentSchedulerThreadPoolExecutorFactory(AgentExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public IAgentScheduledThreadPoolExecutor createExecutor(int poolSize, String name, List<AgentThreadListener> agentThreadListeners, ILogger logger) {
        return this.executorFactory.newScheduledThreadPool(poolSize, this.createThreadFactory(name, agentThreadListeners), logger);
    }

    IAgentScheduledThreadPoolExecutor createExecutor(int poolSize, int maxTasksAllowed, BoundsPolicy policy, ICustomAction customAction, String name, List<AgentThreadListener> agentThreadListeners, ILogger logger) {
        return this.executorFactory.newScheduledThreadPool(poolSize, maxTasksAllowed, policy, customAction, this.createThreadFactory(name, agentThreadListeners), logger);
    }

    IAgentScheduledThreadPoolExecutor createNonPauseExecutor(int poolSize, ILogger logger, String name, List<AgentThreadListener> agentThreadListeners) {
        return this.executorFactory.newNonPausedScheduledThreadPool(poolSize, this.createThreadFactory(name, agentThreadListeners), logger);
    }

    private ThreadFactory createThreadFactory(final String name, final List<AgentThreadListener> agentThreadListeners) {
        return new ThreadFactory(){
            int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = AgentSchedulerThreadPoolExecutorFactory.this.removeParentContext(new AgentThread(r, name + this.i++));
                t.setDaemon(true);
                for (AgentThreadListener listener : agentThreadListeners) {
                    listener.registerThread(t);
                }
                return t;
            }
        };
    }

    private Thread removeParentContext(Thread t) {
        try {
            if (this.inheritedAccessControlContextField != null && this.defaultCleanContext != null) {
                this.inheritedAccessControlContextField.set(t, this.defaultCleanContext);
            }
            if (this.inheritableThreadLocalsField != null) {
                this.inheritableThreadLocalsField.set(t, null);
            }
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Could not set field in class Thread.", (Throwable)e);
        }
        if (AgentSystemUtil.useAgentClassLoaderAsContext()) {
            t.setContextClassLoader(AgentSchedulerThreadPoolExecutorFactory.class.getClassLoader());
        }
        return t;
    }

    public synchronized void init(ILogger logger) {
        AccessControlContext parentACC;
        block14: {
            this.logger = logger;
            try {
                this.inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
                this.inheritableThreadLocalsField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                logger.warn("InheritableThreadLocals field in class Thread not found.", (Throwable)e);
            }
            try {
                this.inheritedAccessControlContextField = Thread.class.getDeclaredField("inheritedAccessControlContext");
                this.inheritedAccessControlContextField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                try {
                    this.inheritedAccessControlContextField = Thread.class.getDeclaredField("accessControlContext");
                    this.inheritedAccessControlContextField.setAccessible(true);
                }
                catch (NoSuchFieldException e1) {
                    logger.warn("InheritedAccessControlContext field in class Thread not found.", (Throwable)e1);
                }
            }
            parentACC = AccessController.getContext();
            try {
                Field arrayField = AccessControlContext.class.getDeclaredField("context");
                arrayField.setAccessible(true);
                ProtectionDomain[] protectionDomains = (ProtectionDomain[])arrayField.get(parentACC);
                if (protectionDomains != null) {
                    ClassLoader targetClassLoader = AgentSchedulerThreadPoolExecutorFactory.class.getClassLoader();
                    for (ProtectionDomain domain : protectionDomains) {
                        if (!domain.getClassLoader().equals(targetClassLoader)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Found Agent ProtectionDomain and creating new AccessControlContext");
                        }
                        this.defaultCleanContext = new AccessControlContext(new ProtectionDomain[]{domain});
                        break block14;
                    }
                    break block14;
                }
                if (logger != null) {
                    logger.warn(String.format("Unable to find ProtectionDomain array for %s", parentACC));
                }
            }
            catch (NoSuchFieldException e) {
                logger.warn("Could not find field in class AccessControlContext", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Error creating default ProtectionDomain.", (Throwable)e);
            }
        }
        if (this.defaultCleanContext == null) {
            this.defaultCleanContext = parentACC;
            logger.warn("Unable to create default AccessControlContext, will use parent's AccessControlContext.");
        }
    }
}

