/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.identity;

import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.agent.configuration.identity.XMLIdentityManagerHelper;
import com.singularity.ee.agent.resolver.AgentAccountInfo;
import com.singularity.ee.agent.resolver.IAgentAccountInfoResolver;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;

public class XMLAgentAccountInfoResolver
implements IAgentAccountInfoResolver {
    private final ILogger logger;
    private final String[] identityConfigFilePath;
    private AgentAccountInfo agentAccountInfo;

    public XMLAgentAccountInfoResolver(ILogger logger, String ... identityFilePath) {
        this.identityConfigFilePath = identityFilePath;
        this.logger = logger;
    }

    @Override
    public AgentAccountInfo getAgentAccountInfo() {
        return this.agentAccountInfo;
    }

    @Override
    public void cancelResolution() {
    }

    @Override
    public void cleanUpAfterRun() {
    }

    @Override
    public String getName() {
        return "XML Agent Account Info Resolver";
    }

    @Override
    public boolean resolutionSucceeded() {
        return this.agentAccountInfo != null;
    }

    @Override
    public boolean resolveAsync() {
        return false;
    }

    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        String accountName = null;
        String accountAccessKey = null;
        for (String nextConfigFile : this.identityConfigFilePath) {
            if (nextConfigFile == null || !XMLIdentityManagerHelper.checkIfFileExistsOrDotNet(nextConfigFile)) continue;
            String[] accountNameAndAccessKey = this.getAccountNameAndAccessKeyFromConfigFile(nextConfigFile);
            if (StringOperations.isEmpty(accountName) && !StringOperations.isEmpty((String)accountNameAndAccessKey[0])) {
                accountName = accountNameAndAccessKey[0];
            }
            if (StringOperations.isEmpty(accountAccessKey) && !StringOperations.isEmpty((String)accountNameAndAccessKey[1])) {
                accountAccessKey = accountNameAndAccessKey[1];
            }
            if (StringOperations.isNotEmpty(accountName) && StringOperations.isNotEmpty(accountAccessKey)) break;
        }
        if (StringOperations.isEmpty(accountName)) {
            this.logger.info(this.getName() + " did not find account name. Using default account name [" + "customer1" + "]");
            accountName = "customer1";
        }
        if (StringOperations.isEmpty(accountAccessKey)) {
            this.logger.warn(this.getName() + " did not find account access key.");
        }
        this.agentAccountInfo = new AgentAccountInfo(accountName, accountAccessKey, false);
        this.logger.debug(this.getName() + " finished running");
    }

    private String[] getAccountNameAndAccessKeyFromConfigFile(String configFile) {
        Document xmlDoc = null;
        String accountName = null;
        String accountAccessKey = null;
        try {
            xmlDoc = XMLParseUtility.getXMLDocument((String)configFile, (String)"Agent Identity XML File", (ILogger)this.logger);
        }
        catch (Exception e) {
            this.logger.error("Error reading identity xml file", (Throwable)e);
        }
        if (xmlDoc != null) {
            String accountAccessKeyValue;
            Element rootElement = xmlDoc.getDocumentElement();
            String accountNameValue = XMLParseUtility.getTextForTagForElement((Node)rootElement, (String)"account-name");
            if (!StringOperations.isEmpty((String)accountNameValue)) {
                if (accountNameValue.startsWith("$")) {
                    this.logger.info(this.getName() + " did not find account name since [" + accountNameValue + "] is considered a token only. Using default account name [" + "customer1" + "]");
                    accountName = "customer1";
                } else {
                    this.logger.info(this.getName() + " using account name [" + accountNameValue + "]");
                    accountName = accountNameValue;
                }
            }
            if (!StringOperations.isEmpty((String)(accountAccessKeyValue = XMLParseUtility.getTextForTagForElement((Node)rootElement, (String)"account-access-key")))) {
                if (accountAccessKeyValue.startsWith("$")) {
                    this.logger.info(this.getName() + " did not find account access key since [" + accountAccessKeyValue + "] is considered a token only. Please specify a valid value if it is not already set in system properties.");
                } else {
                    this.logger.info(this.getName() + " using account access key [****]");
                    accountAccessKey = accountAccessKeyValue;
                }
            }
        }
        return new String[]{accountName, accountAccessKey};
    }
}

