/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.identity;

import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.agent.configuration.identity.TagNames;
import com.singularity.ee.agent.configuration.identity.XMLAgentAccountInfoResolver;
import com.singularity.ee.agent.configuration.identity.XMLIdentityManager;
import com.singularity.ee.agent.resolver.AWSResolver;
import com.singularity.ee.agent.resolver.AgentResolver;
import com.singularity.ee.agent.resolver.CloudInstanceIPAddressResolver;
import com.singularity.ee.agent.resolver.CloudResolver;
import com.singularity.ee.agent.resolver.DefaultAgentAccountInfoResolver;
import com.singularity.ee.agent.resolver.DefaultControllerInfoResolver;
import com.singularity.ee.agent.resolver.DefaultHostIdentifierResolver;
import com.singularity.ee.agent.resolver.DefaultIPAddressResolver;
import com.singularity.ee.agent.resolver.FullAgentRegistrationInfoResolver;
import com.singularity.ee.agent.resolver.ISelfServiceNameProvider;
import com.singularity.ee.agent.resolver.KubernetesResolver;
import com.singularity.ee.agent.resolver.ResolverGroup;
import com.singularity.ee.agent.resolver.VMWareResolver;
import com.singularity.ee.agent.util.container.ContainerIdExtractor;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.File;

public class AgentResolverUtil
extends TagNames {
    private static ResolverGroup getBasicResolverGroup(ILogger logger, ISelfServiceNameProvider selfServiceNameProvider, String ... configFilePath) {
        ResolverGroup group = new ResolverGroup(logger);
        group.addResolver(new DefaultControllerInfoResolver(logger));
        group.addResolver(new KubernetesResolver(logger, ContainerIdExtractor.getInstance()));
        group.addResolver(new DefaultHostIdentifierResolver(logger, configFilePath));
        group.addResolver(new DefaultIPAddressResolver(logger));
        group.addResolver(new DefaultAgentAccountInfoResolver(logger));
        group.addResolver(new FullAgentRegistrationInfoResolver(logger, selfServiceNameProvider, configFilePath));
        group.addResolver(new XMLIdentityManager(logger, configFilePath));
        group.addResolver(new XMLAgentAccountInfoResolver(logger, configFilePath));
        return group;
    }

    public static AgentResolverState getAgentResolverState(ILogger logger, String configFilePath) {
        return AgentResolverUtil.getAgentResolverState(logger, null, configFilePath);
    }

    public static AgentResolverState getAgentResolverState(ILogger logger, ISelfServiceNameProvider selfServiceNameProvider, String ... configFilePath) {
        AgentResolver agentResolver = new AgentResolver(logger);
        boolean isOrchestrationEnabled = AgentResolverUtil.enableOrchestration(logger, configFilePath);
        boolean isVirtualizationResolversEnabled = AgentResolverUtil.enableVirtualizationResolvers(isOrchestrationEnabled, logger, configFilePath);
        if (isVirtualizationResolversEnabled) {
            ResolverGroup virtualizationGroup = new ResolverGroup(logger);
            virtualizationGroup.addResolver(new CloudInstanceIPAddressResolver(logger));
            virtualizationGroup.addResolver(new AWSResolver(logger));
            virtualizationGroup.addResolver(new CloudResolver(logger));
            virtualizationGroup.addResolver(new VMWareResolver(logger));
            agentResolver.addResolverGroup(virtualizationGroup);
            logger.debug("Adding virtualization resolvers to the agent resolver.");
        }
        ResolverGroup basicGroup = AgentResolverUtil.getBasicResolverGroup(logger, selfServiceNameProvider, configFilePath);
        agentResolver.addResolverGroup(basicGroup);
        return new AgentResolverState(agentResolver, isOrchestrationEnabled, isVirtualizationResolversEnabled);
    }

    private static boolean enableVirtualizationResolvers(boolean enableOrchestration, ILogger logger, String ... configFilePath) {
        try {
            String enableResolvers = SystemUtils.getProperty((String)"appdynamics.agent.enableVirtualizationResolvers");
            if (enableResolvers == null) {
                for (String nextConfigFile : configFilePath) {
                    Document xmlDoc;
                    if (nextConfigFile != null && new File(nextConfigFile).exists() && !StringOperations.isEmpty((String)(enableResolvers = XMLParseUtility.getTextForTagForElement((Node)(xmlDoc = XMLParseUtility.getXmlDocumentFromFile((File)new File(nextConfigFile))).getDocumentElement(), (String)"enable-virtualization-resolvers")))) break;
                }
            }
            if (enableOrchestration) {
                if (enableResolvers != null && !Boolean.parseBoolean(enableResolvers)) {
                    logger.info("Orchestration is enabled - but virtualization resolvers were disabled explicitly.");
                    return false;
                }
                logger.info("Orchestration is enabled - enabling virtualization resolvers by default.");
                return true;
            }
            if (enableResolvers != null && Boolean.parseBoolean(enableResolvers)) {
                logger.info("Orchestration is disabled - but virtualization resolvers were enabled explicitly.");
                return true;
            }
            logger.info("Orchestration is disabled - disabling virtualization resolvers by default.");
            return false;
        }
        catch (Exception e) {
            logger.error("Virtualization resolvers are disabled since the [enable-virtualization-resolvers] property check failed", (Throwable)e);
            return false;
        }
    }

    private static boolean enableOrchestration(ILogger logger, String ... configFilePath) {
        try {
            Document xmlDoc;
            String nextPath;
            boolean propEnableOrchestration = Boolean.parseBoolean(SystemUtils.getProperty((String)"appdynamics.agent.enableOrchestration"));
            if (propEnableOrchestration) {
                return true;
            }
            String enableOrchestration = null;
            String[] stringArray = configFilePath;
            int n = stringArray.length;
            for (int i = 0; !(i >= n || (nextPath = stringArray[i]) != null && new File(nextPath).exists() && (enableOrchestration = XMLParseUtility.getTextForTagForElement((Node)(xmlDoc = XMLParseUtility.getXmlDocumentFromFile((File)new File(nextPath))).getDocumentElement(), (String)"enable-orchestration")) != null); ++i) {
            }
            if (enableOrchestration == null) {
                return false;
            }
            return Boolean.parseBoolean(enableOrchestration);
        }
        catch (Exception e) {
            logger.error("Orchestration is disabled since the [enable-orchestration] property check failed", (Throwable)e);
            return false;
        }
    }

    public static class AgentResolverState {
        private final AgentResolver agentResolver;
        private final boolean orchestrationEnabled;
        private final boolean virtualizationResolversEnabled;

        public AgentResolverState(AgentResolver agentResolver, boolean orchestrationEnabled, boolean virtualizationResolversEnabled) {
            this.agentResolver = agentResolver;
            this.orchestrationEnabled = orchestrationEnabled;
            this.virtualizationResolversEnabled = virtualizationResolversEnabled;
        }

        public AgentResolver getAgentResolver() {
            return this.agentResolver;
        }

        public boolean isOrchestrationEnabled() {
            return this.orchestrationEnabled;
        }

        public boolean isVirtualizationResolversEnabled() {
            return this.virtualizationResolversEnabled;
        }
    }
}

