/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.identity;

import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.httpclient.TrustManagerShouldDoDefaultValidation;
import com.singularity.ee.util.javaspecific.mutable.ADBoolean;
import com.singularity.ee.util.string.StringOperations;

public class AgentIdentity {
    private volatile String controllerHost;
    private volatile String machineInstanceID;
    private volatile String agentID;
    private volatile String nodeID;
    private volatile String componentID;
    private volatile int controllerPort;
    private volatile String authToken;
    private volatile String userName;
    private volatile ADBoolean controllerSSLEnabled;
    private volatile String keystoreFileName;
    private volatile String keystorePassword;
    private volatile String credentialStoreFileName;
    private volatile String credentialStorePassword;
    private volatile String credentialStoreFormat;
    private volatile ADBoolean useEncryptedCredentials;
    private volatile String asymmetricKeysStoreFilename;
    private volatile String asymmetricKeysStorePassword;
    private volatile String asymmetricKeyPassword;
    private volatile String asymmetricKeyAlias;
    private volatile ADBoolean useSslClientAuth;
    private volatile int validation = EnumHelper.getOrdinal((Enum)TrustManagerShouldDoDefaultValidation.UNSPECIFIED);

    public AgentIdentity(String controllerHost, String machineInstanceID, int controllerPort, String userName, String password, ADBoolean controllerSSLEnabled, TrustManagerShouldDoDefaultValidation validation) {
        this.controllerHost = controllerHost;
        this.machineInstanceID = machineInstanceID;
        this.controllerPort = controllerPort;
        this.userName = userName;
        this.keystorePassword = password;
        this.controllerSSLEnabled = controllerSSLEnabled;
        this.setValidation(validation);
    }

    public AgentIdentity(String controllerHost, String machineInstanceID, int controllerPort) {
        this.controllerHost = controllerHost;
        this.machineInstanceID = machineInstanceID;
        this.controllerPort = controllerPort;
    }

    public AgentIdentity(String controllerHost, int controllerPort) {
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
    }

    public String getControllerHost() {
        return this.controllerHost;
    }

    public void setControllerHost(String controllerHost) {
        this.controllerHost = controllerHost;
    }

    public String getMachineInstanceID() {
        return this.machineInstanceID;
    }

    public void setMachineInstanceID(String machineInstanceID) {
        this.machineInstanceID = machineInstanceID;
    }

    public String getAgentID() {
        return this.agentID;
    }

    public void setAgentID(String agentID) {
        this.agentID = agentID;
    }

    public int getControllerPort() {
        return this.controllerPort;
    }

    public void setControllerPort(int controllerPort) {
        this.controllerPort = controllerPort;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public String getComponentID() {
        return this.componentID;
    }

    public void setComponentID(String componentID) {
        this.componentID = componentID;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ADBoolean isControllerSSLEnabled() {
        return this.controllerSSLEnabled;
    }

    public void setControllerSSLEnabled(ADBoolean controllerSSLEnabled) {
        this.controllerSSLEnabled = controllerSSLEnabled;
    }

    public ADBoolean getControllerSSLEnabled() {
        return this.controllerSSLEnabled;
    }

    public boolean getUseEncryptedCredentialsPrimitive() {
        return this.useEncryptedCredentials != null ? this.useEncryptedCredentials.get() : false;
    }

    public void setUseEncryptedCredentials(boolean useEncryptedCredentials) {
        this.useEncryptedCredentials = new ADBoolean(useEncryptedCredentials);
    }

    public ADBoolean getUseEncryptedCredentials() {
        return this.useEncryptedCredentials;
    }

    public boolean getUseSslClientAuthPrimitive() {
        return this.useSslClientAuth != null ? this.useSslClientAuth.get() : false;
    }

    public void setUseSslClientAuth(boolean useSslClientAuth) {
        this.useSslClientAuth = new ADBoolean(useSslClientAuth);
    }

    public ADBoolean getUseSslClientAuth() {
        return this.useSslClientAuth;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Controller Host: ").append(this.controllerHost);
        sb.append(";").append(" Controller Port: ").append(this.controllerPort).append("; ssl-enabled: ").append(this.controllerSSLEnabled).append("; keyStoreFile: ").append(this.keystoreFileName).append("; use-encrypted-credentials: ").append(this.useEncryptedCredentials).append("; secureCredentialStoreFileName: ").append(this.credentialStoreFileName).append("; secureCredentialStorePassword: ").append(this.credentialStorePassword).append("; secureCredentialStoreFormat: ").append(this.credentialStoreFormat).append("; use-ssl-client-auth: ").append(this.useSslClientAuth).append("; asymmetric-keystore-filename: ").append(this.asymmetricKeysStoreFilename).append("; asymmetric-keystore-password: ").append(this.asymmetricKeysStorePassword).append("; asymmetric-key-password: ").append(this.asymmetricKeyPassword).append("; asymmetric-key-alias: ").append(this.asymmetricKeyAlias);
        if (this.keystorePassword != null) {
            sb.append("; keyStorePassword: ").append(this.keystorePassword);
        }
        if (this.machineInstanceID != null) {
            sb.append(";").append(" Machine Instance ID: ").append(this.machineInstanceID);
        }
        if (this.nodeID != null) {
            sb.append(";").append(" Node ID: ").append(this.nodeID);
        }
        return sb.toString();
    }

    public String getKeystoreFileName() {
        return this.keystoreFileName;
    }

    public void setKeystoreFileName(String keystoreFileName) {
        this.keystoreFileName = keystoreFileName;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getCredentialStoreFileName() {
        return this.credentialStoreFileName;
    }

    public void setCredentialStoreFileName(String credentialStoreFileName) {
        this.credentialStoreFileName = credentialStoreFileName;
    }

    public String getCredentialStorePassword() {
        return this.credentialStorePassword;
    }

    public void setCredentialStorePassword(String credentialStorePassword) {
        this.credentialStorePassword = credentialStorePassword;
    }

    public String getCredentialStoreFormat() {
        return this.credentialStoreFormat;
    }

    public void setCredentialStoreFormat(String credentialStoreFormat) {
        this.credentialStoreFormat = credentialStoreFormat;
    }

    public String getAsymmetricKeysStoreFilename() {
        return this.asymmetricKeysStoreFilename;
    }

    public void setAsymmetricKeysStoreFilename(String asymmetricKeysStoreFilename) {
        this.asymmetricKeysStoreFilename = asymmetricKeysStoreFilename;
    }

    public String getAsymmetricKeysStorePassword() {
        return this.asymmetricKeysStorePassword;
    }

    public void setAsymmetricKeysStorePassword(String asymmetricKeysStorePassword) {
        this.asymmetricKeysStorePassword = asymmetricKeysStorePassword;
    }

    public String getAsymmetricKeyPassword() {
        return this.asymmetricKeyPassword;
    }

    public void setAsymmetricKeyPassword(String asymmetricKeyPassword) {
        this.asymmetricKeyPassword = asymmetricKeyPassword;
    }

    public String getAsymmetricKeyAlias() {
        return this.asymmetricKeyAlias;
    }

    public void setAsymmetricKeyAlias(String asymmetricKeyAlias) {
        this.asymmetricKeyAlias = asymmetricKeyAlias;
    }

    public void setValidation(TrustManagerShouldDoDefaultValidation validation) {
        this.validation = EnumHelper.getOrdinal((Enum)validation);
    }

    public TrustManagerShouldDoDefaultValidation getValidation() {
        return ((TrustManagerShouldDoDefaultValidation[])EnumHelper.getValues(TrustManagerShouldDoDefaultValidation.class))[this.validation];
    }

    public void mergeNewAgentIdentity(AgentIdentity newAgentIdentity) {
        if (StringOperations.isEmpty((String)this.controllerHost)) {
            this.controllerHost = newAgentIdentity.controllerHost;
        }
        if (StringOperations.isEmpty((String)this.machineInstanceID)) {
            this.machineInstanceID = newAgentIdentity.machineInstanceID;
        }
        if (StringOperations.isEmpty((String)this.nodeID)) {
            this.nodeID = newAgentIdentity.nodeID;
        }
        if (StringOperations.isEmpty((String)this.componentID)) {
            this.componentID = newAgentIdentity.componentID;
        }
        if (this.controllerPort <= 0) {
            this.controllerPort = newAgentIdentity.controllerPort;
        }
        if (StringOperations.isEmpty((String)this.keystorePassword)) {
            this.keystorePassword = newAgentIdentity.keystorePassword;
        }
        if (StringOperations.isEmpty((String)this.authToken)) {
            this.authToken = newAgentIdentity.authToken;
        }
        if (StringOperations.isEmpty((String)this.userName)) {
            this.userName = newAgentIdentity.userName;
        }
        if (this.controllerSSLEnabled == null) {
            this.controllerSSLEnabled = newAgentIdentity.controllerSSLEnabled;
        }
        if (this.useEncryptedCredentials == null) {
            this.useEncryptedCredentials = newAgentIdentity.useEncryptedCredentials;
        }
        if (this.useSslClientAuth == null) {
            this.useSslClientAuth = newAgentIdentity.useSslClientAuth;
        }
        if (StringOperations.isEmpty((String)this.keystoreFileName)) {
            this.keystoreFileName = newAgentIdentity.keystoreFileName;
        }
        if (StringOperations.isEmpty((String)this.credentialStorePassword)) {
            this.credentialStorePassword = newAgentIdentity.credentialStorePassword;
        }
        if (StringOperations.isEmpty((String)this.credentialStoreFormat)) {
            this.credentialStoreFormat = newAgentIdentity.credentialStoreFormat;
        }
        if (StringOperations.isEmpty((String)this.credentialStoreFileName)) {
            this.credentialStoreFileName = newAgentIdentity.credentialStoreFileName;
        }
        if (StringOperations.isEmpty((String)this.asymmetricKeysStorePassword)) {
            this.asymmetricKeysStorePassword = newAgentIdentity.asymmetricKeysStorePassword;
        }
        if (StringOperations.isEmpty((String)this.asymmetricKeyPassword)) {
            this.asymmetricKeyPassword = newAgentIdentity.asymmetricKeyPassword;
        }
        if (StringOperations.isEmpty((String)this.asymmetricKeyAlias)) {
            this.asymmetricKeyAlias = newAgentIdentity.asymmetricKeyAlias;
        }
        if (StringOperations.isEmpty((String)this.asymmetricKeysStoreFilename)) {
            this.asymmetricKeysStoreFilename = newAgentIdentity.asymmetricKeysStoreFilename;
        }
        if (this.validation == EnumHelper.getOrdinal((Enum)TrustManagerShouldDoDefaultValidation.UNSPECIFIED)) {
            this.validation = newAgentIdentity.validation;
        }
    }

    public boolean isComplete() {
        return !StringOperations.isEmpty((String)this.controllerHost) && !StringOperations.isEmpty((String)this.machineInstanceID) && !StringOperations.isEmpty((String)this.nodeID) && !StringOperations.isEmpty((String)this.componentID) && this.controllerPort > 0 && !StringOperations.isEmpty((String)this.keystorePassword) && !StringOperations.isEmpty((String)this.authToken) && !StringOperations.isEmpty((String)this.userName) && this.controllerSSLEnabled != null && this.useEncryptedCredentials != null && this.useSslClientAuth != null && !StringOperations.isEmpty((String)this.keystoreFileName) && !StringOperations.isEmpty((String)this.credentialStorePassword) && !StringOperations.isEmpty((String)this.credentialStoreFileName) && !StringOperations.isEmpty((String)this.credentialStoreFormat) && !StringOperations.isEmpty((String)this.asymmetricKeysStorePassword) && !StringOperations.isEmpty((String)this.asymmetricKeyPassword) && !StringOperations.isEmpty((String)this.asymmetricKeyAlias) && !StringOperations.isEmpty((String)this.asymmetricKeysStoreFilename);
    }
}

