/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.channel;

import com.singularity.ee.agent.configuration.channel.AConfigurationState;
import com.singularity.ee.agent.configuration.channel.ConfigRequestOutcome;
import com.singularity.ee.agent.configuration.channel.IConfigurationChannel;
import com.singularity.ee.agent.configuration.channel.IConfigurationContext;
import com.singularity.ee.config.IConfigurationListener;
import com.singularity.ee.config.IConfigurationRequest;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.AgentPollingConfigurationRequest;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;

public abstract class PollingForUpdate
extends AConfigurationState {
    private final ILogger logger;
    public static final int MAX_FAILURE_COUNT = 5;
    private static final String INVALID_MACHINE = "Invalid machine";
    private static final String ASSOCIATED_DELETED = "Application/Tier/Node that this machine agent was associated with may have been deleted";
    private static final String ATTEMPT_REREGISTER = "The machine agent should attempt to re-register itself";

    protected PollingForUpdate(IConfigurationChannel channel, ILogger logger) {
        super(channel);
        this.logger = logger;
    }

    @Override
    public void nextTransition(IConfigurationContext context) {
        ConfigRequestOutcome outcome = this.pollForConfigUpdate();
        switch (outcome) {
            case FAILED_AND_WAITING: {
                break;
            }
            case MACHINE_NOT_FOUND: {
                context.stopPolling();
                break;
            }
        }
    }

    private ConfigRequestOutcome pollForConfigUpdate() {
        AgentPollingConfigurationRequest configResponse;
        this.logger.debug("Polling for config update");
        IConfigurationChannel channel = this.getChannel();
        String controllerHost = channel.getControllerHost();
        int controllerPort = channel.getControllerPort();
        String machineId = channel.getMachineId();
        String agentId = channel.getAgentId();
        AgentPollingConfigurationRequest request = this.getConfigurationRequest(controllerHost, controllerPort, machineId, agentId, this.logger);
        for (IConfigurationListener configurationListener : this.getChannel().getConfigListeners()) {
            configurationListener.setLastUpdatedConfiguration((IConfigurationRequest)request);
        }
        HttpExecutionResponse response = request.sendRequest();
        if (response.isExceptionHappened() || response.isStatusNotOk()) {
            this.logger.warn("Invalid response for configuration request from controller/could not connect. Msg: " + response.getExceptionMessage());
            this.getChannel().incrementConsecutiveFailureCount();
            if (this.getChannel().getConsecutiveFailureCount() >= 5) {
                this.logger.warn("System configuration request failed 5 times consecutively.");
                return ConfigRequestOutcome.FAILED_AND_WAITING;
            }
            return ConfigRequestOutcome.FAILED;
        }
        this.getChannel().resetConsecutiveFailureCount();
        try {
            configResponse = this.getConfigurationResponse((IHttpExecutionResponse)response);
        }
        catch (ResponseReadException e) {
            this.logger.error("Error reading response from Controller", (Throwable)e);
            String errorMessage = e.getMessage();
            if (errorMessage != null && errorMessage.contains(INVALID_MACHINE) && errorMessage.contains(ASSOCIATED_DELETED) && errorMessage.contains(ATTEMPT_REREGISTER)) {
                this.logger.info("No Machine found associated with this Machine Id '" + request.getMachineId() + "', corresponding future task will be cancelled");
                return ConfigRequestOutcome.MACHINE_NOT_FOUND;
            }
            return ConfigRequestOutcome.FAILED;
        }
        for (IConfigurationListener listener : this.getChannel().getConfigListeners()) {
            listener.configurationChanged((IConfigurationRequest)configResponse);
        }
        return ConfigRequestOutcome.SUCCEEDED;
    }

    protected abstract AgentPollingConfigurationRequest getConfigurationResponse(IHttpExecutionResponse var1) throws ResponseReadException;

    protected abstract AgentPollingConfigurationRequest getConfigurationRequest(String var1, int var2, String var3, String var4, ILogger var5);
}

