/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.channel;

import com.singularity.ee.agent.configuration.channel.IConfigurationChannel;
import com.singularity.ee.agent.configuration.channel.IConfigurationContext;
import com.singularity.ee.config.IConfigurationListener;
import java.util.HashSet;
import java.util.Set;

public class AgentConfigurationChannel
implements IConfigurationChannel {
    private IConfigurationContext context;
    private final Set<IConfigurationListener> configListeners;
    private final String controllerHost;
    private final int controllerPort;
    private final String machineId;
    private final String agentId;
    private int consecutiveFailureCount = 0;

    protected AgentConfigurationChannel(String controllerHost, int controllerPort, String machineId, String agentId) {
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.machineId = machineId;
        this.agentId = agentId;
        this.configListeners = new HashSet<IConfigurationListener>();
    }

    @Override
    public IConfigurationContext getConfigurationContext() {
        return this.context;
    }

    protected void setConfigurationContext(IConfigurationContext context) {
        this.context = context;
    }

    @Override
    public void refreshConfiguration() {
        this.context.getCurrentState().nextTransition(this.context);
    }

    @Override
    public String getControllerHost() {
        return this.controllerHost;
    }

    @Override
    public int getControllerPort() {
        return this.controllerPort;
    }

    @Override
    public String getMachineId() {
        return this.machineId;
    }

    @Override
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    public int getConsecutiveFailureCount() {
        return this.consecutiveFailureCount;
    }

    @Override
    public void incrementConsecutiveFailureCount() {
        ++this.consecutiveFailureCount;
    }

    @Override
    public void resetConsecutiveFailureCount() {
        this.consecutiveFailureCount = 0;
    }

    @Override
    public void registerPropertyListener(IConfigurationListener propertyListener) {
        if (propertyListener != null) {
            this.configListeners.add(propertyListener);
        }
    }

    @Override
    public void unRegisterPropertyListener(IConfigurationListener propertyListener) {
        this.configListeners.remove(propertyListener);
    }

    @Override
    public Set<IConfigurationListener> getConfigListeners() {
        return this.configListeners;
    }
}

