/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.channel;

import com.singularity.ee.agent.configuration.channel.AgentConfigurationChannel;
import com.singularity.ee.agent.configuration.channel.AgentConfigurationRefreshTask;
import com.singularity.ee.agent.configuration.channel.IConfigurationChannel;
import com.singularity.ee.config.IConfigurationListener;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;

public abstract class AgentConfigManager {
    private final ILogger logger;
    public static final int INITIAL_DELAY = 5;
    public static final int DEFAULT_REFRESH_INTERVAL = 60;
    private static volatile int refreshInterval = 60;
    private IConfigurationChannel channel;
    private IAgentScheduledFuture refreshTaskFuture;

    protected AgentConfigManager(AgentConfigurationChannel channel, IAgentScheduledExecutorService scheduler, ILogger logger) {
        this.channel = channel;
        this.logger = logger;
        this.initialize(scheduler, refreshInterval);
    }

    protected AgentConfigManager(AgentConfigurationChannel channel, IAgentScheduledExecutorService scheduler, int refreshInterval, ILogger logger) {
        this.channel = channel;
        this.logger = logger;
        this.initialize(scheduler, refreshInterval);
    }

    private void initialize(IAgentScheduledExecutorService scheduler, int newRefreshInterval) {
        refreshInterval = newRefreshInterval;
        String configInterval = System.getProperty("config.interval");
        if (configInterval != null) {
            refreshInterval = Integer.parseInt(configInterval);
        }
        this.logger.info("Scheduling configuration refresh at an interval of " + refreshInterval + " seconds");
        AgentConfigurationRefreshTask refreshTask = new AgentConfigurationRefreshTask(this.channel, this.logger);
        this.refreshTaskFuture = scheduler.scheduleWithFixedDelay((IAgentRunnable)refreshTask, 5L, (long)refreshInterval, AgentTimeUnit.SECONDS);
        refreshTask.setFuture(this.refreshTaskFuture);
        refreshTask.setConfigManager(this);
        this.logger.info("Configuration refresh task interval is " + refreshInterval + " seconds");
    }

    public void registerConfigListener(IConfigurationListener propertyListener) {
        this.channel.registerPropertyListener(propertyListener);
    }

    public void unregisterConfigListener(IConfigurationListener propertyListener) {
        this.channel.unRegisterPropertyListener(propertyListener);
    }

    public static void setRefreshInterval(int refreshInterval) {
        AgentConfigManager.refreshInterval = refreshInterval;
    }

    public void disable() {
        this.refreshTaskFuture.cancel(true);
        this.channel = null;
        this.refreshTaskFuture = null;
    }

    public void nonInterruptingDisable() {
        if (this.refreshTaskFuture != null) {
            this.refreshTaskFuture.cancel(false);
            this.refreshTaskFuture = null;
        }
        this.channel = null;
    }

    public IConfigurationChannel getChannel() {
        return this.channel;
    }
}

