/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.transientoperations;

import com.singularity.ee.agent.commonservices.timeskewhandling.spi.IControllerTimeSkewHandler;
import com.singularity.ee.agent.commonservices.transientoperations.ITransientSessionOperationCallback;
import com.singularity.ee.agent.commonservices.transientoperations.ITransientSessionOperationsHandler;
import com.singularity.ee.agent.util.javalang.ADLong;
import com.singularity.ee.controller.api.constants.TransientOperationConstants;
import com.singularity.ee.controller.api.dto.transientoperations.ITransientOperationParameters;
import com.singularity.ee.controller.api.dto.transientoperations.TransientBTSnapshotConfig;
import com.singularity.ee.events.ITransientOperationInfo;
import com.singularity.ee.events.TransientEventData;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.collections.ArrayUtils;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.javaspecific.collections.ADIterator;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.string.StringOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class ATransientEventChannel {
    protected final ILogger logger;
    protected Map<TransientOperationConstants.SESSION_TYPE, ITransientSessionOperationsHandler> handlers;
    LinkedBlockingQueue<ITransientOperationInfo> workQueue;
    LinkedBlockingQueue<TransientEventData> eventsToSend;
    private static final int DEFAULT_POLLING_FREQUENCY_IN_MILLIS = 1000;
    private static final int DEFAULT_MAX_INACTIVITY_TIME_PERIOD_IN_MILLIS = 1800000;
    int keepAliveTimeInMillis = 1800000;
    volatile boolean stopRunning = false;
    private IAgentScheduledExecutorService scheduler;
    private volatile IAgentScheduledFuture pollerFuture;
    ADConcurrentHashMap<TransientOperationConstants.SESSION_TYPE, String> activeSessions;
    ADConcurrentHashMap<TransientOperationConstants.SESSION_TYPE, ADLong> activityTimestamps;
    protected IControllerTimeSkewHandler timeSkewHandler;
    private Callback transientOperationCallback;

    protected ATransientEventChannel(ILogger logger, IControllerTimeSkewHandler timeSkewHandler, Map<TransientOperationConstants.SESSION_TYPE, ITransientSessionOperationsHandler> handlers, IAgentScheduledExecutorService scheduler) {
        this.logger = logger;
        this.timeSkewHandler = timeSkewHandler;
        this.handlers = handlers;
        this.activeSessions = new ADConcurrentHashMap(1);
        this.activityTimestamps = new ADConcurrentHashMap(1);
        this.workQueue = new LinkedBlockingQueue();
        this.eventsToSend = new LinkedBlockingQueue();
        this.scheduler = scheduler;
        this.transientOperationCallback = new Callback(this, this.eventsToSend);
    }

    private final void startSession(ITransientOperationInfo transientOperationInfo) {
        TransientOperationConstants.SESSION_TYPE sessionType = (TransientOperationConstants.SESSION_TYPE)EnumHelper.getEnum(TransientOperationConstants.SESSION_TYPE.class, (String)transientOperationInfo.getSessionType());
        if (this.activeSessions.putIfAbsent((Object)sessionType, (Object)transientOperationInfo.getSessionId()) == null) {
            this.startSessionInternal(transientOperationInfo.getSessionId(), sessionType);
        } else {
            String existingSessionID = (String)this.activeSessions.get((Object)sessionType);
            if (null != existingSessionID && !existingSessionID.equals(transientOperationInfo.getSessionId())) {
                this.stopSession(existingSessionID, sessionType);
                this.startSession(transientOperationInfo);
            }
        }
    }

    private final void startSessionInternal(String newSessionId, TransientOperationConstants.SESSION_TYPE sessionType) {
        this.stopRunning = false;
        if (!this.isChannelActive()) {
            this.startChannel(1000);
        }
        this.notifyOperationHandlers(newSessionId, sessionType, EnumHelper.getNameForEnumConstant((Enum)TransientOperationConstants.OPERATIONS.START_SESSION, (Enum)TransientOperationConstants.OPERATIONS.START_SESSION));
        this.activityTimestamps.put((Object)sessionType, (Object)new ADLong(ClockUtils.getCurrentTime()));
        this.logger.info("Started session for sessionType [" + sessionType + "]");
    }

    public <T extends ITransientOperationInfo> void handleOperations(List<T> operations) {
        this.executeOperations(operations);
    }

    private void notifyOperationHandlers(String sessionID, TransientOperationConstants.SESSION_TYPE sessionType, String operationName) {
        TransientOperationConstants.OPERATIONS operation = (TransientOperationConstants.OPERATIONS)EnumHelper.getEnum(TransientOperationConstants.OPERATIONS.class, (String)operationName);
        ITransientSessionOperationsHandler handler = this.handlers.get(sessionType);
        switch (operation) {
            case START_SESSION: {
                handler.startSession(sessionID);
                break;
            }
            case END_SESSION: {
                handler.endSession(sessionID);
            }
        }
    }

    private boolean isChannelActive() {
        return this.pollerFuture != null;
    }

    final void stopChannel() {
        this.stopRunning = true;
        if (null != this.pollerFuture) {
            this.cancelPollingTask(this.pollerFuture);
            this.pollerFuture = null;
        }
        this.logger.info("######### Stopped the transient event channel ########");
    }

    protected void cancelPollingTask(IAgentScheduledFuture future) {
        future.cancel(true);
    }

    private final void startChannel(int pollingFrequencyInMillis) {
        this.pollerFuture = this.scheduler.scheduleAtFixedRate((IAgentRunnable)new EventChannelPollingTask(this), 0L, (long)pollingFrequencyInMillis, AgentTimeUnit.MILLISECONDS);
        this.logger.info("########  Started the transient event channel ########");
    }

    protected void stopSession(String sessionId, TransientOperationConstants.SESSION_TYPE sessionType) {
        String existingSessionID = (String)this.activeSessions.get((Object)sessionType);
        if (null != existingSessionID && existingSessionID.equals(sessionId)) {
            this.notifyOperationHandlers(sessionId, sessionType, EnumHelper.getNameForEnumConstant((Enum)TransientOperationConstants.OPERATIONS.END_SESSION, (Enum)TransientOperationConstants.OPERATIONS.END_SESSION));
            this.activeSessions.remove((Object)sessionType);
            this.activityTimestamps.remove((Object)sessionType);
            this.logger.info("Ended session for sessionType [" + sessionType + "]");
        } else {
            this.logger.warn("Session type [" + sessionType + "] with session ID does not exist.");
        }
    }

    public void hotEnable() {
        this.stopRunning = false;
    }

    public void hotDisable() {
        this.stopRunning = true;
        ADIterator it = this.activeSessions.keySetIterator();
        while (it.hasNext()) {
            TransientOperationConstants.SESSION_TYPE sessionType = (TransientOperationConstants.SESSION_TYPE)it.next();
            ITransientSessionOperationsHandler handler = this.handlers.get(sessionType);
            this.stopSession(handler.getSessionID(), sessionType);
        }
        this.activeSessions.clear();
        this.activityTimestamps.clear();
        this.eventsToSend.clear();
        this.workQueue.clear();
    }

    private <T extends ITransientOperationInfo> Collection<TransientEventData> executeOperations(List<T> requests) {
        ArrayList<TransientEventData> result = new ArrayList<TransientEventData>();
        for (ITransientOperationInfo operationInfo : requests) {
            TransientEventData event;
            TransientOperationConstants.SESSION_TYPE sessionType = (TransientOperationConstants.SESSION_TYPE)EnumHelper.getEnum(TransientOperationConstants.SESSION_TYPE.class, (String)operationInfo.getSessionType());
            TransientOperationConstants.OPERATIONS operation = (TransientOperationConstants.OPERATIONS)EnumHelper.getEnum(TransientOperationConstants.OPERATIONS.class, (String)operationInfo.getOperation());
            this.logOperationsReceived(operationInfo);
            String sessionID = (String)this.activeSessions.get((Object)sessionType);
            if (TransientOperationConstants.OPERATIONS.START_SESSION == operation) {
                this.startSession(operationInfo);
                continue;
            }
            if (TransientOperationConstants.OPERATIONS.END_SESSION == operation) {
                this.stopSession(operationInfo.getSessionId(), sessionType);
                continue;
            }
            if (null == sessionID || !sessionID.equals(operationInfo.getSessionId())) {
                this.startSession(operationInfo);
                event = this.executeOperationInternal(operationInfo);
                if (null == event) continue;
                result.add(event);
                continue;
            }
            event = this.executeOperationInternal(operationInfo);
            if (null == event) continue;
            result.add(event);
        }
        return result;
    }

    protected void logOperationsReceived(ITransientOperationInfo operationInfo) {
        StringBuilder sb = new StringBuilder();
        if (this.logger.isInfoEnabled()) {
            StringOperations.resetLength((StringBuilder)sb);
            sb.append("Received operation [").append(operationInfo.getOperation()).append("], sessionType [").append(operationInfo.getSessionType()).append("], opId [").append(operationInfo.getOpId()).append("]");
            if (operationInfo.getNvpList() != null && operationInfo.getNvpList().length > 0) {
                ITransientOperationParameters[] params = operationInfo.getNvpList();
                if (params[0] instanceof TransientBTSnapshotConfig) {
                    TransientBTSnapshotConfig config = (TransientBTSnapshotConfig)params[0];
                    sb.append(", param [").append(config.getBtName()).append(", ").append(config.getEntryPointType()).append("]");
                }
            } else {
                sb.append("  opParams = EMPTY");
            }
            this.logger.info(sb.toString());
        }
    }

    private TransientEventData executeOperationInternal(ITransientOperationInfo operationInfo) {
        TransientOperationConstants.SESSION_TYPE sessionType = (TransientOperationConstants.SESSION_TYPE)EnumHelper.getEnum(TransientOperationConstants.SESSION_TYPE.class, (String)operationInfo.getSessionType());
        ITransientSessionOperationsHandler handler = this.handlers.get(sessionType);
        if (null != handler) {
            this.activityTimestamps.put((Object)sessionType, (Object)new ADLong(ClockUtils.getCurrentTime()));
            if (operationInfo.shouldExecuteAsynchronously() || handler.getTransientOperationsSessionType() == TransientOperationConstants.SESSION_TYPE.LIVE_MODE) {
                handler.executeOperationAsynchronously(operationInfo, this.transientOperationCallback);
            } else {
                TransientEventData event = handler.executeOperationSynchronously(operationInfo);
                if (null != event) {
                    return event;
                }
            }
        }
        return null;
    }

    protected abstract List<ITransientOperationInfo> getOperationsFromController(ILogger var1) throws Exception;

    protected abstract List<ITransientOperationInfo> sendEventsToController(List<TransientEventData> var1, ILogger var2) throws Exception;

    static class Callback
    implements ITransientSessionOperationCallback {
        private final ATransientEventChannel channel;
        private LinkedBlockingQueue<TransientEventData> eventsToSend;

        Callback(ATransientEventChannel channel, LinkedBlockingQueue<TransientEventData> eventsToSend) {
            this.channel = channel;
            this.eventsToSend = eventsToSend;
        }

        @Override
        public void addOperationResults(TransientOperationConstants.SESSION_TYPE sessionType, Set<TransientEventData> eventsToSend) {
            this.channel.activityTimestamps.put((Object)sessionType, (Object)new ADLong(ClockUtils.getCurrentTime()));
            if (eventsToSend.size() > 0) {
                CollectionHelper.addAll(this.eventsToSend, eventsToSend);
            }
        }
    }

    static class EventChannelPollingTask
    implements IAgentRunnable {
        final List<TransientEventData> _eventsToSend = new ArrayList<TransientEventData>();
        final List<ITransientOperationInfo> _requestsToExecute = new ArrayList<ITransientOperationInfo>();
        private final ATransientEventChannel channel;

        EventChannelPollingTask(ATransientEventChannel channel) {
            this.channel = channel;
        }

        public void run() {
            if (this.channel.logger.isTraceEnabled()) {
                this.channel.logger.trace("ENTER " + ReflectionUtilityCommon.getName(EventChannelPollingTask.class) + ".run()");
            }
            try {
                if (this.channel.stopRunning) {
                    return;
                }
                this.handleOperations();
                this.sendEvents();
                this.checkForInActivity();
            }
            catch (Throwable e) {
                this.channel.logger.error("Error in transient event processing loop :  ", e);
            }
            finally {
                if (this.channel.logger.isTraceEnabled()) {
                    this.channel.logger.trace("EXIT " + ReflectionUtilityCommon.getName(EventChannelPollingTask.class) + ".run()");
                }
            }
        }

        private void handleOperations() {
            this._requestsToExecute.clear();
            try {
                this.handleNewOperationsArrived(this.channel.getOperationsFromController(this.channel.logger));
            }
            catch (Exception e) {
                this.channel.logger.error("Error occurred while receiving operations from controller : ", (Throwable)e);
            }
            if (!this.channel.workQueue.isEmpty()) {
                this.channel.workQueue.drainTo(this._requestsToExecute);
                for (ITransientOperationInfo op : this._requestsToExecute) {
                    try {
                        List opList = CollectionHelper.asList((Object[])new ITransientOperationInfo[]{op});
                        Collection result = this.channel.executeOperations(opList);
                        CollectionHelper.addAll(this.channel.eventsToSend, (Collection)result);
                        this.sendEvents();
                    }
                    catch (Exception e) {
                        this.channel.logger.error("Error occurred while executing transient operation -  Session Type: " + op.getSessionType() + " Operation Id: " + op.getOpId() + " Operation: " + op.getOperation(), (Throwable)e);
                    }
                }
            }
        }

        private void handleNewOperationsArrived(List<ITransientOperationInfo> operations) {
            if (null != operations && operations.size() > 0) {
                ArrayList<String> ops = new ArrayList<String>(operations.size());
                for (ITransientOperationInfo operation : operations) {
                    ops.add(operation.getOperation());
                }
                if (this.channel.logger.isInfoEnabled()) {
                    int maxLength = 1024;
                    this.channel.logger.info("New operations arrived: " + ArrayUtils.objectArrayListToString(ops, (int)maxLength));
                }
                CollectionHelper.addAll(this.channel.workQueue, operations);
            }
        }

        private void sendEvents() {
            try {
                for (ITransientSessionOperationsHandler operationsHandler : this.channel.handlers.values()) {
                    List<TransientEventData> eventsToSend = operationsHandler.getEventsToSend();
                    if (null == eventsToSend || eventsToSend.size() <= 0) continue;
                    TransientOperationConstants.SESSION_TYPE sessionType = operationsHandler.getTransientOperationsSessionType();
                    this.channel.activityTimestamps.put((Object)sessionType, (Object)new ADLong(ClockUtils.getCurrentTime()));
                    CollectionHelper.addAll(this.channel.eventsToSend, eventsToSend);
                }
                if (!this.channel.eventsToSend.isEmpty()) {
                    this.channel.eventsToSend.drainTo(this._eventsToSend);
                    List<ITransientOperationInfo> operations = this.channel.sendEventsToController(this._eventsToSend, this.channel.logger);
                    this.handleNewOperationsArrived(operations);
                    this._eventsToSend.clear();
                }
            }
            catch (Exception e) {
                this.channel.logger.error("Error occurred during sending events : ", (Throwable)e);
            }
        }

        private void checkForInActivity() {
            long currentTime = ClockUtils.getCurrentTime();
            StringBuilder sb = new StringBuilder();
            ADIterator it = this.channel.activityTimestamps.keySetIterator();
            while (it.hasNext()) {
                TransientOperationConstants.SESSION_TYPE sessionType = (TransientOperationConstants.SESSION_TYPE)it.next();
                ADLong lastActivityTime = (ADLong)this.channel.activityTimestamps.get((Object)sessionType);
                if (currentTime - lastActivityTime.get() <= (long)this.channel.keepAliveTimeInMillis) continue;
                StringOperations.setLength((StringBuilder)sb, (int)0);
                String sessionID = (String)this.channel.activeSessions.get((Object)sessionType);
                ITransientSessionOperationsHandler handler = this.channel.handlers.get(sessionType);
                handler.endSession(sessionID);
                sb.append("Transient Session for ").append("sessionType [").append(sessionType).append("] ").append("will be stopped due to expiration of Max Inactivity Period [").append(this.channel.keepAliveTimeInMillis).append("] ms");
                this.channel.logger.info(sb.toString());
                this.channel.stopSession(sessionID, sessionType);
            }
            if (this.channel.activityTimestamps.isADCHMEmpty()) {
                this.channel.logger.info("No active sessions exist. The transient event channel will be terminated.");
                this.channel.stopChannel();
            }
        }
    }
}

